/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import cn.trinea.android.common.service.FileNameRule;
import cn.trinea.android.common.util.FileUtils;
import cn.trinea.android.common.util.StringUtils;

public class FileNameRuleImageUrl
implements FileNameRule {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_FILE_NAME = "ImageSDCardCacheFile.jpg";
    public static final int MAX_FILE_NAME_LENGTH = 127;
    private String fileExtension = null;

    @Override
    public String getFileName(String imageUrl) {
        if (StringUtils.isEmpty(imageUrl)) {
            return DEFAULT_FILE_NAME;
        }
        String ext = this.fileExtension == null ? FileUtils.getFileExtension(imageUrl) : this.fileExtension;
        String fileName = (imageUrl.length() > 127 ? imageUrl.substring(imageUrl.length() - 127, imageUrl.length()) : imageUrl).replaceAll("[\\W]", "_");
        return StringUtils.isEmpty(ext) ? fileName : fileName + "." + ext.replaceAll("[\\W]", "_");
    }

    public FileNameRuleImageUrl setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }
}

