/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.service.CacheFullRemoveType;
import cn.trinea.android.common.service.FileNameRule;
import cn.trinea.android.common.service.impl.FileNameRuleImageUrl;
import cn.trinea.android.common.service.impl.ImageMemoryCache;
import cn.trinea.android.common.service.impl.ImageSDCardCache;
import cn.trinea.android.common.service.impl.PreloadDataCache;
import cn.trinea.android.common.service.impl.RemoveTypeUsedCountSmall;
import cn.trinea.android.common.util.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Map;

public class ImageCache
extends ImageMemoryCache {
    private static final long serialVersionUID = 1L;
    private ImageSDCardCache secondaryCache;
    private int compressSize = 1;
    private CompressListener compressListener;
    public static final String DEFAULT_CACHE_FOLDER = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Trinea" + File.separator + "AndroidCommon" + File.separator + "ImageCache";

    public ImageCache() {
        this(ImageMemoryCache.DEFAULT_MAX_SIZE, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE, ImageSDCardCache.DEFAULT_MAX_SIZE, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageCache(int primaryCacheMaxSize) {
        this(primaryCacheMaxSize, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE, ImageSDCardCache.DEFAULT_MAX_SIZE, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageCache(int primaryCacheMaxSize, int secondaryCacheMaxSize) {
        this(primaryCacheMaxSize, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE, secondaryCacheMaxSize, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageCache(int primaryCacheMaxSize, int primaryCacheThreadPoolSize, int secondaryCacheMaxSize, int secondaryCacheThreadPoolSize) {
        super(primaryCacheMaxSize, primaryCacheThreadPoolSize);
        this.setOnGetDataListener(new PreloadDataCache.OnGetDataListener<String, Bitmap>(){
            private static final long serialVersionUID = 1L;

            @Override
            public CacheObject<Bitmap> onGetData(String key) {
                try {
                    String imagePath;
                    CacheObject object = ImageCache.this.secondaryCache.get(key);
                    String string = imagePath = object == null ? null : (String)object.getData();
                    if (FileUtils.isFileExist(imagePath)) {
                        Bitmap bm;
                        if (ImageCache.this.compressListener != null) {
                            ImageCache.this.compressSize = ImageCache.this.compressListener.getCompressSize(imagePath);
                        }
                        if (ImageCache.this.compressSize > 1) {
                            BitmapFactory.Options option = new BitmapFactory.Options();
                            option.inSampleSize = ImageCache.this.compressSize;
                            bm = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)option);
                        } else {
                            bm = BitmapFactory.decodeFile((String)imagePath);
                        }
                        return bm == null ? null : new CacheObject<Bitmap>(bm);
                    }
                    ImageCache.this.secondaryCache.remove(key);
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        super.setCheckNetwork(false);
        this.setCacheFullRemoveType(new RemoveTypeUsedCountSmall());
        this.secondaryCache = new ImageSDCardCache(secondaryCacheMaxSize, secondaryCacheThreadPoolSize);
        this.secondaryCache.setCacheFolder(DEFAULT_CACHE_FOLDER);
        this.secondaryCache.setFileNameRule(new FileNameRuleImageUrl().setFileExtension(""));
    }

    public int getCompressSize() {
        return this.compressSize;
    }

    public void setCompressSize(int compressSize) {
        this.compressSize = compressSize;
    }

    public void setCompressListener(CompressListener compressListener) {
        this.compressListener = compressListener;
    }

    public CompressListener getCompressListener() {
        return this.compressListener;
    }

    @Override
    public int getHttpReadTimeOut() {
        return this.secondaryCache.getHttpReadTimeOut();
    }

    @Override
    public void setHttpReadTimeOut(int readTimeOutMillis) {
        this.secondaryCache.setHttpReadTimeOut(readTimeOutMillis);
    }

    @Override
    public void clear() {
        super.clear();
        this.secondaryCache.clear();
    }

    @Override
    public void setForwardCacheNumber(int forwardCacheNumber) {
        super.setForwardCacheNumber(forwardCacheNumber);
        this.secondaryCache.setForwardCacheNumber(forwardCacheNumber);
    }

    @Override
    public void setBackwardCacheNumber(int backwardCacheNumber) {
        super.setForwardCacheNumber(backwardCacheNumber);
        this.secondaryCache.setForwardCacheNumber(backwardCacheNumber);
    }

    @Override
    public int getAllowedNetworkTypes() {
        return this.secondaryCache.getAllowedNetworkTypes();
    }

    @Override
    public void setAllowedNetworkTypes(int allowedNetworkTypes) {
        this.secondaryCache.setAllowedNetworkTypes(allowedNetworkTypes);
    }

    @Override
    public boolean isCheckNetwork() {
        return this.secondaryCache.isCheckNetwork();
    }

    @Override
    public void setCheckNetwork(boolean isCheckNetwork) {
        this.secondaryCache.setCheckNetwork(isCheckNetwork);
    }

    @Override
    public boolean checkIsNetworkTypeAllowed() {
        return this.secondaryCache.checkIsNetworkTypeAllowed();
    }

    @Override
    public Context getContext() {
        return this.secondaryCache.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.secondaryCache.setContext(context);
    }

    @Override
    public void setRequestProperties(Map<String, String> requestProperties) {
        this.secondaryCache.setRequestProperties(requestProperties);
    }

    @Override
    public Map<String, String> getRequestProperties() {
        return this.secondaryCache.getRequestProperties();
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.secondaryCache.setRequestProperty(field, newValue);
    }

    public String getCacheFolder() {
        return this.secondaryCache.getCacheFolder();
    }

    public void setCacheFolder(String cacheFolder) {
        this.secondaryCache.setCacheFolder(cacheFolder);
    }

    public FileNameRule getFileNameRule() {
        return this.secondaryCache.getFileNameRule();
    }

    public void setFileNameRule(FileNameRule fileNameRule) {
        this.secondaryCache.setFileNameRule(fileNameRule);
    }

    public void initData(Context context, String tag) {
        this.loadDataFromDb(context, tag);
        this.deleteUnusedFiles();
    }

    public void deleteUnusedFiles() {
        this.secondaryCache.deleteUnusedFiles();
    }

    public boolean loadDataFromDb(Context context, String tag) {
        return ImageSDCardCache.loadDataFromDb(context, this.secondaryCache, tag);
    }

    public boolean saveDataToDb(Context context, String tag) {
        return ImageSDCardCache.saveDataToDb(context, this.secondaryCache, tag);
    }

    public String getImagePath(String imageUrl) {
        return this.secondaryCache.getImagePath(imageUrl);
    }

    @Override
    protected void shutdown() {
        this.secondaryCache.shutdown();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.secondaryCache.shutdownNow();
        return super.shutdownNow();
    }

    public PreloadDataCache.OnGetDataListener<String, Bitmap> getOnGetImageListenerOfPrimaryCache() {
        return this.getOnGetDataListener();
    }

    public void setOnGetImageListenerOfPrimaryCache(PreloadDataCache.OnGetDataListener<String, Bitmap> onGetImageListener) {
        this.onGetDataListener = onGetImageListener;
    }

    public PreloadDataCache.OnGetDataListener<String, String> getOnGetImageListenerOfSecondaryCache() {
        return this.secondaryCache.getOnGetDataListener();
    }

    public void setOnGetImageListenerOfSecondaryCache(PreloadDataCache.OnGetDataListener<String, String> onGetImageListener) {
        this.secondaryCache.setOnGetDataListener(onGetImageListener);
    }

    public CacheFullRemoveType<String> getCacheFullRemoveTypeOfSecondaryCache() {
        return this.secondaryCache.getCacheFullRemoveType();
    }

    public void setCacheFullRemoveTypeOfSecondaryCache(CacheFullRemoveType<String> cacheFullRemoveType) {
        this.secondaryCache.setCacheFullRemoveType(cacheFullRemoveType);
    }

    public static interface CompressListener {
        public int getCompressSize(String var1);
    }
}

