/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.entity.FailedReason;
import cn.trinea.android.common.service.impl.PreloadDataCache;
import cn.trinea.android.common.service.impl.RemoveTypeUsedCountSmall;
import cn.trinea.android.common.util.ImageUtils;
import cn.trinea.android.common.util.StringUtils;
import cn.trinea.android.common.util.SystemUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageMemoryCache
extends PreloadDataCache<String, Bitmap> {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "ImageCache";
    private OnImageCallbackListener onImageCallbackListener;
    private int httpReadTimeOut = -1;
    private boolean isOpenWaitingQueue = true;
    private Map<String, String> requestProperties = null;
    public static final int DEFAULT_MAX_SIZE = ImageMemoryCache.getDefaultMaxSize();
    private static final int WHAT_GET_IMAGE_SUCCESS = 1;
    private static final int WHAT_GET_IMAGE_FAILED = 2;
    private transient ExecutorService threadPool = Executors.newFixedThreadPool(SystemUtils.DEFAULT_THREAD_POOL_SIZE);
    private transient Map<String, View> viewMap;
    private transient Map<String, HashSet<View>> viewSetMap;
    private transient Handler handler;

    public boolean get(String imageUrl, View view) {
        return this.get(imageUrl, null, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(String imageUrl, List<String> urlList, View view) {
        if (this.onImageCallbackListener != null) {
            this.onImageCallbackListener.onPreGet(imageUrl, view);
        }
        if (StringUtils.isEmpty(imageUrl)) {
            if (this.onImageCallbackListener != null) {
                this.onImageCallbackListener.onGetNotInCache(imageUrl, view);
            }
            return false;
        }
        CacheObject object = this.getFromCache(imageUrl, urlList);
        if (object != null) {
            Bitmap bitmap = (Bitmap)object.getData();
            if (bitmap != null) {
                this.onGetSuccess(imageUrl, bitmap, view, true);
                return true;
            }
            this.remove(imageUrl);
        }
        if (this.isOpenWaitingQueue) {
            Map<String, HashSet<View>> map = this.viewSetMap;
            synchronized (map) {
                HashSet<Object> viewSet = this.viewSetMap.get(imageUrl);
                if (viewSet == null) {
                    viewSet = new HashSet();
                    this.viewSetMap.put(imageUrl, viewSet);
                }
                viewSet.add(view);
            }
        } else {
            this.viewMap.put(imageUrl, view);
        }
        if (this.onImageCallbackListener != null) {
            this.onImageCallbackListener.onGetNotInCache(imageUrl, view);
        }
        if (this.isExistGettingDataThread(imageUrl)) {
            return false;
        }
        this.startGetImageThread(imageUrl, urlList);
        return false;
    }

    public OnImageCallbackListener getOnImageCallbackListener() {
        return this.onImageCallbackListener;
    }

    public void setOnImageCallbackListener(OnImageCallbackListener onImageCallbackListener) {
        this.onImageCallbackListener = onImageCallbackListener;
    }

    public int getHttpReadTimeOut() {
        return this.httpReadTimeOut;
    }

    public void setHttpReadTimeOut(int readTimeOutMillis) {
        this.httpReadTimeOut = readTimeOutMillis;
    }

    public boolean isOpenWaitingQueue() {
        return this.isOpenWaitingQueue;
    }

    public void setOpenWaitingQueue(boolean isOpenWaitingQueue) {
        this.isOpenWaitingQueue = isOpenWaitingQueue;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperty(String field, String newValue) {
        if (StringUtils.isEmpty(field)) {
            return;
        }
        if (this.requestProperties == null) {
            this.requestProperties = new HashMap<String, String>();
        }
        this.requestProperties.put(field, newValue);
    }

    public ImageMemoryCache() {
        this(DEFAULT_MAX_SIZE, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageMemoryCache(int maxSize) {
        this(maxSize, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageMemoryCache(int maxSize, int threadPoolSize) {
        super(maxSize, threadPoolSize);
        super.setOnGetDataListener(this.getDefaultOnGetImageListener());
        super.setCacheFullRemoveType(new RemoveTypeUsedCountSmall());
        this.viewMap = new ConcurrentHashMap<String, View>();
        this.viewSetMap = new HashMap<String, HashSet<View>>();
        this.handler = new MyHandler();
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
    }

    @Override
    protected void shutdown() {
        this.threadPool.shutdown();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.threadPool.shutdownNow();
        return super.shutdownNow();
    }

    private void onGetSuccess(String imageUrl, Bitmap loadedImage, View view, boolean isInCache) {
        if (this.onImageCallbackListener == null) {
            return;
        }
        try {
            this.onImageCallbackListener.onGetSuccess(imageUrl, loadedImage, view, isInCache);
        }
        catch (OutOfMemoryError e) {
            this.onImageCallbackListener.onGetFailed(imageUrl, loadedImage, view, new FailedReason(FailedReason.FailedType.ERROR_OUT_OF_MEMORY, e));
        }
    }

    private void startGetImageThread(final String imageUrl, final List<String> urlList) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Bitmap bitmap;
                    CacheObject object = ImageMemoryCache.this.get(imageUrl, urlList);
                    Bitmap bitmap2 = bitmap = object == null ? null : (Bitmap)object.getData();
                    if (bitmap == null) {
                        ImageMemoryCache.this.remove(imageUrl);
                        String failedException = "get image from network or save image to sdcard error. please make sure you have added permission android.permission.WRITE_EXTERNAL_STORAGE and android.permission.ACCESS_NETWORK_STATE";
                        FailedReason failedReason = new FailedReason(FailedReason.FailedType.ERROR_IO, failedException);
                        ImageMemoryCache.this.handler.sendMessage(ImageMemoryCache.this.handler.obtainMessage(2, (Object)new MessageObject(imageUrl, bitmap, failedReason)));
                    } else {
                        ImageMemoryCache.this.handler.sendMessage(ImageMemoryCache.this.handler.obtainMessage(1, (Object)new MessageObject(imageUrl, bitmap)));
                    }
                }
                catch (OutOfMemoryError e) {
                    MessageObject msg = new MessageObject(imageUrl, null, new FailedReason(FailedReason.FailedType.ERROR_OUT_OF_MEMORY, e));
                    ImageMemoryCache.this.handler.sendMessage(ImageMemoryCache.this.handler.obtainMessage(2, (Object)msg));
                }
            }
        });
    }

    public PreloadDataCache.OnGetDataListener<String, Bitmap> getDefaultOnGetImageListener() {
        return new PreloadDataCache.OnGetDataListener<String, Bitmap>(){
            private static final long serialVersionUID = 1L;

            @Override
            public CacheObject<Bitmap> onGetData(String key) {
                Bitmap d = null;
                try {
                    d = ImageUtils.getBitmapFromUrl(key, ImageMemoryCache.this.httpReadTimeOut, ImageMemoryCache.this.requestProperties);
                }
                catch (Exception e) {
                    Log.e((String)ImageMemoryCache.TAG, (String)("get image exception, imageUrl is:" + key), (Throwable)e);
                }
                return d == null ? null : new CacheObject<Bitmap>(d);
            }
        };
    }

    static int getDefaultMaxSize() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory > 0x40000000L) {
            return 512;
        }
        int mb = (int)(maxMemory / 0x100000L);
        return mb > 16 ? mb * 2 : 16;
    }

    private class MessageObject {
        String imageUrl;
        Bitmap bitmap;
        FailedReason failedReason;

        public MessageObject(String imageUrl, Bitmap bitmap) {
            this.imageUrl = imageUrl;
            this.bitmap = bitmap;
        }

        public MessageObject(String imageUrl, Bitmap bitmap, FailedReason failedReason) {
            this.imageUrl = imageUrl;
            this.bitmap = bitmap;
            this.failedReason = failedReason;
        }
    }

    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: 
                case 2: {
                    Map map;
                    MessageObject object = (MessageObject)message.obj;
                    if (object == null) break;
                    String imageUrl = object.imageUrl;
                    Bitmap bitmap = object.bitmap;
                    if (ImageMemoryCache.this.onImageCallbackListener != null) {
                        if (ImageMemoryCache.this.isOpenWaitingQueue) {
                            map = ImageMemoryCache.this.viewSetMap;
                            synchronized (map) {
                                HashSet viewSet = (HashSet)ImageMemoryCache.this.viewSetMap.get(imageUrl);
                                if (viewSet != null) {
                                    for (View view : viewSet) {
                                        if (view == null) continue;
                                        if (1 == message.what) {
                                            ImageMemoryCache.this.onGetSuccess(imageUrl, bitmap, view, false);
                                            continue;
                                        }
                                        ImageMemoryCache.this.onImageCallbackListener.onGetFailed(imageUrl, bitmap, view, object.failedReason);
                                    }
                                }
                            }
                        } else {
                            View view = (View)ImageMemoryCache.this.viewMap.get(imageUrl);
                            if (view != null) {
                                if (1 == message.what) {
                                    ImageMemoryCache.this.onGetSuccess(imageUrl, bitmap, view, false);
                                } else {
                                    ImageMemoryCache.this.onImageCallbackListener.onGetFailed(imageUrl, bitmap, view, object.failedReason);
                                }
                            }
                        }
                    }
                    if (ImageMemoryCache.this.isOpenWaitingQueue) {
                        map = ImageMemoryCache.this.viewSetMap;
                        synchronized (map) {
                            ImageMemoryCache.this.viewSetMap.remove(imageUrl);
                            break;
                        }
                    }
                    ImageMemoryCache.this.viewMap.remove(imageUrl);
                }
            }
        }
    }

    public static interface OnImageCallbackListener {
        public void onPreGet(String var1, View var2);

        public void onGetNotInCache(String var1, View var2);

        public void onGetSuccess(String var1, Bitmap var2, View var3, boolean var4);

        public void onGetFailed(String var1, Bitmap var2, View var3, FailedReason var4);
    }
}

