/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import cn.trinea.android.common.dao.impl.ImageSDCardCacheDaoImpl;
import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.entity.FailedReason;
import cn.trinea.android.common.service.FileNameRule;
import cn.trinea.android.common.service.impl.FileNameRuleImageUrl;
import cn.trinea.android.common.service.impl.PreloadDataCache;
import cn.trinea.android.common.service.impl.RemoveTypeUsedCountSmall;
import cn.trinea.android.common.util.FileUtils;
import cn.trinea.android.common.util.ImageUtils;
import cn.trinea.android.common.util.SqliteUtils;
import cn.trinea.android.common.util.StringUtils;
import cn.trinea.android.common.util.SystemUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageSDCardCache
extends PreloadDataCache<String, String> {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "ImageSDCardCache";
    private OnImageSDCallbackListener onImageSDCallbackListener;
    private String cacheFolder = DEFAULT_CACHE_FOLDER;
    private FileNameRule fileNameRule = new FileNameRuleImageUrl();
    private int httpReadTimeOut = -1;
    private boolean isOpenWaitingQueue = true;
    private Map<String, String> requestProperties = null;
    public static final int DEFAULT_MAX_SIZE = ImageSDCardCache.getDefaultMaxSize();
    public static final String DEFAULT_CACHE_FOLDER = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Trinea" + File.separator + "AndroidCommon" + File.separator + "ImageSDCardCache";
    private static final int WHAT_GET_IMAGE_SUCCESS = 1;
    private static final int WHAT_GET_IMAGE_FAILED = 2;
    private transient ExecutorService threadPool = Executors.newFixedThreadPool(SystemUtils.DEFAULT_THREAD_POOL_SIZE);
    private transient Map<String, View> viewMap;
    private transient Map<String, HashSet<View>> viewSetMap;
    private transient Handler handler;

    public boolean get(String imageUrl, View view) {
        return this.get(imageUrl, null, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(String imageUrl, List<String> urlList, View view) {
        if (this.onImageSDCallbackListener != null) {
            this.onImageSDCallbackListener.onPreGet(imageUrl, view);
        }
        if (StringUtils.isEmpty(imageUrl)) {
            if (this.onImageSDCallbackListener != null) {
                this.onImageSDCallbackListener.onGetNotInCache(imageUrl, view);
            }
            return false;
        }
        CacheObject object = this.getFromCache(imageUrl, urlList);
        if (object != null) {
            String imagePath = (String)object.getData();
            if (!StringUtils.isEmpty(imagePath) && FileUtils.isFileExist(imagePath)) {
                this.onGetSuccess(imageUrl, imagePath, view, true);
                return true;
            }
            this.remove(imageUrl);
        }
        if (this.isOpenWaitingQueue) {
            Map<String, HashSet<View>> map = this.viewSetMap;
            synchronized (map) {
                HashSet<Object> viewSet = this.viewSetMap.get(imageUrl);
                if (viewSet == null) {
                    viewSet = new HashSet();
                    this.viewSetMap.put(imageUrl, viewSet);
                }
                viewSet.add(view);
            }
        } else {
            this.viewMap.put(imageUrl, view);
        }
        if (this.onImageSDCallbackListener != null) {
            this.onImageSDCallbackListener.onGetNotInCache(imageUrl, view);
        }
        if (this.isExistGettingDataThread(imageUrl)) {
            return false;
        }
        this.startGetImageThread(imageUrl, urlList);
        return false;
    }

    public String getCacheFolder() {
        return this.cacheFolder;
    }

    public void setCacheFolder(String cacheFolder) {
        if (StringUtils.isEmpty(cacheFolder)) {
            throw new IllegalArgumentException("The cacheFolder of cache can not be null.");
        }
        this.cacheFolder = cacheFolder;
    }

    public FileNameRule getFileNameRule() {
        return this.fileNameRule;
    }

    public void setFileNameRule(FileNameRule fileNameRule) {
        if (fileNameRule == null) {
            throw new IllegalArgumentException("The fileNameRule of cache can not be null.");
        }
        this.fileNameRule = fileNameRule;
    }

    public OnImageSDCallbackListener getOnImageSDCallbackListener() {
        return this.onImageSDCallbackListener;
    }

    public void setOnImageSDCallbackListener(OnImageSDCallbackListener onImageSDCallbackListener) {
        this.onImageSDCallbackListener = onImageSDCallbackListener;
    }

    public int getHttpReadTimeOut() {
        return this.httpReadTimeOut;
    }

    public void setHttpReadTimeOut(int readTimeOutMillis) {
        this.httpReadTimeOut = readTimeOutMillis;
    }

    public boolean isOpenWaitingQueue() {
        return this.isOpenWaitingQueue;
    }

    public void setOpenWaitingQueue(boolean isOpenWaitingQueue) {
        this.isOpenWaitingQueue = isOpenWaitingQueue;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    public void setRequestProperty(String field, String newValue) {
        if (StringUtils.isEmpty(field)) {
            return;
        }
        if (this.requestProperties == null) {
            this.requestProperties = new HashMap<String, String>();
        }
        this.requestProperties.put(field, newValue);
    }

    public ImageSDCardCache() {
        this(DEFAULT_MAX_SIZE, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageSDCardCache(int maxSize) {
        this(maxSize, PreloadDataCache.DEFAULT_THREAD_POOL_SIZE);
    }

    public ImageSDCardCache(int maxSize, int threadPoolSize) {
        super(maxSize, threadPoolSize);
        super.setOnGetDataListener(this.getDefaultOnGetImageListener());
        super.setCacheFullRemoveType(new RemoveTypeUsedCountSmall());
        this.viewMap = new ConcurrentHashMap<String, View>();
        this.viewSetMap = new HashMap<String, HashSet<View>>();
        this.handler = new MyHandler();
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
    }

    @Override
    protected void shutdown() {
        this.threadPool.shutdown();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.threadPool.shutdownNow();
        return super.shutdownNow();
    }

    private void onGetSuccess(String imageUrl, String imagePath, View view, boolean isInCache) {
        if (this.onImageSDCallbackListener == null) {
            return;
        }
        try {
            this.onImageSDCallbackListener.onGetSuccess(imageUrl, imagePath, view, isInCache);
        }
        catch (OutOfMemoryError e) {
            this.onImageSDCallbackListener.onGetFailed(imageUrl, imagePath, view, new FailedReason(FailedReason.FailedType.ERROR_OUT_OF_MEMORY, e));
        }
    }

    private void startGetImageThread(final String imageUrl, final List<String> urlList) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String imagePath;
                    CacheObject object = ImageSDCardCache.this.get(imageUrl, urlList);
                    String string = imagePath = object == null ? null : (String)object.getData();
                    if (StringUtils.isEmpty(imagePath) || !FileUtils.isFileExist(imagePath)) {
                        ImageSDCardCache.this.remove(imageUrl);
                        String failedException = "get image from network or save image to sdcard error. please make sure you have added permission android.permission.WRITE_EXTERNAL_STORAGE and android.permission.ACCESS_NETWORK_STATE";
                        FailedReason failedReason = new FailedReason(FailedReason.FailedType.ERROR_IO, failedException);
                        ImageSDCardCache.this.handler.sendMessage(ImageSDCardCache.this.handler.obtainMessage(2, (Object)new MessageObject(imageUrl, imagePath, failedReason)));
                    } else {
                        ImageSDCardCache.this.handler.sendMessage(ImageSDCardCache.this.handler.obtainMessage(1, (Object)new MessageObject(imageUrl, imagePath)));
                    }
                }
                catch (OutOfMemoryError e) {
                    MessageObject msg = new MessageObject(imageUrl, null, new FailedReason(FailedReason.FailedType.ERROR_OUT_OF_MEMORY, e));
                    ImageSDCardCache.this.handler.sendMessage(ImageSDCardCache.this.handler.obtainMessage(2, (Object)msg));
                }
            }
        });
    }

    @Override
    protected CacheObject<String> fullRemoveOne() {
        CacheObject<String> o = super.fullRemoveOne();
        if (o != null) {
            this.deleteFile(o.getData());
        }
        return o;
    }

    @Override
    public CacheObject<String> remove(String key) {
        CacheObject<String> o = super.remove(key);
        if (o != null) {
            this.deleteFile(o.getData());
        }
        return o;
    }

    @Override
    public void clear() {
        for (CacheObject value : this.values()) {
            if (value == null) continue;
            this.deleteFile((String)value.getData());
        }
        super.clear();
    }

    public void deleteUnusedFiles() {
        int size = this.getSize();
        final HashSet<String> filePathSet = new HashSet<String>(size > 16 ? size : 16);
        for (CacheObject value : this.values()) {
            if (value == null) continue;
            filePathSet.add((String)value.getData());
        }
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(ImageSDCardCache.this.getCacheFolder());
                    if (file != null && file.exists() && file.isDirectory()) {
                        File[] fileArray = file.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.isFile() && !filePathSet.contains(f.getPath())) {
                                f.delete();
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)ImageSDCardCache.TAG, (String)"delete unused files fail.");
                }
            }
        });
    }

    public void initData(Context context, String tag) {
        ImageSDCardCache.loadDataFromDb(context, this, tag);
        this.deleteUnusedFiles();
    }

    public boolean loadDataFromDb(Context context, String tag) {
        return ImageSDCardCache.loadDataFromDb(context, this, tag);
    }

    public boolean saveDataToDb(Context context, String tag) {
        return ImageSDCardCache.saveDataToDb(context, this, tag);
    }

    public static boolean loadDataFromDb(Context context, ImageSDCardCache imageSDCardCache, String tag) {
        if (context == null || imageSDCardCache == null) {
            throw new IllegalArgumentException("The context and cache both can not be null.");
        }
        if (StringUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("The tag can not be null or empty.");
        }
        return new ImageSDCardCacheDaoImpl(SqliteUtils.getInstance(context)).putIntoImageSDCardCache(imageSDCardCache, tag);
    }

    public static boolean saveDataToDb(Context context, ImageSDCardCache imageSDCardCache, String tag) {
        if (context == null || imageSDCardCache == null) {
            throw new IllegalArgumentException("The context and cache both can not be null.");
        }
        if (StringUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("The tag can not be null or empty.");
        }
        return new ImageSDCardCacheDaoImpl(SqliteUtils.getInstance(context)).deleteAndInsertImageSDCardCache(imageSDCardCache, tag);
    }

    public String getImagePath(String imageUrl) {
        return this.containsKey(imageUrl) ? this.cacheFolder + File.separator + this.fileNameRule.getFileName(imageUrl) : null;
    }

    private boolean deleteFile(String path) {
        if (!StringUtils.isEmpty(path) && !FileUtils.deleteFile(path)) {
            Log.e((String)TAG, (String)("delete file fail, path is " + path));
            return false;
        }
        return true;
    }

    public PreloadDataCache.OnGetDataListener<String, String> getDefaultOnGetImageListener() {
        return new PreloadDataCache.OnGetDataListener<String, String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public CacheObject<String> onGetData(String key) {
                String savePath = null;
                InputStream stream = null;
                try {
                    stream = ImageUtils.getInputStreamFromUrl(key, ImageSDCardCache.this.httpReadTimeOut, ImageSDCardCache.this.requestProperties);
                }
                catch (Exception e) {
                    Log.e((String)ImageSDCardCache.TAG, (String)("get image exception, imageUrl is:" + key), (Throwable)e);
                }
                if (stream != null) {
                    savePath = String.valueOf(ImageSDCardCache.this.cacheFolder) + File.separator + ImageSDCardCache.this.fileNameRule.getFileName(key);
                    try {
                        FileUtils.writeFile(savePath, stream);
                    }
                    catch (Exception e1) {
                        try {
                            if (e1.getCause() instanceof FileNotFoundException) {
                                FileUtils.makeFolders(savePath);
                                FileUtils.writeFile(savePath, stream);
                            } else {
                                Log.e((String)ImageSDCardCache.TAG, (String)("get image exception while write to file, imageUrl is: " + key + ", savePath is " + savePath), (Throwable)e1);
                            }
                        }
                        catch (Exception e2) {
                            Log.e((String)ImageSDCardCache.TAG, (String)("get image exception while write to file, imageUrl is: " + key + ", savePath is " + savePath), (Throwable)e2);
                        }
                    }
                }
                return StringUtils.isEmpty(savePath) ? null : new CacheObject<Object>(savePath);
            }
        };
    }

    static int getDefaultMaxSize() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory > 0x40000000L) {
            return 256;
        }
        int mb = (int)(maxMemory / 0x100000L);
        return mb > 8 ? mb : 8;
    }

    private class MessageObject {
        String imageUrl;
        String imagePath;
        FailedReason failedReason;

        public MessageObject(String imageUrl, String imagePath) {
            this.imageUrl = imageUrl;
            this.imagePath = imagePath;
        }

        public MessageObject(String imageUrl, String imagePath, FailedReason failedReason) {
            this.imageUrl = imageUrl;
            this.imagePath = imagePath;
            this.failedReason = failedReason;
        }
    }

    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: 
                case 2: {
                    Map map;
                    MessageObject object = (MessageObject)message.obj;
                    if (object == null) break;
                    String imageUrl = object.imageUrl;
                    String imagePath = object.imagePath;
                    if (ImageSDCardCache.this.onImageSDCallbackListener != null) {
                        if (ImageSDCardCache.this.isOpenWaitingQueue) {
                            map = ImageSDCardCache.this.viewSetMap;
                            synchronized (map) {
                                HashSet viewSet = (HashSet)ImageSDCardCache.this.viewSetMap.get(imageUrl);
                                if (viewSet != null) {
                                    for (View view : viewSet) {
                                        if (view == null) continue;
                                        if (1 == message.what) {
                                            ImageSDCardCache.this.onGetSuccess(imageUrl, imagePath, view, false);
                                            continue;
                                        }
                                        ImageSDCardCache.this.onImageSDCallbackListener.onGetFailed(imageUrl, imagePath, view, object.failedReason);
                                    }
                                }
                            }
                        } else {
                            View view = (View)ImageSDCardCache.this.viewMap.get(imageUrl);
                            if (view != null) {
                                if (1 == message.what) {
                                    ImageSDCardCache.this.onGetSuccess(imageUrl, imagePath, view, false);
                                } else {
                                    ImageSDCardCache.this.onImageSDCallbackListener.onGetFailed(imageUrl, imagePath, view, object.failedReason);
                                }
                            }
                        }
                    }
                    if (ImageSDCardCache.this.isOpenWaitingQueue) {
                        map = ImageSDCardCache.this.viewSetMap;
                        synchronized (map) {
                            ImageSDCardCache.this.viewSetMap.remove(imageUrl);
                            break;
                        }
                    }
                    ImageSDCardCache.this.viewMap.remove(imageUrl);
                }
            }
        }
    }

    public static interface OnImageSDCallbackListener {
        public void onPreGet(String var1, View var2);

        public void onGetNotInCache(String var1, View var2);

        public void onGetSuccess(String var1, String var2, View var3, boolean var4);

        public void onGetFailed(String var1, String var2, View var3, FailedReason var4);
    }
}

