/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.service.impl.SimpleCache;
import cn.trinea.android.common.util.ListUtils;
import cn.trinea.android.common.util.ObjectUtils;
import cn.trinea.android.common.util.SerializeUtils;
import cn.trinea.android.common.util.SystemUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PreloadDataCache<K, V>
extends SimpleCache<K, V> {
    private static final long serialVersionUID = 1L;
    private int forwardCacheNumber = 3;
    private int backwardCacheNumber = 1;
    private boolean isCheckNetwork = true;
    private int allowedNetworkTypes = -1;
    protected OnGetDataListener<K, V> onGetDataListener;
    private transient Map<K, GetDataThread> gettingDataThreadMap = new HashMap<K, GetDataThread>();
    private ExecutorService threadPool;
    private Context context;
    private transient ConnectivityManager connectivityManager;
    public static final int DEFAULT_FORWARD_CACHE_NUMBER = 3;
    public static final int DEFAULT_BACKWARD_CACHE_NUMBER = 1;
    public static final int DEFAULT_THREAD_POOL_SIZE = SystemUtils.getDefaultThreadPoolSize(8);
    public static final int NETWORK_MOBILE = 1;
    public static final int NETWORK_WIFI = 2;

    public CacheObject<V> get(K key, List<K> keyList) {
        if (key == null) {
            return null;
        }
        if (!ListUtils.isEmpty(keyList)) {
            this.preloadDataForward(key, keyList, this.forwardCacheNumber);
            this.preloadDataBackward(key, keyList, this.backwardCacheNumber);
        }
        return this.get(key);
    }

    @Override
    public CacheObject<V> get(K key) {
        if (key == null) {
            return null;
        }
        CacheObject object = super.get(key);
        if (object == null && this.onGetDataListener != null) {
            GetDataThread getDataThread = this.gettingData(key);
            if (getDataThread != null) {
                try {
                    getDataThread.finishGetDataLock.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((object = super.get(key)) != null) {
                this.hitCount.decrementAndGet();
            } else {
                this.missCount.decrementAndGet();
            }
        }
        return object;
    }

    CacheObject<V> getFromCache(K key) {
        return super.get(key);
    }

    CacheObject<V> getFromCache(K key, List<K> keyList) {
        if (key == null) {
            return null;
        }
        if (!ListUtils.isEmpty(keyList)) {
            this.preloadDataForward(key, keyList, this.forwardCacheNumber);
            this.preloadDataBackward(key, keyList, this.backwardCacheNumber);
        }
        return this.getFromCache(key);
    }

    protected int preloadDataForward(K key, List<K> keyList, int cacheCount) {
        int gettingDataCount = 0;
        if (key != null && !ListUtils.isEmpty(keyList) && this.onGetDataListener != null) {
            int cachedCount = 0;
            boolean beginCount = false;
            int i = 0;
            while (i < keyList.size() && cachedCount <= cacheCount) {
                K k = keyList.get(i);
                if (ObjectUtils.isEquals(k, key)) {
                    beginCount = true;
                } else if (k != null && beginCount) {
                    ++cachedCount;
                    if (this.gettingData(k) != null) {
                        ++gettingDataCount;
                    }
                }
                ++i;
            }
        }
        return gettingDataCount;
    }

    protected int preloadDataBackward(K key, List<K> keyList, int cacheCount) {
        int gettingDataCount = 0;
        if (key != null && !ListUtils.isEmpty(keyList) && this.onGetDataListener != null) {
            int cachedCount = 0;
            boolean beginCount = false;
            int i = keyList.size() - 1;
            while (i >= 0 && cachedCount <= cacheCount) {
                K k = keyList.get(i);
                if (ObjectUtils.isEquals(k, key)) {
                    beginCount = true;
                } else if (k != null && beginCount) {
                    ++cachedCount;
                    if (this.gettingData(k) != null) {
                        ++gettingDataCount;
                    }
                }
                --i;
            }
        }
        return gettingDataCount;
    }

    private synchronized GetDataThread gettingData(K key) {
        if (this.containsKey(key) || this.isCheckNetwork && !this.checkIsNetworkTypeAllowed()) {
            return null;
        }
        if (this.isExistGettingDataThread(key)) {
            return this.gettingDataThreadMap.get(key);
        }
        GetDataThread getDataThread = new GetDataThread(key, this.onGetDataListener);
        this.gettingDataThreadMap.put(key, getDataThread);
        this.threadPool.execute(getDataThread);
        return getDataThread;
    }

    public synchronized boolean isExistGettingDataThread(K key) {
        return this.gettingDataThreadMap.containsKey(key);
    }

    public PreloadDataCache() {
        this(64, DEFAULT_THREAD_POOL_SIZE);
    }

    public PreloadDataCache(int maxSize) {
        this(maxSize, DEFAULT_THREAD_POOL_SIZE);
    }

    public PreloadDataCache(int maxSize, int threadPoolSize) {
        super(maxSize);
        if (threadPoolSize <= 0) {
            throw new IllegalArgumentException("The threadPoolSize of cache must be greater than 0.");
        }
        this.threadPool = Executors.newFixedThreadPool(threadPoolSize);
    }

    public int getForwardCacheNumber() {
        return this.forwardCacheNumber;
    }

    public void setForwardCacheNumber(int forwardCacheNumber) {
        this.forwardCacheNumber = forwardCacheNumber;
    }

    public int getBackwardCacheNumber() {
        return this.backwardCacheNumber;
    }

    public void setBackwardCacheNumber(int backwardCacheNumber) {
        this.backwardCacheNumber = backwardCacheNumber;
    }

    public OnGetDataListener<K, V> getOnGetDataListener() {
        return this.onGetDataListener;
    }

    public void setOnGetDataListener(OnGetDataListener<K, V> onGetDataListener) {
        this.onGetDataListener = onGetDataListener;
    }

    public int getAllowedNetworkTypes() {
        return this.allowedNetworkTypes;
    }

    public void setAllowedNetworkTypes(int allowedNetworkTypes) {
        this.allowedNetworkTypes = allowedNetworkTypes;
    }

    public boolean isCheckNetwork() {
        return this.isCheckNetwork;
    }

    public void setCheckNetwork(boolean isCheckNetwork) {
        this.isCheckNetwork = isCheckNetwork;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean checkIsNetworkTypeAllowed() {
        if (this.connectivityManager == null && this.context != null) {
            this.connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        }
        if (this.connectivityManager == null) {
            return true;
        }
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && (this.allowedNetworkTypes == -1 || (this.translateNetworkTypeToApiFlag(networkInfo.getType()) & this.allowedNetworkTypes) != 0);
    }

    private int translateNetworkTypeToApiFlag(int networkType) {
        switch (networkType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    public static <K, V> PreloadDataCache<K, V> loadCache(String filePath) {
        return (PreloadDataCache)SerializeUtils.deserialization(filePath);
    }

    protected void shutdown() {
        this.threadPool.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.threadPool.shutdownNow();
    }

    private class GetDataThread
    implements Runnable {
        private K key;
        private OnGetDataListener<K, V> onGetDataListener;
        public CountDownLatch finishGetDataLock;

        public GetDataThread(K key, OnGetDataListener<K, V> onGetDataListener) {
            this.key = key;
            this.onGetDataListener = onGetDataListener;
            this.finishGetDataLock = new CountDownLatch(1);
        }

        @Override
        public void run() {
            CacheObject object;
            if (this.key != null && this.onGetDataListener != null && (object = this.onGetDataListener.onGetData(this.key)) != null) {
                PreloadDataCache.this.put(this.key, object);
            }
            this.finishGetDataLock.countDown();
            if (PreloadDataCache.this.gettingDataThreadMap != null && this.key != null) {
                PreloadDataCache.this.gettingDataThreadMap.remove(this.key);
            }
        }
    }

    public static interface OnGetDataListener<K, V>
    extends Serializable {
        public CacheObject<V> onGetData(K var1);
    }
}

