/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.service.impl;

import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.service.Cache;
import cn.trinea.android.common.service.CacheFullRemoveType;
import cn.trinea.android.common.service.impl.RemoveTypeEnterTimeFirst;
import cn.trinea.android.common.service.impl.RemoveTypeNotRemove;
import cn.trinea.android.common.util.MapUtils;
import cn.trinea.android.common.util.SerializeUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleCache<K, V>
implements Cache<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_SIZE = 64;
    private final int maxSize;
    private long validTime;
    private CacheFullRemoveType<V> cacheFullRemoveType;
    protected Map<K, CacheObject<V>> cache;
    protected AtomicLong hitCount = new AtomicLong(0L);
    protected AtomicLong missCount = new AtomicLong(0L);

    public SimpleCache() {
        this(64);
    }

    public SimpleCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("The maxSize of cache must be greater than 0.");
        }
        this.maxSize = maxSize;
        this.cacheFullRemoveType = new RemoveTypeEnterTimeFirst<V>();
        this.validTime = -1L;
        this.cache = new ConcurrentHashMap<K, CacheObject<V>>(maxSize);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getValidTime() {
        return this.validTime;
    }

    public void setValidTime(long validTime) {
        this.validTime = validTime <= 0L ? -1L : validTime;
    }

    public CacheFullRemoveType<V> getCacheFullRemoveType() {
        return this.cacheFullRemoveType;
    }

    public void setCacheFullRemoveType(CacheFullRemoveType<V> cacheFullRemoveType) {
        if (cacheFullRemoveType == null) {
            throw new IllegalArgumentException("The cacheFullRemoveType of cache cannot be null.");
        }
        this.cacheFullRemoveType = cacheFullRemoveType;
    }

    @Override
    public int getSize() {
        this.removeExpired();
        return this.cache.size();
    }

    @Override
    public CacheObject<V> get(K key) {
        CacheObject<V> obj = this.cache.get(key);
        if (!this.isExpired(obj) && obj != null) {
            this.hitCount.incrementAndGet();
            this.setUsedInfo(obj);
            return obj;
        }
        this.missCount.incrementAndGet();
        return null;
    }

    protected synchronized void setUsedInfo(CacheObject<V> obj) {
        if (obj != null) {
            obj.getAndIncrementUsedCount();
            obj.setLastUsedTime(System.currentTimeMillis());
        }
    }

    @Override
    public CacheObject<V> put(K key, V value) {
        CacheObject<V> obj = new CacheObject<V>();
        obj.setData(value);
        obj.setForever(this.validTime == -1L);
        return this.put(key, obj);
    }

    @Override
    public synchronized CacheObject<V> put(K key, CacheObject<V> value) {
        if (this.cache.size() >= this.maxSize && this.removeExpired() <= 0) {
            if (this.cacheFullRemoveType instanceof RemoveTypeNotRemove) {
                return null;
            }
            if (this.fullRemoveOne() == null) {
                return null;
            }
        }
        value.setEnterTime(System.currentTimeMillis());
        this.cache.put(key, value);
        return value;
    }

    @Override
    public void putAll(Cache<K, V> cache2) {
        for (Map.Entry<K, CacheObject<V>> e : cache2.entrySet()) {
            if (e == null) continue;
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key) ? !this.isExpired(key) : false;
    }

    protected boolean isExpired(K key) {
        return this.validTime == -1L ? false : this.isExpired(this.cache.get(key));
    }

    @Override
    public CacheObject<V> remove(K key) {
        return this.cache.remove(key);
    }

    protected CacheObject<V> fullRemoveOne() {
        if (MapUtils.isEmpty(this.cache) || this.cacheFullRemoveType instanceof RemoveTypeNotRemove) {
            return null;
        }
        Object keyToRemove = null;
        CacheObject<V> valueToRemove = null;
        for (Map.Entry<K, CacheObject<V>> entry : this.cache.entrySet()) {
            if (entry == null) continue;
            if (valueToRemove == null) {
                valueToRemove = entry.getValue();
                keyToRemove = entry.getKey();
                continue;
            }
            if (this.cacheFullRemoveType.compare(entry.getValue(), valueToRemove) >= 0) continue;
            valueToRemove = entry.getValue();
            keyToRemove = entry.getKey();
        }
        if (keyToRemove != null) {
            this.cache.remove(keyToRemove);
        }
        return valueToRemove;
    }

    protected synchronized int removeExpired() {
        if (this.validTime == -1L) {
            return 0;
        }
        int count = 0;
        for (Map.Entry<K, CacheObject<V>> entry : this.cache.entrySet()) {
            if (entry == null || !this.isExpired(entry.getValue())) continue;
            this.cache.remove(entry.getKey());
            ++count;
        }
        return count;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    protected boolean isExpired(CacheObject<V> obj) {
        return this.validTime != -1L && (obj == null || obj.isExpired() && !obj.isForever() || obj.getEnterTime() + this.validTime < System.currentTimeMillis());
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public synchronized double getHitRate() {
        long total = this.hitCount.get() + this.missCount.get();
        return total == 0L ? 0.0 : (double)this.hitCount.get() / (double)total;
    }

    @Override
    public Set<K> keySet() {
        this.removeExpired();
        return this.cache.keySet();
    }

    @Override
    public Set<Map.Entry<K, CacheObject<V>>> entrySet() {
        this.removeExpired();
        return this.cache.entrySet();
    }

    @Override
    public Collection<CacheObject<V>> values() {
        this.removeExpired();
        return this.cache.values();
    }

    public static <K, V> SimpleCache<K, V> loadCache(String filePath) {
        return (SimpleCache)SerializeUtils.deserialization(filePath);
    }

    public static <K, V> void saveCache(String filePath, SimpleCache<K, V> cache) {
        SerializeUtils.serialization(filePath, cache);
    }
}

