/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import android.app.DownloadManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import java.lang.reflect.Method;

public class DownloadManagerPro {
    public static final Uri CONTENT_URI = Uri.parse((String)"content://downloads/my_downloads");
    public static final String COLUMN_LOCAL_FILENAME = "local_filename";
    public static final String COLUMN_LOCAL_URI = "local_uri";
    public static final String METHOD_NAME_PAUSE_DOWNLOAD = "pauseDownload";
    public static final String METHOD_NAME_RESUME_DOWNLOAD = "resumeDownload";
    private static boolean isInitPauseDownload = false;
    private static boolean isInitResumeDownload = false;
    private static Method pauseDownload = null;
    private static Method resumeDownload = null;
    private DownloadManager downloadManager;

    public DownloadManagerPro(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public int getStatusById(long downloadId) {
        return this.getInt(downloadId, "status");
    }

    public int[] getDownloadBytes(long downloadId) {
        int[] bytesAndStatus = this.getBytesAndStatus(downloadId);
        return new int[]{bytesAndStatus[0], bytesAndStatus[1]};
    }

    public int[] getBytesAndStatus(long downloadId) {
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[1] = -1;
        int[] bytesAndStatus = nArray;
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{downloadId});
        Cursor c = null;
        try {
            c = this.downloadManager.query(query);
            if (c != null && c.moveToFirst()) {
                bytesAndStatus[0] = c.getInt(c.getColumnIndexOrThrow("bytes_so_far"));
                bytesAndStatus[1] = c.getInt(c.getColumnIndexOrThrow("total_size"));
                bytesAndStatus[2] = c.getInt(c.getColumnIndex("status"));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return bytesAndStatus;
    }

    public int pauseDownload(long ... ids) {
        DownloadManagerPro.initPauseMethod();
        if (pauseDownload == null) {
            return -1;
        }
        try {
            return (Integer)pauseDownload.invoke((Object)this.downloadManager, new Object[]{ids});
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int resumeDownload(long ... ids) {
        DownloadManagerPro.initResumeMethod();
        if (resumeDownload == null) {
            return -1;
        }
        try {
            return (Integer)resumeDownload.invoke((Object)this.downloadManager, new Object[]{ids});
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isExistPauseAndResumeMethod() {
        DownloadManagerPro.initPauseMethod();
        DownloadManagerPro.initResumeMethod();
        return pauseDownload != null && resumeDownload != null;
    }

    private static void initPauseMethod() {
        if (isInitPauseDownload) {
            return;
        }
        isInitPauseDownload = true;
        try {
            pauseDownload = DownloadManager.class.getMethod(METHOD_NAME_PAUSE_DOWNLOAD, long[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initResumeMethod() {
        if (isInitResumeDownload) {
            return;
        }
        isInitResumeDownload = true;
        try {
            resumeDownload = DownloadManager.class.getMethod(METHOD_NAME_RESUME_DOWNLOAD, long[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFileName(long downloadId) {
        return this.getString(downloadId, Build.VERSION.SDK_INT < 11 ? COLUMN_LOCAL_URI : COLUMN_LOCAL_FILENAME);
    }

    public String getUri(long downloadId) {
        return this.getString(downloadId, "uri");
    }

    public int getReason(long downloadId) {
        return this.getInt(downloadId, "reason");
    }

    public int getPausedReason(long downloadId) {
        return this.getInt(downloadId, "reason");
    }

    public int getErrorCode(long downloadId) {
        return this.getInt(downloadId, "reason");
    }

    private String getString(long downloadId, String columnName) {
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{downloadId});
        String result = null;
        Cursor c = null;
        try {
            c = this.downloadManager.query(query);
            if (c != null && c.moveToFirst()) {
                result = c.getString(c.getColumnIndex(columnName));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return result;
    }

    private int getInt(long downloadId, String columnName) {
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{downloadId});
        int result = -1;
        Cursor c = null;
        try {
            c = this.downloadManager.query(query);
            if (c != null && c.moveToFirst()) {
                result = c.getInt(c.getColumnIndex(columnName));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return result;
    }

    public static class RequestPro
    extends DownloadManager.Request {
        public static final String METHOD_NAME_SET_NOTI_CLASS = "setNotiClass";
        public static final String METHOD_NAME_SET_NOTI_EXTRAS = "setNotiExtras";
        private static boolean isInitNotiClass = false;
        private static boolean isInitNotiExtras = false;
        private static Method setNotiClass = null;
        private static Method setNotiExtras = null;

        public RequestPro(Uri uri) {
            super(uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setNotiClass(String className) {
            RequestPro requestPro = this;
            synchronized (requestPro) {
                if (!isInitNotiClass) {
                    isInitNotiClass = true;
                    try {
                        setNotiClass = DownloadManager.Request.class.getMethod(METHOD_NAME_SET_NOTI_CLASS, CharSequence.class);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (setNotiClass != null) {
                try {
                    setNotiClass.invoke((Object)this, className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setNotiExtras(String extras) {
            RequestPro requestPro = this;
            synchronized (requestPro) {
                if (!isInitNotiExtras) {
                    isInitNotiExtras = true;
                    try {
                        setNotiExtras = DownloadManager.Request.class.getMethod(METHOD_NAME_SET_NOTI_EXTRAS, CharSequence.class);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (setNotiExtras != null) {
                try {
                    setNotiExtras.invoke((Object)this, extras);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

