/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import android.os.AsyncTask;
import cn.trinea.android.common.entity.HttpRequest;
import cn.trinea.android.common.entity.HttpResponse;
import cn.trinea.android.common.util.ArrayUtils;
import cn.trinea.android.common.util.MapUtils;
import cn.trinea.android.common.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class HttpUtils {
    public static final String URL_AND_PARA_SEPARATOR = "?";
    public static final String PARAMETERS_SEPARATOR = "&";
    public static final String PATHS_SEPARATOR = "/";
    public static final String EQUAL_SIGN = "=";
    private static final SimpleDateFormat GMT_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public static HttpResponse httpGet(HttpRequest request) {
        if (request == null) {
            return null;
        }
        BufferedReader input = null;
        HttpURLConnection con = null;
        try {
            URL url = new URL(request.getUrl());
            try {
                String s;
                HttpResponse response = new HttpResponse(request.getUrl());
                con = (HttpURLConnection)url.openConnection();
                HttpUtils.setURLConnection(request, con);
                input = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((s = input.readLine()) != null) {
                    sb.append(s).append("\n");
                }
                response.setResponseBody(sb.toString());
                HttpUtils.setHttpResponse(con, response);
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                con.disconnect();
            }
        }
        return null;
    }

    public static HttpResponse httpGet(String httpUrl) {
        return HttpUtils.httpGet(new HttpRequest(httpUrl));
    }

    public static String httpGetString(HttpRequest request) {
        HttpResponse response = HttpUtils.httpGet(request);
        return response == null ? null : response.getResponseBody();
    }

    public static String httpGetString(String httpUrl) {
        HttpResponse response = HttpUtils.httpGet(new HttpRequest(httpUrl));
        return response == null ? null : response.getResponseBody();
    }

    public static void httpGet(String url, HttpListener listener) {
        new HttpStringAsyncTask(listener).execute(new String[]{url});
    }

    public static void httpGet(HttpRequest request, HttpListener listener) {
        new HttpRequestAsyncTask(listener).execute(new HttpRequest[]{request});
    }

    public static HttpResponse httpPost(HttpRequest request) {
        if (request == null) {
            return null;
        }
        BufferedReader input = null;
        HttpURLConnection con = null;
        try {
            URL url = new URL(request.getUrl());
            try {
                String s;
                HttpResponse response = new HttpResponse(request.getUrl());
                con = (HttpURLConnection)url.openConnection();
                HttpUtils.setURLConnection(request, con);
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                String paras = request.getParas();
                if (!StringUtils.isEmpty(paras)) {
                    con.getOutputStream().write(paras.getBytes());
                }
                input = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((s = input.readLine()) != null) {
                    sb.append(s).append("\n");
                }
                response.setResponseBody(sb.toString());
                HttpUtils.setHttpResponse(con, response);
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                con.disconnect();
            }
        }
        return null;
    }

    public static HttpResponse httpPost(String httpUrl) {
        return HttpUtils.httpPost(new HttpRequest(httpUrl));
    }

    public static String httpPostString(String httpUrl) {
        HttpResponse response = HttpUtils.httpPost(new HttpRequest(httpUrl));
        return response == null ? null : response.getResponseBody();
    }

    public static String httpPostString(String httpUrl, Map<String, String> parasMap) {
        HttpResponse response = HttpUtils.httpPost(new HttpRequest(httpUrl, parasMap));
        return response == null ? null : response.getResponseBody();
    }

    public static String getUrlWithParas(String url, Map<String, String> parasMap) {
        StringBuilder urlWithParas = new StringBuilder(StringUtils.isEmpty(url) ? "" : url);
        String paras = HttpUtils.joinParas(parasMap);
        if (!StringUtils.isEmpty(paras)) {
            urlWithParas.append(URL_AND_PARA_SEPARATOR).append(paras);
        }
        return urlWithParas.toString();
    }

    public static String getUrlWithValueEncodeParas(String url, Map<String, String> parasMap) {
        StringBuilder urlWithParas = new StringBuilder(StringUtils.isEmpty(url) ? "" : url);
        String paras = HttpUtils.joinParasWithEncodedValue(parasMap);
        if (!StringUtils.isEmpty(paras)) {
            urlWithParas.append(URL_AND_PARA_SEPARATOR).append(paras);
        }
        return urlWithParas.toString();
    }

    public static String joinParas(Map<String, String> parasMap) {
        if (parasMap == null || parasMap.size() == 0) {
            return null;
        }
        StringBuilder paras = new StringBuilder();
        Iterator<Map.Entry<String, String>> ite = parasMap.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<String, String> entry = ite.next();
            paras.append(entry.getKey()).append(EQUAL_SIGN).append(entry.getValue());
            if (!ite.hasNext()) continue;
            paras.append(PARAMETERS_SEPARATOR);
        }
        return paras.toString();
    }

    public static String joinParasWithEncodedValue(Map<String, String> parasMap) {
        StringBuilder paras = new StringBuilder("");
        if (parasMap != null && parasMap.size() > 0) {
            Iterator<Map.Entry<String, String>> ite = parasMap.entrySet().iterator();
            try {
                while (ite.hasNext()) {
                    Map.Entry<String, String> entry = ite.next();
                    paras.append(entry.getKey()).append(EQUAL_SIGN).append(StringUtils.utf8Encode(entry.getValue()));
                    if (!ite.hasNext()) continue;
                    paras.append(PARAMETERS_SEPARATOR);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return paras.toString();
    }

    public static String appendParaToUrl(String url, String paraKey, String paraValue) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (!url.contains(URL_AND_PARA_SEPARATOR)) {
            sb.append(URL_AND_PARA_SEPARATOR);
        } else {
            sb.append(PARAMETERS_SEPARATOR);
        }
        return sb.append(paraKey).append(EQUAL_SIGN).append(paraValue).toString();
    }

    public static long parseGmtTime(String gmtTime) {
        try {
            return GMT_FORMAT.parse(gmtTime).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private static void setURLConnection(HttpRequest request, HttpURLConnection urlConnection) {
        if (request == null || urlConnection == null) {
            return;
        }
        HttpUtils.setURLConnection(request.getRequestProperties(), urlConnection);
        if (request.getConnectTimeout() >= 0) {
            urlConnection.setConnectTimeout(request.getConnectTimeout());
        }
        if (request.getReadTimeout() >= 0) {
            urlConnection.setReadTimeout(request.getReadTimeout());
        }
    }

    public static void setURLConnection(Map<String, String> requestProperties, HttpURLConnection urlConnection) {
        if (MapUtils.isEmpty(requestProperties) || urlConnection == null) {
            return;
        }
        for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
            if (StringUtils.isEmpty(entry.getKey())) continue;
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void setHttpResponse(HttpURLConnection urlConnection, HttpResponse response) {
        if (response == null || urlConnection == null) {
            return;
        }
        try {
            response.setResponseCode(urlConnection.getResponseCode());
        }
        catch (IOException e) {
            response.setResponseCode(-1);
        }
        response.setResponseHeader("expires", urlConnection.getHeaderField("Expires"));
        response.setResponseHeader("cache-control", urlConnection.getHeaderField("Cache-Control"));
    }

    public static abstract class HttpListener {
        protected void onPreGet() {
        }

        protected void onPostGet(HttpResponse httpResponse) {
        }
    }

    private static class HttpRequestAsyncTask
    extends AsyncTask<HttpRequest, Void, HttpResponse> {
        private HttpListener listener;

        public HttpRequestAsyncTask(HttpListener listener) {
            this.listener = listener;
        }

        protected HttpResponse doInBackground(HttpRequest ... httpRequest) {
            if (ArrayUtils.isEmpty(httpRequest)) {
                return null;
            }
            return HttpUtils.httpGet(httpRequest[0]);
        }

        protected void onPreExecute() {
            if (this.listener != null) {
                this.listener.onPreGet();
            }
        }

        protected void onPostExecute(HttpResponse httpResponse) {
            if (this.listener != null) {
                this.listener.onPostGet(httpResponse);
            }
        }
    }

    private static class HttpStringAsyncTask
    extends AsyncTask<String, Void, HttpResponse> {
        private HttpListener listener;

        public HttpStringAsyncTask(HttpListener listener) {
            this.listener = listener;
        }

        protected HttpResponse doInBackground(String ... url) {
            if (ArrayUtils.isEmpty(url)) {
                return null;
            }
            return HttpUtils.httpGet(url[0]);
        }

        protected void onPreExecute() {
            if (this.listener != null) {
                this.listener.onPreGet();
            }
        }

        protected void onPostExecute(HttpResponse httpResponse) {
            if (this.listener != null) {
                this.listener.onPostGet(httpResponse);
            }
        }
    }
}

