/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import cn.trinea.android.common.entity.CacheObject;
import cn.trinea.android.common.entity.FailedReason;
import cn.trinea.android.common.service.impl.FileNameRuleImageUrl;
import cn.trinea.android.common.service.impl.ImageCache;
import cn.trinea.android.common.service.impl.ImageMemoryCache;
import cn.trinea.android.common.service.impl.ImageSDCardCache;
import cn.trinea.android.common.service.impl.PreloadDataCache;
import cn.trinea.android.common.service.impl.RemoveTypeLastUsedTimeFirst;
import cn.trinea.android.common.util.CacheManager;
import cn.trinea.android.common.util.FileUtils;

public class ImageCacheManager {
    public static final String TAG = "ImageCacheManager";
    private static ImageCache imageCache = null;
    private static ImageSDCardCache imageSDCardCache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageCache getImageCache() {
        if (imageCache != null) return imageCache;
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (imageCache != null) return imageCache;
            imageCache = new ImageCache(128, 512);
            ImageCacheManager.setImageCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return imageCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageSDCardCache getImageSDCardCache() {
        if (imageSDCardCache != null) return imageSDCardCache;
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (imageSDCardCache != null) return imageSDCardCache;
            imageSDCardCache = new ImageSDCardCache();
            ImageCacheManager.setImageSDCardCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return imageSDCardCache;
        }
    }

    private static void setImageCache() {
        if (imageCache == null) {
            return;
        }
        ImageMemoryCache.OnImageCallbackListener imageCallBack = new ImageMemoryCache.OnImageCallbackListener(){

            @Override
            public void onGetSuccess(String imageUrl, Bitmap loadedImage, View view, boolean isInCache) {
                if (view != null && loadedImage != null) {
                    if (view instanceof ImageView) {
                        ImageView imageView = (ImageView)view;
                        imageView.setImageBitmap(loadedImage);
                        if (!isInCache) {
                            imageView.startAnimation((Animation)ImageCacheManager.getInAlphaAnimation(2000L));
                        }
                    } else {
                        Log.e((String)ImageCacheManager.TAG, (String)"View is not instance of ImageView, you need to setOnImageCallbackListener() by your self");
                    }
                }
            }

            @Override
            public void onPreGet(String imageUrl, View view) {
            }

            @Override
            public void onGetFailed(String imageUrl, Bitmap loadedImage, View view, FailedReason failedReason) {
            }

            @Override
            public void onGetNotInCache(String imageUrl, View view) {
            }
        };
        imageCache.setOnImageCallbackListener(imageCallBack);
        imageCache.setCacheFullRemoveType(new RemoveTypeLastUsedTimeFirst());
        imageCache.setHttpReadTimeOut(10000);
        imageCache.setValidTime(-1L);
    }

    private static void setImageSDCardCache() {
        if (imageSDCardCache == null) {
            return;
        }
        ImageSDCardCache.OnImageSDCallbackListener imageCallBack = new ImageSDCardCache.OnImageSDCallbackListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void onGetSuccess(String imageUrl, String imagePath, View view, boolean isInCache) {
                if (view != null && view instanceof ImageView) {
                    ImageView imageView = (ImageView)view;
                    Bitmap bm = BitmapFactory.decodeFile((String)imagePath);
                    if (bm != null) {
                        imageView.setImageBitmap(bm);
                        if (!isInCache) {
                            imageView.startAnimation((Animation)ImageCacheManager.getInAlphaAnimation(2000L));
                        }
                    }
                } else {
                    Log.e((String)ImageCacheManager.TAG, (String)"View is not instance of ImageView, you need to setOnImageSDCallbackListener() by your self");
                }
            }

            @Override
            public void onPreGet(String imageUrl, View view) {
            }

            @Override
            public void onGetNotInCache(String imageUrl, View view) {
            }

            @Override
            public void onGetFailed(String imageUrl, String imagePath, View view, FailedReason failedReason) {
            }
        };
        imageSDCardCache.setOnImageSDCallbackListener(imageCallBack);
        imageSDCardCache.setCacheFullRemoveType(new RemoveTypeLastUsedTimeFirst());
        imageSDCardCache.setFileNameRule(new FileNameRuleImageUrl());
        imageSDCardCache.setHttpReadTimeOut(10000);
        imageSDCardCache.setValidTime(-1L);
    }

    public static AlphaAnimation getInAlphaAnimation(long durationMillis) {
        AlphaAnimation inAlphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        inAlphaAnimation.setDuration(durationMillis);
        return inAlphaAnimation;
    }

    public static PreloadDataCache.OnGetDataListener<String, Bitmap> getImageFromSdcardListener() {
        return new PreloadDataCache.OnGetDataListener<String, Bitmap>(){
            private static final long serialVersionUID = 1L;

            @Override
            public CacheObject<Bitmap> onGetData(String key) {
                if (FileUtils.isFileExist(key)) {
                    return new CacheObject<Bitmap>(BitmapFactory.decodeFile((String)key));
                }
                return null;
            }
        };
    }

    private ImageCacheManager() {
    }
}

