/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import cn.trinea.android.common.util.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class ImageUtils {
    public static byte[] bitmapToByte(Bitmap b) {
        if (b == null) {
            return null;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        b.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)o);
        return o.toByteArray();
    }

    public static Bitmap byteToBitmap(byte[] b) {
        return b == null || b.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
    }

    public static Bitmap drawableToBitmap(Drawable d) {
        return d == null ? null : ((BitmapDrawable)d).getBitmap();
    }

    public static Drawable bitmapToDrawable(Bitmap b) {
        return b == null ? null : new BitmapDrawable(b);
    }

    public static byte[] drawableToByte(Drawable d) {
        return ImageUtils.bitmapToByte(ImageUtils.drawableToBitmap(d));
    }

    public static Drawable byteToDrawable(byte[] b) {
        return ImageUtils.bitmapToDrawable(ImageUtils.byteToBitmap(b));
    }

    public static InputStream getInputStreamFromUrl(String imageUrl, int readTimeOutMillis) {
        return ImageUtils.getInputStreamFromUrl(imageUrl, readTimeOutMillis, null);
    }

    public static InputStream getInputStreamFromUrl(String imageUrl, int readTimeOutMillis, Map<String, String> requestProperties) {
        InputStream stream = null;
        try {
            URL url = new URL(imageUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            HttpUtils.setURLConnection(requestProperties, con);
            if (readTimeOutMillis > 0) {
                con.setReadTimeout(readTimeOutMillis);
            }
            stream = con.getInputStream();
        }
        catch (MalformedURLException e) {
            ImageUtils.closeInputStream(stream);
            throw new RuntimeException("MalformedURLException occurred. ", e);
        }
        catch (IOException e) {
            ImageUtils.closeInputStream(stream);
            throw new RuntimeException("IOException occurred. ", e);
        }
        return stream;
    }

    public static Drawable getDrawableFromUrl(String imageUrl, int readTimeOutMillis) {
        return ImageUtils.getDrawableFromUrl(imageUrl, readTimeOutMillis, null);
    }

    public static Drawable getDrawableFromUrl(String imageUrl, int readTimeOutMillis, Map<String, String> requestProperties) {
        InputStream stream = ImageUtils.getInputStreamFromUrl(imageUrl, readTimeOutMillis, requestProperties);
        Drawable d = Drawable.createFromStream((InputStream)stream, (String)"src");
        ImageUtils.closeInputStream(stream);
        return d;
    }

    public static Bitmap getBitmapFromUrl(String imageUrl, int readTimeOut) {
        return ImageUtils.getBitmapFromUrl(imageUrl, readTimeOut, null);
    }

    public static Bitmap getBitmapFromUrl(String imageUrl, int readTimeOut, Map<String, String> requestProperties) {
        InputStream stream = ImageUtils.getInputStreamFromUrl(imageUrl, readTimeOut, requestProperties);
        Bitmap b = BitmapFactory.decodeStream((InputStream)stream);
        ImageUtils.closeInputStream(stream);
        return b;
    }

    public static Bitmap scaleImageTo(Bitmap org, int newWidth, int newHeight) {
        return ImageUtils.scaleImage(org, (float)newWidth / (float)org.getWidth(), (float)newHeight / (float)org.getHeight());
    }

    public static Bitmap scaleImage(Bitmap org, float scaleWidth, float scaleHeight) {
        if (org == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)org, (int)0, (int)0, (int)org.getWidth(), (int)org.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static void closeInputStream(InputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
    }
}

