/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import cn.trinea.android.common.util.ArrayUtils;
import cn.trinea.android.common.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;

public class ListUtils {
    public static final String DEFAULT_JOIN_SEPARATOR = ",";

    public static <V> int getSize(List<V> sourceList) {
        return sourceList == null ? 0 : sourceList.size();
    }

    public static <V> boolean isEmpty(List<V> sourceList) {
        return sourceList == null || sourceList.size() == 0;
    }

    public static <V> boolean isEquals(ArrayList<V> actual, ArrayList<V> expected) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        if (actual.size() != expected.size()) {
            return false;
        }
        int i = 0;
        while (i < actual.size()) {
            if (!ObjectUtils.isEquals(actual.get(i), expected.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String join(List<String> list) {
        return ListUtils.join(list, DEFAULT_JOIN_SEPARATOR);
    }

    public static String join(List<String> list, char separator) {
        return ListUtils.join(list, new String(new char[]{separator}));
    }

    public static String join(List<String> list, String separator) {
        if (ListUtils.isEmpty(list)) {
            return "";
        }
        if (separator == null) {
            separator = DEFAULT_JOIN_SEPARATOR;
        }
        StringBuilder joinStr = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            joinStr.append(list.get(i));
            if (i != list.size() - 1) {
                joinStr.append(separator);
            }
            ++i;
        }
        return joinStr.toString();
    }

    public static <V> boolean addDistinctEntry(List<V> sourceList, V entry) {
        return sourceList != null && !sourceList.contains(entry) ? sourceList.add(entry) : false;
    }

    public static <V> int addDistinctList(List<V> sourceList, List<V> entryList) {
        if (sourceList == null || ListUtils.isEmpty(entryList)) {
            return 0;
        }
        int sourceCount = sourceList.size();
        for (V entry : entryList) {
            if (sourceList.contains(entry)) continue;
            sourceList.add(entry);
        }
        return sourceList.size() - sourceCount;
    }

    public static <V> int distinctList(List<V> sourceList) {
        if (ListUtils.isEmpty(sourceList)) {
            return 0;
        }
        int sourceCount = sourceList.size();
        int sourceListSize = sourceList.size();
        int i = 0;
        while (i < sourceListSize) {
            int j = i + 1;
            while (j < sourceListSize) {
                if (sourceList.get(i).equals(sourceList.get(j))) {
                    sourceList.remove(j);
                    sourceListSize = sourceList.size();
                    --j;
                }
                ++j;
            }
            ++i;
        }
        return sourceCount - sourceList.size();
    }

    public static <V> boolean addListNotNullValue(List<V> sourceList, V value) {
        return sourceList != null && value != null ? sourceList.add(value) : false;
    }

    public static <V> V getLast(List<V> sourceList, V value) {
        return (V)(sourceList == null ? null : ArrayUtils.getLast(sourceList.toArray(), value, true));
    }

    public static <V> V getNext(List<V> sourceList, V value) {
        return (V)(sourceList == null ? null : ArrayUtils.getNext(sourceList.toArray(), value, true));
    }

    public static <V> List<V> invertList(List<V> sourceList) {
        if (ListUtils.isEmpty(sourceList)) {
            return sourceList;
        }
        ArrayList<V> invertList = new ArrayList<V>(sourceList.size());
        int i = sourceList.size() - 1;
        while (i >= 0) {
            invertList.add(sourceList.get(i));
            --i;
        }
        return invertList;
    }
}

