/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import cn.trinea.android.common.util.ObjectUtils;
import cn.trinea.android.common.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapUtils {
    public static final String DEFAULT_KEY_AND_VALUE_SEPARATOR = ":";
    public static final String DEFAULT_KEY_AND_VALUE_PAIR_SEPARATOR = ",";

    public static <K, V> boolean isEmpty(Map<K, V> sourceMap) {
        return sourceMap == null || sourceMap.size() == 0;
    }

    public static boolean putMapNotEmptyKey(Map<String, String> map, String key, String value) {
        if (map == null || StringUtils.isEmpty(key)) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    public static boolean putMapNotEmptyKeyAndValue(Map<String, String> map, String key, String value) {
        if (map == null || StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    public static boolean putMapNotEmptyKeyAndValue(Map<String, String> map, String key, String value, String defaultValue) {
        if (map == null || StringUtils.isEmpty(key)) {
            return false;
        }
        map.put(key, StringUtils.isEmpty(value) ? defaultValue : value);
        return true;
    }

    public static <K, V> boolean putMapNotNullKey(Map<K, V> map, K key, V value) {
        if (map == null || key == null) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    public static <K, V> boolean putMapNotNullKeyAndValue(Map<K, V> map, K key, V value) {
        if (map == null || key == null || value == null) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    public static <K, V> K getKeyByValue(Map<K, V> map, V value) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!ObjectUtils.isEquals(entry.getValue(), value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map<String, String> parseKeyAndValueToMap(String source, String keyAndValueSeparator, String keyAndValuePairSeparator, boolean ignoreSpace) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        if (StringUtils.isEmpty(keyAndValueSeparator)) {
            keyAndValueSeparator = DEFAULT_KEY_AND_VALUE_SEPARATOR;
        }
        if (StringUtils.isEmpty(keyAndValuePairSeparator)) {
            keyAndValuePairSeparator = DEFAULT_KEY_AND_VALUE_PAIR_SEPARATOR;
        }
        HashMap<String, String> keyAndValueMap = new HashMap<String, String>();
        String[] keyAndValueArray = source.split(keyAndValuePairSeparator);
        if (keyAndValueArray == null) {
            return null;
        }
        String[] stringArray = keyAndValueArray;
        int n = keyAndValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            int seperator;
            String valueEntity = stringArray[n2];
            if (!StringUtils.isEmpty(valueEntity) && (seperator = valueEntity.indexOf(keyAndValueSeparator)) != -1) {
                if (ignoreSpace) {
                    MapUtils.putMapNotEmptyKey(keyAndValueMap, valueEntity.substring(0, seperator).trim(), valueEntity.substring(seperator + 1).trim());
                } else {
                    MapUtils.putMapNotEmptyKey(keyAndValueMap, valueEntity.substring(0, seperator), valueEntity.substring(seperator + 1));
                }
            }
            ++n2;
        }
        return keyAndValueMap;
    }

    public static Map<String, String> parseKeyAndValueToMap(String source, boolean ignoreSpace) {
        return MapUtils.parseKeyAndValueToMap(source, DEFAULT_KEY_AND_VALUE_SEPARATOR, DEFAULT_KEY_AND_VALUE_PAIR_SEPARATOR, ignoreSpace);
    }

    public static Map<String, String> parseKeyAndValueToMap(String source) {
        return MapUtils.parseKeyAndValueToMap(source, DEFAULT_KEY_AND_VALUE_SEPARATOR, DEFAULT_KEY_AND_VALUE_PAIR_SEPARATOR, true);
    }

    public static String toJson(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        StringBuilder paras = new StringBuilder();
        paras.append("{");
        Iterator<Map.Entry<String, String>> ite = map.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<String, String> entry = ite.next();
            paras.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\"");
            if (!ite.hasNext()) continue;
            paras.append(DEFAULT_KEY_AND_VALUE_PAIR_SEPARATOR);
        }
        paras.append("}");
        return paras.toString();
    }
}

