/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Map;

public class ParcelUtils {
    public static boolean readBoolean(Parcel in) {
        return in.readInt() == 1;
    }

    public static void writeBoolean(boolean b, Parcel out) {
        out.writeInt(b ? 1 : 0);
    }

    public static Map<String, String> readHashMapStringAndString(Parcel in) {
        if (in == null) {
            return null;
        }
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < size) {
            String key = in.readString();
            map.put(key, in.readString());
            ++i;
        }
        return map;
    }

    public static void writeHashMapStringAndString(Map<String, String> map, Parcel out, int flags) {
        if (map != null) {
            out.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    public static <V extends Parcelable> Map<String, V> readHashMapStringKey(Parcel in, ClassLoader loader) {
        if (in == null) {
            return null;
        }
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<String, Parcelable> map = new HashMap<String, Parcelable>();
        int i = 0;
        while (i < size) {
            String key = in.readString();
            map.put(key, in.readParcelable(loader));
            ++i;
        }
        return map;
    }

    public static <V extends Parcelable> void writeHashMapStringKey(Map<String, V> map, Parcel out, int flags) {
        if (map != null) {
            out.writeInt(map.size());
            for (Map.Entry<String, V> entry : map.entrySet()) {
                out.writeString(entry.getKey());
                out.writeParcelable((Parcelable)entry.getValue(), flags);
            }
        } else {
            out.writeInt(-1);
        }
    }

    public static <K extends Parcelable, V extends Parcelable> Map<K, V> readHashMap(Parcel in, ClassLoader loader) {
        if (in == null) {
            return null;
        }
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<Parcelable, Parcelable> map = new HashMap<Parcelable, Parcelable>();
        int i = 0;
        while (i < size) {
            map.put(in.readParcelable(loader), in.readParcelable(loader));
            ++i;
        }
        return map;
    }

    public static <K extends Parcelable, V extends Parcelable> void writeHashMap(Map<K, V> map, Parcel out, int flags) {
        if (map != null) {
            out.writeInt(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                out.writeParcelable((Parcelable)entry.getKey(), flags);
                out.writeParcelable((Parcelable)entry.getValue(), flags);
            }
        } else {
            out.writeInt(-1);
        }
    }
}

