/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.util;

import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.reflect.Field;

public class ViewUtils {
    private static final String CLASS_NAME_GRID_VIEW = "android.widget.GridView";
    private static final String FIELD_NAME_VERTICAL_SPACING = "mVerticalSpacing";

    public static int getListViewHeightBasedOnChildren(ListView view) {
        int adapterCount;
        ListAdapter adapter;
        int height = ViewUtils.getAbsListViewHeightBasedOnChildren((AbsListView)view);
        if (view != null && (adapter = view.getAdapter()) != null && (adapterCount = adapter.getCount()) > 0) {
            height += view.getDividerHeight() * (adapterCount - 1);
        }
        return height;
    }

    public static int getGridViewVerticalSpacing(GridView view) {
        Class<?> demo = null;
        int verticalSpacing = 0;
        try {
            demo = Class.forName(CLASS_NAME_GRID_VIEW);
            Field field = demo.getDeclaredField(FIELD_NAME_VERTICAL_SPACING);
            field.setAccessible(true);
            verticalSpacing = (Integer)field.get(view);
            return verticalSpacing;
        }
        catch (Exception e) {
            e.printStackTrace();
            return verticalSpacing;
        }
    }

    public static int getAbsListViewHeightBasedOnChildren(AbsListView view) {
        ListAdapter adapter;
        if (view == null || (adapter = (ListAdapter)view.getAdapter()) == null) {
            return 0;
        }
        int height = 0;
        int i = 0;
        while (i < adapter.getCount()) {
            View item = adapter.getView(i, null, (ViewGroup)view);
            if (item instanceof ViewGroup) {
                item.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            }
            item.measure(0, 0);
            height += item.getMeasuredHeight();
            ++i;
        }
        return height += view.getPaddingTop() + view.getPaddingBottom();
    }

    public static void setViewHeight(View view, int height) {
        if (view == null) {
            return;
        }
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params.height = height;
    }

    public static void setListViewHeightBasedOnChildren(ListView view) {
        ViewUtils.setViewHeight((View)view, ViewUtils.getListViewHeightBasedOnChildren(view));
    }

    public static void setAbsListViewHeightBasedOnChildren(AbsListView view) {
        ViewUtils.setViewHeight((View)view, ViewUtils.getAbsListViewHeightBasedOnChildren(view));
    }

    public static void setSearchViewOnClickListener(View v, View.OnClickListener listener) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int count = group.getChildCount();
            int i = 0;
            while (i < count) {
                View child = group.getChildAt(i);
                if (child instanceof LinearLayout || child instanceof RelativeLayout) {
                    ViewUtils.setSearchViewOnClickListener(child, listener);
                }
                if (child instanceof TextView) {
                    TextView text = (TextView)child;
                    text.setFocusable(false);
                }
                child.setOnClickListener(listener);
                ++i;
            }
        }
    }
}

