/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ScrollView;

public class BorderScrollView
extends ScrollView {
    private OnBorderListener onBorderListener;
    private View contentView;

    public BorderScrollView(Context context) {
        super(context);
    }

    public BorderScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BorderScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onScrollChanged(int x, int y, int oldx, int oldy) {
        super.onScrollChanged(x, y, oldx, oldy);
        this.doOnBorderListener();
    }

    public void setOnBorderListener(OnBorderListener onBorderListener) {
        this.onBorderListener = onBorderListener;
        if (onBorderListener == null) {
            return;
        }
        if (this.contentView == null) {
            this.contentView = this.getChildAt(0);
        }
    }

    private void doOnBorderListener() {
        if (this.contentView != null && this.contentView.getMeasuredHeight() <= this.getScrollY() + this.getHeight()) {
            if (this.onBorderListener != null) {
                this.onBorderListener.onBottom();
            }
        } else if (this.getScrollY() == 0 && this.onBorderListener != null) {
            this.onBorderListener.onTop();
        }
    }

    public static interface OnBorderListener {
        public void onBottom();

        public void onTop();
    }
}

