/*
 * Decompiled with CFR 0.152.
 */
package cn.trinea.android.common.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.trinea.android.common.R;

public class DropDownListView
extends ListView
implements AbsListView.OnScrollListener {
    private boolean isDropDownStyle = true;
    private boolean isOnBottomStyle = true;
    private boolean isAutoLoadOnBottom = false;
    private String headerDefaultText;
    private String headerPullText;
    private String headerReleaseText;
    private String headerLoadingText;
    private String footerDefaultText;
    private String footerLoadingText;
    private String footerNoMoreText;
    private Context context;
    private RelativeLayout headerLayout;
    private ImageView headerImage;
    private ProgressBar headerProgressBar;
    private TextView headerText;
    private TextView headerSecondText;
    private RelativeLayout footerLayout;
    private ProgressBar footerProgressBar;
    private Button footerButton;
    private OnDropDownListener onDropDownListener;
    private AbsListView.OnScrollListener onScrollListener;
    private float headerPaddingTopRate = 1.5f;
    private int headerReleaseMinDistance;
    private boolean hasMore = true;
    private boolean isShowFooterProgressBar = true;
    private boolean isShowFooterWhenNoMore = false;
    private int currentScrollState;
    private int currentHeaderStatus;
    private boolean hasReachedTop = false;
    private RotateAnimation flipAnimation;
    private RotateAnimation reverseFlipAnimation;
    private int headerOriginalHeight;
    private int headerOriginalTopPadding;
    private float actionDownPointY;
    private boolean isOnBottomLoading = false;
    public static final int HEADER_STATUS_CLICK_TO_LOAD = 1;
    public static final int HEADER_STATUS_DROP_DOWN_TO_LOAD = 2;
    public static final int HEADER_STATUS_RELEASE_TO_LOAD = 3;
    public static final int HEADER_STATUS_LOADING = 4;

    public DropDownListView(Context context) {
        super(context);
        this.init(context);
    }

    public DropDownListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getAttrs(context, attrs);
        this.init(context);
    }

    public DropDownListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.getAttrs(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.initDropDownStyle();
        this.initOnBottomStyle();
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    private void initDropDownStyle() {
        if (this.headerLayout != null) {
            if (this.isDropDownStyle) {
                this.addHeaderView((View)this.headerLayout);
            } else {
                this.removeHeaderView((View)this.headerLayout);
            }
            return;
        }
        if (!this.isDropDownStyle) {
            return;
        }
        this.headerReleaseMinDistance = this.context.getResources().getDimensionPixelSize(R.dimen.drop_down_list_header_release_min_distance);
        this.flipAnimation = new RotateAnimation(0.0f, 180.0f, 1, 0.5f, 1, 0.5f);
        this.flipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.flipAnimation.setDuration(250L);
        this.flipAnimation.setFillAfter(true);
        this.reverseFlipAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.reverseFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.reverseFlipAnimation.setDuration(250L);
        this.reverseFlipAnimation.setFillAfter(true);
        this.headerDefaultText = this.context.getString(R.string.drop_down_list_header_default_text);
        this.headerPullText = this.context.getString(R.string.drop_down_list_header_pull_text);
        this.headerReleaseText = this.context.getString(R.string.drop_down_list_header_release_text);
        this.headerLoadingText = this.context.getString(R.string.drop_down_list_header_loading_text);
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        this.headerLayout = (RelativeLayout)inflater.inflate(R.layout.drop_down_list_header, (ViewGroup)this, false);
        this.headerText = (TextView)this.headerLayout.findViewById(R.id.drop_down_list_header_default_text);
        this.headerImage = (ImageView)this.headerLayout.findViewById(R.id.drop_down_list_header_image);
        this.headerProgressBar = (ProgressBar)this.headerLayout.findViewById(R.id.drop_down_list_header_progress_bar);
        this.headerSecondText = (TextView)this.headerLayout.findViewById(R.id.drop_down_list_header_second_text);
        this.headerLayout.setClickable(true);
        this.headerLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DropDownListView.this.onDropDown();
            }
        });
        this.headerText.setText((CharSequence)this.headerDefaultText);
        this.addHeaderView((View)this.headerLayout);
        this.measureHeaderLayout((View)this.headerLayout);
        this.headerOriginalHeight = this.headerLayout.getMeasuredHeight();
        this.headerOriginalTopPadding = this.headerLayout.getPaddingTop();
        this.currentHeaderStatus = 1;
    }

    private void initOnBottomStyle() {
        if (this.footerLayout != null) {
            if (this.isOnBottomStyle) {
                this.addFooterView((View)this.footerLayout);
            } else {
                this.removeFooterView((View)this.footerLayout);
            }
            return;
        }
        if (!this.isOnBottomStyle) {
            return;
        }
        this.footerDefaultText = this.context.getString(R.string.drop_down_list_footer_default_text);
        this.footerLoadingText = this.context.getString(R.string.drop_down_list_footer_loading_text);
        this.footerNoMoreText = this.context.getString(R.string.drop_down_list_footer_no_more_text);
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        this.footerLayout = (RelativeLayout)inflater.inflate(R.layout.drop_down_list_footer, (ViewGroup)this, false);
        this.footerButton = (Button)this.footerLayout.findViewById(R.id.drop_down_list_footer_button);
        this.footerButton.setDrawingCacheBackgroundColor(0);
        this.footerButton.setEnabled(true);
        this.footerProgressBar = (ProgressBar)this.footerLayout.findViewById(R.id.drop_down_list_footer_progress_bar);
        this.addFooterView((View)this.footerLayout);
    }

    public boolean isDropDownStyle() {
        return this.isDropDownStyle;
    }

    public void setDropDownStyle(boolean isDropDownStyle) {
        if (this.isDropDownStyle != isDropDownStyle) {
            this.isDropDownStyle = isDropDownStyle;
            this.initDropDownStyle();
        }
    }

    public boolean isOnBottomStyle() {
        return this.isOnBottomStyle;
    }

    public void setOnBottomStyle(boolean isOnBottomStyle) {
        if (this.isOnBottomStyle != isOnBottomStyle) {
            this.isOnBottomStyle = isOnBottomStyle;
            this.initOnBottomStyle();
        }
    }

    public boolean isAutoLoadOnBottom() {
        return this.isAutoLoadOnBottom;
    }

    public void setAutoLoadOnBottom(boolean isAutoLoadOnBottom) {
        this.isAutoLoadOnBottom = isAutoLoadOnBottom;
    }

    public boolean isShowFooterProgressBar() {
        return this.isShowFooterProgressBar;
    }

    public void setShowFooterProgressBar(boolean isShowFooterProgressBar) {
        this.isShowFooterProgressBar = isShowFooterProgressBar;
    }

    public boolean isShowFooterWhenNoMore() {
        return this.isShowFooterWhenNoMore;
    }

    public void setShowFooterWhenNoMore(boolean isShowFooterWhenNoMore) {
        this.isShowFooterWhenNoMore = isShowFooterWhenNoMore;
    }

    public Button getFooterButton() {
        return this.footerButton;
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        if (this.isDropDownStyle) {
            this.setSecondPositionVisible();
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.onScrollListener = listener;
    }

    public void setOnDropDownListener(OnDropDownListener onDropDownListener) {
        this.onDropDownListener = onDropDownListener;
    }

    public void setOnBottomListener(View.OnClickListener onBottomListener) {
        this.footerButton.setOnClickListener(onBottomListener);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isDropDownStyle) {
            return super.onTouchEvent(event);
        }
        this.hasReachedTop = false;
        block0 : switch (event.getAction()) {
            case 0: {
                this.actionDownPointY = event.getY();
                break;
            }
            case 2: {
                this.adjustHeaderPadding(event);
                break;
            }
            case 1: {
                if (!this.isVerticalScrollBarEnabled()) {
                    this.setVerticalScrollBarEnabled(true);
                }
                if (this.getFirstVisiblePosition() != 0 || this.currentHeaderStatus == 4) break;
                switch (this.currentHeaderStatus) {
                    case 3: {
                        this.onDropDown();
                        break block0;
                    }
                    case 2: {
                        this.setHeaderStatusClickToLoad();
                        this.setSecondPositionVisible();
                        break block0;
                    }
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.isDropDownStyle) {
            if (this.currentScrollState == 1 && this.currentHeaderStatus != 4) {
                if (firstVisibleItem == 0) {
                    this.headerImage.setVisibility(0);
                    int pointBottom = this.headerOriginalHeight + this.headerReleaseMinDistance;
                    if (this.headerLayout.getBottom() >= pointBottom) {
                        this.setHeaderStatusReleaseToLoad();
                    } else if (this.headerLayout.getBottom() < pointBottom) {
                        this.setHeaderStatusDropDownToLoad();
                    }
                } else {
                    this.setHeaderStatusClickToLoad();
                }
            } else if (this.currentScrollState == 2 && firstVisibleItem == 0 && this.currentHeaderStatus != 4) {
                this.setSecondPositionVisible();
                this.hasReachedTop = true;
            } else if (this.currentScrollState == 2 && this.hasReachedTop) {
                this.setSecondPositionVisible();
            }
        }
        if (this.isOnBottomStyle && this.isAutoLoadOnBottom && this.hasMore && firstVisibleItem > 0 && totalItemCount > 0 && firstVisibleItem + visibleItemCount == totalItemCount) {
            this.onBottom();
        }
        if (this.onScrollListener != null) {
            this.onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.isDropDownStyle) {
            this.currentScrollState = scrollState;
            if (this.currentScrollState == 0) {
                this.hasReachedTop = false;
            }
        }
        if (this.onScrollListener != null) {
            this.onScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    private void onDropDownBegin() {
        if (this.isDropDownStyle) {
            this.setHeaderStatusLoading();
        }
    }

    public void onDropDown() {
        if (this.currentHeaderStatus != 4 && this.isDropDownStyle && this.onDropDownListener != null) {
            this.onDropDownBegin();
            this.onDropDownListener.onDropDown();
        }
    }

    public void onDropDownComplete(CharSequence secondText) {
        if (this.isDropDownStyle) {
            this.setHeaderSecondText(secondText);
            this.onDropDownComplete();
        }
    }

    public void setHeaderSecondText(CharSequence secondText) {
        if (this.isDropDownStyle) {
            if (secondText == null) {
                this.headerSecondText.setVisibility(8);
            } else {
                this.headerSecondText.setVisibility(0);
                this.headerSecondText.setText(secondText);
            }
        }
    }

    public void onDropDownComplete() {
        if (this.isDropDownStyle) {
            this.setHeaderStatusClickToLoad();
            if (this.headerLayout.getBottom() > 0) {
                this.invalidateViews();
                this.setSecondPositionVisible();
            }
        }
    }

    private void onBottomBegin() {
        if (this.isOnBottomStyle) {
            if (this.isShowFooterProgressBar) {
                this.footerProgressBar.setVisibility(0);
            }
            this.footerButton.setText((CharSequence)this.footerLoadingText);
            this.footerButton.setEnabled(false);
        }
    }

    public void onBottom() {
        if (this.isOnBottomStyle && !this.isOnBottomLoading) {
            this.isOnBottomLoading = true;
            this.onBottomBegin();
            this.footerButton.performClick();
        }
    }

    public void onBottomComplete() {
        if (this.isOnBottomStyle) {
            if (this.isShowFooterProgressBar) {
                this.footerProgressBar.setVisibility(8);
            }
            if (!this.hasMore) {
                this.footerButton.setText((CharSequence)this.footerNoMoreText);
                this.footerButton.setEnabled(false);
                if (!this.isShowFooterWhenNoMore) {
                    this.removeFooterView((View)this.footerLayout);
                }
            } else {
                this.footerButton.setText((CharSequence)this.footerDefaultText);
                this.footerButton.setEnabled(true);
            }
            this.isOnBottomLoading = false;
        }
    }

    public void setSecondPositionVisible() {
        if (this.getAdapter() != null && this.getAdapter().getCount() > 0 && this.getFirstVisiblePosition() == 0) {
            this.setSelection(1);
        }
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public RelativeLayout getHeaderLayout() {
        return this.headerLayout;
    }

    public RelativeLayout getFooterLayout() {
        return this.footerLayout;
    }

    public float getHeaderPaddingTopRate() {
        return this.headerPaddingTopRate;
    }

    public void setHeaderPaddingTopRate(float headerPaddingTopRate) {
        this.headerPaddingTopRate = headerPaddingTopRate;
    }

    public int getHeaderReleaseMinDistance() {
        return this.headerReleaseMinDistance;
    }

    public void setHeaderReleaseMinDistance(int headerReleaseMinDistance) {
        this.headerReleaseMinDistance = headerReleaseMinDistance;
    }

    public String getHeaderDefaultText() {
        return this.headerDefaultText;
    }

    public void setHeaderDefaultText(String headerDefaultText) {
        this.headerDefaultText = headerDefaultText;
        if (this.headerText != null && this.currentHeaderStatus == 1) {
            this.headerText.setText((CharSequence)headerDefaultText);
        }
    }

    public String getHeaderPullText() {
        return this.headerPullText;
    }

    public void setHeaderPullText(String headerPullText) {
        this.headerPullText = headerPullText;
    }

    public String getHeaderReleaseText() {
        return this.headerReleaseText;
    }

    public void setHeaderReleaseText(String headerReleaseText) {
        this.headerReleaseText = headerReleaseText;
    }

    public String getHeaderLoadingText() {
        return this.headerLoadingText;
    }

    public void setHeaderLoadingText(String headerLoadingText) {
        this.headerLoadingText = headerLoadingText;
    }

    public String getFooterDefaultText() {
        return this.footerDefaultText;
    }

    public void setFooterDefaultText(String footerDefaultText) {
        this.footerDefaultText = footerDefaultText;
        if (this.footerButton != null && this.footerButton.isEnabled()) {
            this.footerButton.setText((CharSequence)footerDefaultText);
        }
    }

    public String getFooterLoadingText() {
        return this.footerLoadingText;
    }

    public void setFooterLoadingText(String footerLoadingText) {
        this.footerLoadingText = footerLoadingText;
    }

    public String getFooterNoMoreText() {
        return this.footerNoMoreText;
    }

    public void setFooterNoMoreText(String footerNoMoreText) {
        this.footerNoMoreText = footerNoMoreText;
    }

    private void setHeaderStatusClickToLoad() {
        if (this.currentHeaderStatus != 1) {
            this.resetHeaderPadding();
            this.headerImage.clearAnimation();
            this.headerImage.setVisibility(8);
            this.headerProgressBar.setVisibility(8);
            this.headerText.setText((CharSequence)this.headerDefaultText);
            this.currentHeaderStatus = 1;
        }
    }

    private void setHeaderStatusDropDownToLoad() {
        if (this.currentHeaderStatus != 2) {
            this.headerImage.setVisibility(0);
            if (this.currentHeaderStatus != 1) {
                this.headerImage.clearAnimation();
                this.headerImage.startAnimation((Animation)this.reverseFlipAnimation);
            }
            this.headerProgressBar.setVisibility(8);
            this.headerText.setText((CharSequence)this.headerPullText);
            if (this.isVerticalFadingEdgeEnabled()) {
                this.setVerticalScrollBarEnabled(false);
            }
            this.currentHeaderStatus = 2;
        }
    }

    private void setHeaderStatusReleaseToLoad() {
        if (this.currentHeaderStatus != 3) {
            this.headerImage.setVisibility(0);
            this.headerImage.clearAnimation();
            this.headerImage.startAnimation((Animation)this.flipAnimation);
            this.headerProgressBar.setVisibility(8);
            this.headerText.setText((CharSequence)this.headerReleaseText);
            this.currentHeaderStatus = 3;
        }
    }

    private void setHeaderStatusLoading() {
        if (this.currentHeaderStatus != 4) {
            this.resetHeaderPadding();
            this.headerImage.setVisibility(8);
            this.headerImage.clearAnimation();
            this.headerProgressBar.setVisibility(0);
            this.headerText.setText((CharSequence)this.headerLoadingText);
            this.currentHeaderStatus = 4;
            this.setSelection(0);
        }
    }

    private void adjustHeaderPadding(MotionEvent ev) {
        int pointerCount = ev.getHistorySize();
        if (this.isVerticalFadingEdgeEnabled()) {
            this.setVerticalScrollBarEnabled(false);
        }
        int i = 0;
        while (i < pointerCount) {
            if (this.currentHeaderStatus == 2 || this.currentHeaderStatus == 3) {
                this.headerLayout.setPadding(this.headerLayout.getPaddingLeft(), (int)((ev.getHistoricalY(i) - this.actionDownPointY - (float)this.headerOriginalHeight) / this.headerPaddingTopRate), this.headerLayout.getPaddingRight(), this.headerLayout.getPaddingBottom());
            }
            ++i;
        }
    }

    private void resetHeaderPadding() {
        this.headerLayout.setPadding(this.headerLayout.getPaddingLeft(), this.headerOriginalTopPadding, this.headerLayout.getPaddingRight(), this.headerLayout.getPaddingBottom());
    }

    private void measureHeaderLayout(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private void getAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.drop_down_list_attr);
        this.isDropDownStyle = ta.getBoolean(R.styleable.drop_down_list_attr_isDropDownStyle, false);
        this.isOnBottomStyle = ta.getBoolean(R.styleable.drop_down_list_attr_isOnBottomStyle, false);
        this.isAutoLoadOnBottom = ta.getBoolean(R.styleable.drop_down_list_attr_isAutoLoadOnBottom, false);
        ta.recycle();
    }

    public static interface OnDropDownListener {
        public void onDropDown();
    }
}

