/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.flutter.plugins.imagepicker.ExifDataCopier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ImageResizer {
    private final File externalFilesDirectory;
    private final ExifDataCopier exifDataCopier;

    ImageResizer(File externalFilesDirectory, ExifDataCopier exifDataCopier) {
        this.externalFilesDirectory = externalFilesDirectory;
        this.exifDataCopier = exifDataCopier;
    }

    String resizeImageIfNeeded(String imagePath, Double maxWidth, Double maxHeight) {
        boolean shouldScale;
        boolean bl = shouldScale = maxWidth != null || maxHeight != null;
        if (!shouldScale) {
            return imagePath;
        }
        try {
            File scaledImage = this.resizedImage(imagePath, maxWidth, maxHeight);
            this.exifDataCopier.copyExif(imagePath, scaledImage.getPath());
            return scaledImage.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File resizedImage(String path, Double maxWidth, Double maxHeight) throws IOException {
        boolean shouldDownscale;
        Bitmap bmp = BitmapFactory.decodeFile((String)path);
        double originalWidth = (double)bmp.getWidth() * 1.0;
        double originalHeight = (double)bmp.getHeight() * 1.0;
        boolean hasMaxWidth = maxWidth != null;
        boolean hasMaxHeight = maxHeight != null;
        Double width = hasMaxWidth ? Math.min(originalWidth, maxWidth) : originalWidth;
        Double height = hasMaxHeight ? Math.min(originalHeight, maxHeight) : originalHeight;
        boolean shouldDownscaleWidth = hasMaxWidth && maxWidth < originalWidth;
        boolean shouldDownscaleHeight = hasMaxHeight && maxHeight < originalHeight;
        boolean bl = shouldDownscale = shouldDownscaleWidth || shouldDownscaleHeight;
        if (shouldDownscale) {
            double downscaledWidth = height / originalHeight * originalWidth;
            double downscaledHeight = width / originalWidth * originalHeight;
            if (width < height) {
                if (!hasMaxWidth) {
                    width = downscaledWidth;
                } else {
                    height = downscaledHeight;
                }
            } else if (height < width) {
                if (!hasMaxHeight) {
                    height = downscaledHeight;
                } else {
                    width = downscaledWidth;
                }
            } else if (originalWidth < originalHeight) {
                width = downscaledWidth;
            } else if (originalHeight < originalWidth) {
                height = downscaledHeight;
            }
        }
        Bitmap scaledBmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)width.intValue(), (int)height.intValue(), (boolean)false);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        scaledBmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        String[] pathParts = path.split("/");
        String imageName = pathParts[pathParts.length - 1];
        File imageFile = new File(this.externalFilesDirectory, "/scaled_" + imageName);
        FileOutputStream fileOutput = new FileOutputStream(imageFile);
        fileOutput.write(outputStream.toByteArray());
        fileOutput.close();
        return imageFile;
    }
}

