/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class ITFWriter
extends UPCEANWriter {
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.ITF) {
            throw new IllegalArgumentException("Can only encode ITF, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    public byte[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        byte[] result = new byte[9 + 9 * length];
        int[] start = new int[]{1, 1, 1, 1};
        int pos = ITFWriter.appendPattern(result, 0, start, 1);
        for (int i = 0; i < length; i += 2) {
            int one = Character.digit(contents.charAt(i), 10);
            int two = Character.digit(contents.charAt(i + 1), 10);
            int[] encoding = new int[18];
            for (int j = 0; j < 5; ++j) {
                encoding[j << 1] = ITFReader.PATTERNS[one][j];
                encoding[(j << 1) + 1] = ITFReader.PATTERNS[two][j];
            }
            pos += ITFWriter.appendPattern(result, pos, encoding, 1);
        }
        int[] end = new int[]{3, 1, 1};
        pos += ITFWriter.appendPattern(result, pos, end, 1);
        return result;
    }
}

