/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class VMDGraphScene
extends GraphPinScene<String, String, String> {
    public static final String PIN_ID_DEFAULT_SUFFIX = "#default";
    private LayerWidget backgroundLayer = new LayerWidget(this);
    private LayerWidget mainLayer = new LayerWidget(this);
    private LayerWidget connectionLayer = new LayerWidget(this);
    private LayerWidget upperLayer = new LayerWidget(this);
    private Router router;
    private WidgetAction moveControlPointAction = ActionFactory.createOrthogonalMoveControlPointAction();
    private WidgetAction moveAction = ActionFactory.createMoveAction();
    private SceneLayout sceneLayout;
    private VMDColorScheme scheme;

    public VMDGraphScene() {
        this(VMDFactory.getOriginalScheme());
    }

    public VMDGraphScene(VMDColorScheme vMDColorScheme) {
        this.scheme = vMDColorScheme;
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.addChild(this.backgroundLayer);
        this.addChild(this.mainLayer);
        this.addChild(this.connectionLayer);
        this.addChild(this.upperLayer);
        this.router = RouterFactory.createOrthogonalSearchRouter(this.mainLayer, this.connectionLayer);
        this.getActions().addAction(ActionFactory.createZoomAction());
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createRectangularSelectAction(this, this.backgroundLayer));
        this.sceneLayout = LayoutFactory.createSceneGraphLayout(this, new GridGraphLayout().setChecker(true));
    }

    @Override
    protected Widget attachNodeWidget(String string) {
        VMDNodeWidget vMDNodeWidget = new VMDNodeWidget(this, this.scheme);
        this.mainLayer.addChild(vMDNodeWidget);
        vMDNodeWidget.getHeader().getActions().addAction(this.createObjectHoverAction());
        vMDNodeWidget.getActions().addAction(this.createSelectAction());
        vMDNodeWidget.getActions().addAction(this.moveAction);
        return vMDNodeWidget;
    }

    @Override
    protected Widget attachPinWidget(String string, String string2) {
        if (string2.endsWith(PIN_ID_DEFAULT_SUFFIX)) {
            return null;
        }
        VMDPinWidget vMDPinWidget = new VMDPinWidget(this, this.scheme);
        ((VMDNodeWidget)this.findWidget(string)).attachPinWidget(vMDPinWidget);
        vMDPinWidget.getActions().addAction(this.createObjectHoverAction());
        vMDPinWidget.getActions().addAction(this.createSelectAction());
        return vMDPinWidget;
    }

    @Override
    protected Widget attachEdgeWidget(String string) {
        VMDConnectionWidget vMDConnectionWidget = new VMDConnectionWidget((Scene)this, this.scheme);
        vMDConnectionWidget.setRouter(this.router);
        this.connectionLayer.addChild(vMDConnectionWidget);
        vMDConnectionWidget.getActions().addAction(this.createObjectHoverAction());
        vMDConnectionWidget.getActions().addAction(this.createSelectAction());
        vMDConnectionWidget.getActions().addAction(this.moveControlPointAction);
        return vMDConnectionWidget;
    }

    @Override
    protected void attachEdgeSourceAnchor(String string, String string2, String string3) {
        ((ConnectionWidget)this.findWidget(string)).setSourceAnchor(this.getPinAnchor(string3));
    }

    @Override
    protected void attachEdgeTargetAnchor(String string, String string2, String string3) {
        ((ConnectionWidget)this.findWidget(string)).setTargetAnchor(this.getPinAnchor(string3));
    }

    private Anchor getPinAnchor(String string) {
        Anchor anchor;
        if (string == null) {
            return null;
        }
        VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)this.findWidget(this.getPinNode(string));
        Widget widget = this.findWidget(string);
        if (widget != null) {
            anchor = AnchorFactory.createDirectionalAnchor(widget, AnchorFactory.DirectionalAnchorKind.HORIZONTAL, 8);
            anchor = vMDNodeWidget.createAnchorPin(anchor);
        } else {
            anchor = vMDNodeWidget.getNodeAnchor();
        }
        return anchor;
    }

    public void layoutScene() {
        this.sceneLayout.invokeLayout();
    }
}

