/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public final class MoveAction
extends WidgetAction.LockedAdapter {
    private MoveStrategy strategy;
    private MoveProvider provider;
    private Widget movingWidget = null;
    private Point dragSceneLocation = null;
    private Point originalSceneLocation = null;
    private Point initialMouseLocation = null;

    public MoveAction(MoveStrategy moveStrategy, MoveProvider moveProvider) {
        this.strategy = moveStrategy;
        this.provider = moveProvider;
    }

    @Override
    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1) {
            this.movingWidget = widget;
            this.initialMouseLocation = widgetMouseEvent.getPoint();
            this.originalSceneLocation = this.provider.getOriginalLocation(widget);
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widget.convertLocalToScene(widgetMouseEvent.getPoint());
            this.provider.movementStarted(widget);
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        boolean bl = this.initialMouseLocation != null && this.initialMouseLocation.equals(widgetMouseEvent.getPoint()) ? true : this.move(widget, widgetMouseEvent.getPoint());
        if (bl) {
            this.movingWidget = null;
            this.dragSceneLocation = null;
            this.originalSceneLocation = null;
            this.initialMouseLocation = null;
            this.provider.movementFinished(widget);
        }
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.movingWidget != widget) {
            return false;
        }
        this.initialMouseLocation = null;
        point = widget.convertLocalToScene(point);
        Point point2 = new Point(this.originalSceneLocation.x + point.x - this.dragSceneLocation.x, this.originalSceneLocation.y + point.y - this.dragSceneLocation.y);
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, this.originalSceneLocation, point2));
        return true;
    }
}

