/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.util.Arrays;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.Sha2Crypt;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class Sha512CryptTest {
    @Test
    public void testSha512CryptStrings() {
        Assert.assertEquals((Object)"$6$foo$Nywkte7LPWjaJhWjNeGJN.dFdY3pN1wYlGifyRLYOVlGS9EMSiZaDDe/BGSOYQ327q9.32I4UqQ5odsqvsBLX/", (Object)Crypt.crypt((String)"", (String)"$6$foo"));
        Assert.assertEquals((Object)"$6$45678$f2en/Y053Knir/wu/T8DQKSbiUGcPcbXKsmyVlP820dIpXoY0KlqgUqRVFfavdRXwDMUZYsxPOymA4zgX0qE5.", (Object)Crypt.crypt((String)"secret", (String)"$6$45678"));
        Assert.assertEquals((Object)"$6$45678$f2en/Y053Knir/wu/T8DQKSbiUGcPcbXKsmyVlP820dIpXoY0KlqgUqRVFfavdRXwDMUZYsxPOymA4zgX0qE5.", (Object)Crypt.crypt((String)"secret", (String)"$6$45678$012"));
        Assert.assertEquals((Object)"$6$45678$f2en/Y053Knir/wu/T8DQKSbiUGcPcbXKsmyVlP820dIpXoY0KlqgUqRVFfavdRXwDMUZYsxPOymA4zgX0qE5.", (Object)Crypt.crypt((String)"secret", (String)"$6$45678$012$456"));
        Assert.assertEquals((Object)"$6$1234567890123456$d2HCAnimIF5VMqUnwaZ/4JhNDJ.ttsjm0nbbmc9eE7xUYiw79GMvXUc5ZqG5BlqkXSbASZxrvR0QefAgdLbeH.", (Object)Crypt.crypt((String)"secret", (String)"$6$1234567890123456"));
        Assert.assertEquals((Object)"$6$1234567890123456$d2HCAnimIF5VMqUnwaZ/4JhNDJ.ttsjm0nbbmc9eE7xUYiw79GMvXUc5ZqG5BlqkXSbASZxrvR0QefAgdLbeH.", (Object)Crypt.crypt((String)"secret", (String)"$6$1234567890123456789"));
    }

    @Test
    public void testSha512CryptBytes() {
        Assert.assertEquals((Object)"$6$foo$Nywkte7LPWjaJhWjNeGJN.dFdY3pN1wYlGifyRLYOVlGS9EMSiZaDDe/BGSOYQ327q9.32I4UqQ5odsqvsBLX/", (Object)Crypt.crypt((byte[])new byte[0], (String)"$6$foo"));
        Assert.assertEquals((Object)"$6$./$fKtWqslQkwI8ZxjdWoeS.jHHrte97bZxiwB5gwCRHX6LG62fUhT6Bb5MRrjWvieh0C/gxh8ItFuTsVy80VrED1", (Object)Crypt.crypt((String)"t\u00e4st", (String)"$6$./$"));
        Assert.assertEquals((Object)"$6$./$L49DSK.d2df/LxGLJQMyS5A/Um.TdHqgc46j5FpScEPlqQHP5dEazltaDNDZ6UEs2mmNI6kPwtH/rsP9g5zBI.", (Object)Crypt.crypt((byte[])"t\u00e4st".getBytes(Charsets.ISO_8859_1), (String)"$6$./$"));
    }

    @Test
    public void testSha512CryptExplicitCall() {
        Assert.assertTrue((boolean)Sha2Crypt.sha512Crypt((byte[])"secret".getBytes()).matches("^\\$6\\$[a-zA-Z0-9./]{0,16}\\$.{1,}$"));
        Assert.assertTrue((boolean)Sha2Crypt.sha512Crypt((byte[])"secret".getBytes(), null).matches("^\\$6\\$[a-zA-Z0-9./]{0,16}\\$.{1,}$"));
    }

    @Test(expected=NullPointerException.class)
    public void testSha512CryptNullData() {
        Sha2Crypt.sha512Crypt((byte[])null);
    }

    @Ignore
    public void testSha512CryptNullSalt() {
    }

    @Test
    public void testSha2CryptRounds() {
        Assert.assertEquals((Object)"$5$rounds=1000$abcd$b8MCU4GEeZIekOy5ahQ8EWfT330hvYGVeDYkBxXBva.", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=50$abcd$"));
        Assert.assertEquals((Object)"$5$rounds=1001$abcd$SQsJZs7KXKdd2DtklI3TY3tkD7UYA99RD0FBLm4Sk48", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=1001$abcd$"));
        Assert.assertEquals((Object)"$5$rounds=9999$abcd$Rh/8ngVh9oyuS6lL3.fsq.9xbvXJsfyKWxSjO2mPIa7", (Object)Sha2Crypt.sha256Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"$5$rounds=9999$abcd"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha2CryptWrongSalt() {
        Sha2Crypt.sha512Crypt((byte[])"secret".getBytes(Charsets.UTF_8), (String)"xx");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha512CryptWithEmptySalt() {
        Sha2Crypt.sha512Crypt((byte[])"secret".getBytes(), (String)"");
    }

    @Test
    public void testSha256LargetThanBlocksize() {
        byte[] buffer = new byte[200];
        Arrays.fill(buffer, 0, 200, (byte)65);
        Assert.assertEquals((Object)"$6$abc$oP/h8PRhCKIA66KSTjGwNsQMSLLZnuFOTjOhrqNrDkKgjTlpePSqibB0qtmDapMbP/zN1cUEYSeHFrpgqZ.GG1", (Object)Sha2Crypt.sha512Crypt((byte[])buffer, (String)"$6$abc"));
    }
}

