/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.laf;

import java.awt.Color;
import java.awt.Paint;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.laf.LookFeel;
import org.netbeans.api.visual.model.ObjectState;

public class DefaultLookFeel
extends LookFeel {
    private static final Color COLOR_SELECTED = new Color(4488141);
    private static final Color COLOR_HIGHLIGHTED = COLOR_SELECTED.darker();
    private static final Color COLOR_HOVERED = COLOR_SELECTED.brighter();
    private static final int MARGIN = 3;
    private static final int ARC = 10;
    private static final int MINI_THICKNESS = 1;
    private static final Border BORDER_NORMAL = BorderFactory.createEmptyBorder(3, 3);
    private static final Border BORDER_HOVERED = BorderFactory.createRoundedBorder(10, 10, 3, 3, COLOR_HOVERED, COLOR_HOVERED.darker());
    private static final Border BORDER_SELECTED = BorderFactory.createRoundedBorder(10, 10, 3, 3, COLOR_SELECTED, COLOR_SELECTED.darker());
    private static final Border MINI_BORDER_NORMAL = BorderFactory.createEmptyBorder(1);
    private static final Border MINI_BORDER_HOVERED = BorderFactory.createRoundedBorder(1, 1, 1, 1, COLOR_HOVERED, COLOR_HOVERED.darker());
    private static final Border MINI_BORDER_SELECTED = BorderFactory.createRoundedBorder(1, 1, 1, 1, COLOR_SELECTED, COLOR_SELECTED.darker());

    @Override
    public Paint getBackground() {
        return Color.WHITE;
    }

    @Override
    public Color getForeground() {
        return Color.BLACK;
    }

    @Override
    public Border getBorder(ObjectState objectState) {
        if (objectState.isHovered()) {
            return BORDER_HOVERED;
        }
        if (objectState.isSelected()) {
            return BORDER_SELECTED;
        }
        if (objectState.isFocused()) {
            return BORDER_HOVERED;
        }
        return BORDER_NORMAL;
    }

    @Override
    public Border getMiniBorder(ObjectState objectState) {
        if (objectState.isHovered()) {
            return MINI_BORDER_HOVERED;
        }
        if (objectState.isSelected()) {
            return MINI_BORDER_SELECTED;
        }
        if (objectState.isFocused()) {
            return MINI_BORDER_HOVERED;
        }
        return MINI_BORDER_NORMAL;
    }

    @Override
    public boolean getOpaque(ObjectState objectState) {
        return objectState.isHovered() || objectState.isSelected();
    }

    @Override
    public Color getLineColor(ObjectState objectState) {
        if (objectState.isHovered()) {
            return COLOR_HOVERED;
        }
        if (objectState.isSelected()) {
            return COLOR_SELECTED;
        }
        if (objectState.isHighlighted() || objectState.isFocused()) {
            return COLOR_HIGHLIGHTED;
        }
        return Color.BLACK;
    }

    @Override
    public Paint getBackground(ObjectState objectState) {
        if (objectState.isHovered()) {
            return COLOR_HOVERED;
        }
        if (objectState.isSelected()) {
            return COLOR_SELECTED;
        }
        if (objectState.isHighlighted() || objectState.isFocused()) {
            return COLOR_HIGHLIGHTED;
        }
        return Color.WHITE;
    }

    @Override
    public Color getForeground(ObjectState objectState) {
        return objectState.isSelected() ? Color.WHITE : Color.BLACK;
    }

    @Override
    public int getMargin() {
        return 3;
    }
}

