/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.cloud;

import com.baidu.mapapi.CoordType;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.cloud.BaseCloudSearchInfo;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.util.CoordTrans;

public class NearbySearchInfo
extends BaseCloudSearchInfo {
    public String location;
    public int radius;

    public NearbySearchInfo() {
        this.a = "http://api.map.baidu.com/geosearch/v2/nearby";
        this.radius = 1000;
    }

    @Override
    String a() {
        StringBuilder stringBuilder = new StringBuilder();
        if (super.a() == null) {
            return null;
        }
        stringBuilder.append(super.a());
        if (this.location != null && !this.location.equals("")) {
            if (SDKInitializer.getCoordType() == CoordType.GCJ02) {
                String[] stringArray = this.location.split(",");
                try {
                    LatLng latLng = new LatLng(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
                    latLng = CoordTrans.gcjToBaidu(latLng);
                    this.location = latLng.longitude + "," + latLng.latitude;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            return null;
        }
        stringBuilder.append("&");
        stringBuilder.append("location");
        stringBuilder.append("=");
        stringBuilder.append(this.location);
        if (this.radius >= 0) {
            stringBuilder.append("&");
            stringBuilder.append("radius");
            stringBuilder.append("=");
            stringBuilder.append(this.radius);
        }
        return stringBuilder.toString();
    }
}

