/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.x.base.core.container.EntityManagerContainer;
import com.x.base.core.container.factory.EntityManagerContainerFactory;
import com.x.base.core.entity.JpaObject;
import com.x.base.core.entity.StorageObject;
import com.x.base.core.entity.dataitem.DataItem;
import com.x.base.core.entity.dataitem.ItemCategory;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataMappings;
import com.x.base.core.project.config.StorageMapping;
import com.x.base.core.project.config.StorageMappings;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DateTools;
import com.x.base.core.project.tools.ListTools;
import com.x.base.core.project.tools.StringTools;
import com.x.processplatform.core.entity.content.Attachment;
import com.x.processplatform.core.entity.content.Hint;
import com.x.processplatform.core.entity.content.Read;
import com.x.processplatform.core.entity.content.ReadCompleted;
import com.x.processplatform.core.entity.content.Review;
import com.x.processplatform.core.entity.content.SerialNumber;
import com.x.processplatform.core.entity.content.Task;
import com.x.processplatform.core.entity.content.TaskCompleted;
import com.x.processplatform.core.entity.content.Work;
import com.x.processplatform.core.entity.content.WorkCompleted;
import com.x.processplatform.core.entity.content.WorkLog;
import com.x.query.core.entity.Item;
import com.x.server.console.action.PersistenceXmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;

public class ActionEraseContentProcessPlatform {
    private static Logger logger = LoggerFactory.getLogger(ActionEraseContentProcessPlatform.class);
    private Date start;
    private String name;
    private List<Class<?>> classes = new ArrayList();
    private ItemCategory itemCategory;

    public boolean execute(String password) throws Exception {
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
            logger.print("password not match.", new Object[0]);
            return false;
        }
        this.init("processPlatform", ItemCategory.pp);
        this.addClass(Attachment.class);
        this.addClass(Hint.class);
        this.addClass(Read.class);
        this.addClass(ReadCompleted.class);
        this.addClass(Review.class);
        this.addClass(SerialNumber.class);
        this.addClass(Task.class);
        this.addClass(TaskCompleted.class);
        this.addClass(Work.class);
        this.addClass(WorkCompleted.class);
        this.addClass(WorkLog.class);
        this.addClass(Item.class);
        this.run();
        return true;
    }

    protected void addClass(Class<?> cls) throws Exception {
        this.classes.add(cls);
    }

    protected void init(String name, ItemCategory itemCategory) throws Exception {
        this.name = name;
        this.itemCategory = itemCategory;
        this.start = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Exception {
        logger.print("clean {} content data, start at {}.", new Object[]{this.name, DateTools.format((Date)this.start)});
        DataMappings mappings = Config.dataMappings();
        StorageMappings storageMappings = Config.storageMappings();
        File orm = this.createPersistenceXml(this.classes, mappings);
        EntityManagerContainerFactory.init((String)orm.getName());
        try (EntityManagerContainer emc = EntityManagerContainerFactory.instance().create();){
            for (int i = 0; i < this.classes.size(); ++i) {
                Class<?> cls = this.classes.get(i);
                EntityManager em = emc.get(cls);
                try {
                    if (DataItem.class.isAssignableFrom(cls)) {
                        logger.print("erase {} content data:{}, total:{}.", new Object[]{this.name, cls.getName(), this.estimateItemCount(em, cls)});
                        this.eraseItem(cls, em);
                        continue;
                    }
                    logger.print("erase {} content data:{}, total:{}.", new Object[]{this.name, cls.getName(), this.estimateCount(em, cls)});
                    this.erase(cls, em, storageMappings);
                    continue;
                }
                finally {
                    System.gc();
                }
            }
        }
        Date end = new Date();
        logger.print("erase {} completed at {}, elapsed: {} ms.", new Object[]{this.name, DateTools.format((Date)end), end.getTime() - this.start.getTime()});
    }

    private <T extends JpaObject> long estimateCount(EntityManager em, Class<T> cls) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(cls);
        cq.select((Selection)cb.count((Expression)root));
        return (Long)em.createQuery(cq).getSingleResult();
    }

    private <T extends JpaObject> long estimateItemCount(EntityManager em, Class<T> cls) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(cls);
        Predicate p = cb.equal((Expression)root.get("itemCategory"), (Object)this.itemCategory);
        cq.select((Selection)cb.count((Expression)root)).where((Expression)p);
        return (Long)em.createQuery(cq).getSingleResult();
    }

    private <T> Long erase(Class<T> cls, EntityManager em, StorageMappings storageMappings) throws Exception {
        Long count = 0L;
        List list = null;
        do {
            if (ListTools.isNotEmpty((List[])new List[]{list})) {
                em.getTransaction().begin();
                for (Object t : list) {
                    em.remove(t);
                }
                em.getTransaction().commit();
                if (StorageObject.class.isAssignableFrom(cls)) {
                    for (Object t : list) {
                        StorageObject storageObject = (StorageObject)t;
                        String name = storageObject.getStorage();
                        StorageMapping mapping = storageMappings.get(storageObject.getClass(), name);
                        if (null != mapping) {
                            storageObject.deleteContent(mapping);
                            continue;
                        }
                        System.out.println("can not find storage mapping:" + name + ".");
                    }
                }
                count = count + (long)list.size();
            }
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(cls);
            Root root = cq.from(cls);
            cq.select((Selection)root);
            list = em.createQuery(cq).setMaxResults(1000).getResultList();
        } while (ListTools.isNotEmpty((List[])new List[]{list}));
        return count;
    }

    private <T> Long eraseItem(Class<T> cls, EntityManager em) throws Exception {
        Long count = 0L;
        List list = null;
        do {
            if (ListTools.isNotEmpty((List[])new List[]{list})) {
                em.getTransaction().begin();
                for (Object t : list) {
                    em.remove(t);
                }
                em.getTransaction().commit();
                count = count + (long)list.size();
            }
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(cls);
            Root root = cq.from(cls);
            Predicate p = cb.equal((Expression)root.get("itemCategory"), (Object)this.itemCategory);
            cq.select((Selection)root).where((Expression)p);
            list = em.createQuery(cq).setMaxResults(1000).getResultList();
        } while (ListTools.isNotEmpty((List[])new List[]{list}));
        return count;
    }

    private File createPersistenceXml(List<Class<?>> clsList, DataMappings mappings) throws Exception {
        File dir = new File(Config.base(), "local/temp/classes");
        File xml = new File(dir, StringTools.uniqueToken() + "_eraseContent.xml");
        PersistenceXmlHelper.createPersistenceXml(clsList, mappings, xml);
        return xml;
    }
}

