/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.swapcommand;

import com.x.base.core.project.config.Config;
import com.x.server.console.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;

public class Exit {
    private static final String MANIFEST_FILENAME = "manifest.cfg";

    public static void main(String ... args) throws Exception {
        String base = Exit.getBasePath();
        Exit.loadJars(base);
        try (RandomAccessFile raf = new RandomAccessFile(Config.base() + "/command.swap", "rw");){
            FileChannel fc = raf.getChannel();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, 0L, 256L);
            FileLock flock = null;
            flock = fc.lock();
            mbb.put("exit".getBytes());
            flock.release();
        }
    }

    private static List<String> readManifest(File file) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    private static void loadJars(String base) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        File extDir = new File(base, "commons/ext");
        File extDirManifest = new File(extDir, MANIFEST_FILENAME);
        if (!extDirManifest.exists()) {
            throw new Exception("can not find manifest.cfg in commons/ext.");
        }
        List<String> extDirManifestNames = Exit.readManifest(extDirManifest);
        if (extDirManifestNames.isEmpty()) {
            throw new Exception("commons/ext manifest is empty.");
        }
        for (File file : extDir.listFiles()) {
            if (file.getName().equals(MANIFEST_FILENAME)) continue;
            if (!extDirManifestNames.contains(file.getName())) {
                file.delete();
                continue;
            }
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
        }
        File jarsDir = new File(base, "store/jars");
        File jarsDirManifest = new File(jarsDir, MANIFEST_FILENAME);
        if (!jarsDirManifest.exists()) {
            throw new Exception("can not find manifest.cfg in store/jars.");
        }
        List<String> jarsDirManifestNames = Exit.readManifest(jarsDirManifest);
        for (File file : jarsDir.listFiles()) {
            if (file.getName().equals(MANIFEST_FILENAME)) continue;
            if (!jarsDirManifestNames.contains(file.getName())) {
                file.delete();
                continue;
            }
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
        }
        File file = new File(base, "local/temp/classes");
        method.invoke((Object)urlClassLoader, file.toURI().toURL());
    }

    private static String getBasePath() throws Exception {
        String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File file = new File(path);
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (null != file) {
            File versionFile = new File(file, "version.o2");
            if (versionFile.exists()) {
                return file.getAbsolutePath();
            }
            file = file.getParentFile();
        }
        throw new Exception("can not define o2server base directory.");
    }
}

