/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.x.base.core.container.FactorDistributionPolicy;
import com.x.base.core.container.factory.SlicePropertiesBuilder;
import com.x.base.core.entity.Storage;
import com.x.base.core.entity.annotation.ContainerEntity;
import com.x.base.core.project.config.DataMapping;
import com.x.base.core.project.config.DataMappings;
import com.x.base.core.project.tools.ClassTools;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.base.core.project.tools.ListTools;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class PersistenceXmlHelper {
    public static void createPersistenceXml(Class<?> cls, List<DataMapping> sources, File file) throws Exception {
        Document document = DocumentHelper.createDocument();
        Element persistence = document.addElement("persistence", "http://java.sun.com/xml/ns/persistence");
        persistence.addAttribute(QName.get((String)"schemaLocation", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), "http://java.sun.com/xml/ns/persistence  http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd");
        persistence.addAttribute("version", "2.0");
        Element unit = persistence.addElement("persistence-unit");
        unit.addAttribute("transaction-type", "RESOURCE_LOCAL");
        unit.addAttribute("name", cls.getName());
        Element provider = unit.addElement("provider");
        provider.addText(PersistenceProviderImpl.class.getName());
        HashSet classes = new HashSet();
        classes.add(cls);
        classes.addAll(PersistenceXmlHelper.scanMappedSuperclass(cls));
        for (Class clazz : classes) {
            Element element = unit.addElement("class");
            element.addText(clazz.getCanonicalName());
        }
        Element properties = unit.addElement("properties");
        Element element = properties.addElement("property");
        element.addAttribute("name", "openjpa.BrokerFactory");
        element.addAttribute("value", "slice");
        Element element2 = properties.addElement("property");
        element2.addAttribute("name", "openjpa.Log");
        element2.addAttribute("value", "DefaultLevel=WARN");
        Element element3 = properties.addElement("property");
        element3.addAttribute("name", "openjpa.jdbc.DBDictionary");
        element3.addAttribute("value", SlicePropertiesBuilder.determineDBDictionary((DataMapping)sources.get(0)));
        Element element4 = properties.addElement("property");
        element4.addAttribute("name", "openjpa.slice.Lenient");
        element4.addAttribute("value", "false");
        Element element5 = properties.addElement("property");
        element5.addAttribute("name", "openjpa.slice.DistributionPolicy");
        element5.addAttribute("value", FactorDistributionPolicy.class.getName());
        Element element6 = properties.addElement("property");
        element6.addAttribute("name", "openjpa.slice.Names");
        element6.addAttribute("value", SlicePropertiesBuilder.getSliceNames(sources));
        Element element7 = properties.addElement("property");
        element7.addAttribute("name", "openjpa.ConnectionDriverName");
        element7.addAttribute("value", SlicePropertiesBuilder.getConnectionDriverName((DataMapping)sources.get(0)));
        Element element8 = properties.addElement("property");
        element8.addAttribute("name", "openjpa.QueryCompilationCache");
        element8.addAttribute("value", "false");
        Element element9 = properties.addElement("property");
        element9.addAttribute("name", "openjpa.IgnoreChanges");
        element9.addAttribute("value", "true");
        Element element10 = properties.addElement("property");
        element10.addAttribute("name", "openjpa.jdbc.ResultSetType");
        element10.addAttribute("value", "scroll-insensitive");
        Element element11 = properties.addElement("property");
        element11.addAttribute("name", "openjpa.jdbc.SynchronizeMappings");
        element11.addAttribute("value", "buildSchema(ForeignKeys=false)");
        Element element12 = properties.addElement("property");
        element12.addAttribute("name", "openjpa.LockManager");
        element12.addAttribute("value", "none");
        Element element13 = properties.addElement("property");
        element13.addAttribute("name", "openjpa.RuntimeUnenhancedClasses");
        element13.addAttribute("value", "supported");
        Element element14 = properties.addElement("property");
        element14.addAttribute("name", "openjpa.ConnectionUserName");
        element14.addAttribute("value", sources.get(0).getUsername());
        Element element15 = properties.addElement("property");
        element15.addAttribute("name", "openjpa.ConnectionPassword");
        element15.addAttribute("value", sources.get(0).getPassword());
        String driver = SlicePropertiesBuilder.getConnectionDriverName((DataMapping)sources.get(0));
        if (StringUtils.equals((CharSequence)driver, (CharSequence)SlicePropertiesBuilder.driver_db2) || StringUtils.equals((CharSequence)driver, (CharSequence)SlicePropertiesBuilder.driver_informix)) {
            Element element16 = properties.addElement("property");
            element16.addAttribute("name", "openjpa.jdbc.Schema");
            element16.addAttribute("value", "X");
        }
        for (int i = 0; i < sources.size(); ++i) {
            DataMapping dataMapping = sources.get(i);
            String name = SlicePropertiesBuilder.getName((Integer)i);
            Element element17 = properties.addElement("property");
            element17.addAttribute("name", "openjpa.slice." + name + ".ConnectionUserName");
            element17.addAttribute("value", dataMapping.getUsername());
            Element element18 = properties.addElement("property");
            element18.addAttribute("name", "openjpa.slice." + name + ".ConnectionPassword");
            element18.addAttribute("value", dataMapping.getPassword());
            Element element19 = properties.addElement("property");
            element19.addAttribute("name", "openjpa.slice." + name + ".ConnectionDriverName");
            element19.addAttribute("value", SlicePropertiesBuilder.getConnectionDriverName((DataMapping)dataMapping));
            Element element20 = properties.addElement("property");
            element20.addAttribute("name", "openjpa.slice." + name + ".ConnectionURL");
            element20.addAttribute("value", dataMapping.getUrl());
            Element element21 = properties.addElement("property");
            element21.addAttribute("name", "openjpa.slice." + name + ".Log");
            element21.addAttribute("value", PersistenceXmlHelper.getLog(dataMapping));
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(DefaultCharset.name);
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(file), format);
        writer.write(document);
        writer.close();
    }

    public static void createPersistenceXml(List<Class<?>> clsList, DataMappings mappings, File file) throws Exception {
        Document document = DocumentHelper.createDocument();
        Element persistence = document.addElement("persistence", "http://java.sun.com/xml/ns/persistence");
        persistence.addAttribute(QName.get((String)"schemaLocation", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), "http://java.sun.com/xml/ns/persistence  http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd");
        persistence.addAttribute("version", "2.0");
        for (Class<?> cls : clsList) {
            List sources = (List)mappings.get((Object)cls.getName());
            Element unit = persistence.addElement("persistence-unit");
            unit.addAttribute("transaction-type", "RESOURCE_LOCAL");
            unit.addAttribute("name", cls.getName());
            Element provider = unit.addElement("provider");
            provider.addText(PersistenceProviderImpl.class.getName());
            HashSet classes = new HashSet();
            classes.add(cls);
            classes.addAll(PersistenceXmlHelper.scanMappedSuperclass(cls));
            for (Class clazz : classes) {
                Element element = unit.addElement("class");
                element.addText(clazz.getCanonicalName());
            }
            Element properties = unit.addElement("properties");
            Element element = properties.addElement("property");
            element.addAttribute("name", "openjpa.BrokerFactory");
            element.addAttribute("value", "slice");
            Element element2 = properties.addElement("property");
            element2.addAttribute("name", "openjpa.Log");
            element2.addAttribute("value", "DefaultLevel=WARN");
            Element element3 = properties.addElement("property");
            element3.addAttribute("name", "openjpa.jdbc.DBDictionary");
            element3.addAttribute("value", SlicePropertiesBuilder.determineDBDictionary((DataMapping)((DataMapping)sources.get(0))));
            Element element4 = properties.addElement("property");
            element4.addAttribute("name", "openjpa.slice.Lenient");
            element4.addAttribute("value", "false");
            Element element5 = properties.addElement("property");
            element5.addAttribute("name", "openjpa.slice.DistributionPolicy");
            element5.addAttribute("value", FactorDistributionPolicy.class.getName());
            Element element6 = properties.addElement("property");
            element6.addAttribute("name", "openjpa.slice.Names");
            element6.addAttribute("value", SlicePropertiesBuilder.getSliceNames((List)sources));
            Element element7 = properties.addElement("property");
            element7.addAttribute("name", "openjpa.ConnectionDriverName");
            element7.addAttribute("value", SlicePropertiesBuilder.getConnectionDriverName((DataMapping)((DataMapping)sources.get(0))));
            Element element8 = properties.addElement("property");
            element8.addAttribute("name", "openjpa.QueryCompilationCache");
            element8.addAttribute("value", "false");
            Element element9 = properties.addElement("property");
            element9.addAttribute("name", "openjpa.IgnoreChanges");
            element9.addAttribute("value", "true");
            Element element10 = properties.addElement("property");
            element10.addAttribute("name", "openjpa.jdbc.ResultSetType");
            element10.addAttribute("value", "scroll-insensitive");
            Element element11 = properties.addElement("property");
            element11.addAttribute("name", "openjpa.jdbc.SynchronizeMappings");
            element11.addAttribute("value", "buildSchema(ForeignKeys=false)");
            Element element12 = properties.addElement("property");
            element12.addAttribute("name", "openjpa.LockManager");
            element12.addAttribute("value", "none");
            Element element13 = properties.addElement("property");
            element13.addAttribute("name", "openjpa.RuntimeUnenhancedClasses");
            element13.addAttribute("value", "supported");
            Element element14 = properties.addElement("property");
            element14.addAttribute("name", "openjpa.ConnectionUserName");
            element14.addAttribute("value", ((DataMapping)sources.get(0)).getUsername());
            Element element15 = properties.addElement("property");
            element15.addAttribute("name", "openjpa.ConnectionPassword");
            element15.addAttribute("value", ((DataMapping)sources.get(0)).getPassword());
            String driver = SlicePropertiesBuilder.getConnectionDriverName((DataMapping)((DataMapping)sources.get(0)));
            if (StringUtils.equals((CharSequence)driver, (CharSequence)SlicePropertiesBuilder.driver_db2) || StringUtils.equals((CharSequence)driver, (CharSequence)SlicePropertiesBuilder.driver_informix)) {
                Element element16 = properties.addElement("property");
                element16.addAttribute("name", "openjpa.jdbc.Schema");
                element16.addAttribute("value", "X");
            }
            for (int i = 0; i < sources.size(); ++i) {
                DataMapping dataMapping = (DataMapping)sources.get(i);
                String name = SlicePropertiesBuilder.getName((Integer)i);
                Element element17 = properties.addElement("property");
                element17.addAttribute("name", "openjpa.slice." + name + ".ConnectionUserName");
                element17.addAttribute("value", dataMapping.getUsername());
                Element element18 = properties.addElement("property");
                element18.addAttribute("name", "openjpa.slice." + name + ".ConnectionPassword");
                element18.addAttribute("value", dataMapping.getPassword());
                Element element19 = properties.addElement("property");
                element19.addAttribute("name", "openjpa.slice." + name + ".ConnectionDriverName");
                element19.addAttribute("value", SlicePropertiesBuilder.getConnectionDriverName((DataMapping)dataMapping));
                Element element20 = properties.addElement("property");
                element20.addAttribute("name", "openjpa.slice." + name + ".ConnectionURL");
                element20.addAttribute("value", dataMapping.getUrl());
                Element element21 = properties.addElement("property");
                element21.addAttribute("name", "openjpa.slice." + name + ".Log");
                element21.addAttribute("value", PersistenceXmlHelper.getLog(dataMapping));
            }
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(DefaultCharset.name);
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(file), format);
        writer.write(document);
        writer.close();
    }

    private static Set<Class<?>> scanMappedSuperclass(Class<?> clz) throws Exception {
        HashSet set = new HashSet();
        set.add(clz);
        for (Class<?> s = clz.getSuperclass(); null != s; s = s.getSuperclass()) {
            if (null == s.getAnnotation(MappedSuperclass.class)) continue;
            set.add(s);
        }
        return set;
    }

    protected static String getLog(DataMapping dataMapping) throws Exception {
        try {
            return "Tool=" + dataMapping.getToolLevel() + ", Enhance=" + dataMapping.getEnhanceLevel() + ", METADATA=" + dataMapping.getMetaDataLevel() + ", RUNTIME=" + dataMapping.getRuntimeLevel() + ", Query=" + dataMapping.getQueryLevel() + ", DataCache=" + dataMapping.getDataCacheLevel() + ", JDBC=" + dataMapping.getJdbcLevel() + ", SQL=" + dataMapping.getSqlLevel();
        }
        catch (Exception e) {
            throw new Exception("can not get log property.", e);
        }
    }

    public static List<String> listDataClassName() throws Exception {
        ScanResult scanResult = new FastClasspathScanner(new String[]{"com.x"}).scan();
        List list = scanResult.getNamesOfClassesWithAnnotation(ContainerEntity.class);
        return list;
    }

    public static List<String> listStorageClassName() throws Exception {
        ScanResult scanResult = new FastClasspathScanner(new String[]{"com.x"}).scan();
        List list = scanResult.getNamesOfClassesWithAnnotation(Storage.class);
        return list;
    }

    public static List<Class<?>> listClassWithIncludesExcludes(List<String> list, List<String> includes, List<String> excludes) throws Exception {
        list = ListTools.includesExcludesWildcard(list, includes, excludes);
        list = ListTools.trim((List)list, (boolean)true, (boolean)true, (Object[])new String[0]);
        list = list.stream().sorted().collect(Collectors.toList());
        return ClassTools.forName(list);
    }
}

