/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.cloud;

import com.baidu.mapapi.CoordType;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.cloud.CloudPoiInfo;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.util.CoordTrans;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudRgcResult {
    public int status;
    public String message;
    public LatLng location;
    public AddressCompents addressCompents;
    public String formattedAddress;
    public List<PoiInfo> pois;
    public List<CloudPoiInfo> customPois;
    public String customLocationDescription;
    public String recommendedLocationDescription;

    public void parseFromJSON(JSONObject jSONObject) throws JSONException {
        try {
            JSONArray jSONArray;
            Object object;
            JSONObject jSONObject2;
            this.status = jSONObject.optInt("status");
            this.message = jSONObject.optString("message");
            if (this.status == 6 || this.status == 7 || this.status == 8 || this.status == 9) {
                this.status = 1;
            }
            if (this.status != 0) {
                return;
            }
            JSONObject jSONObject3 = jSONObject.optJSONObject("location");
            if (jSONObject3 != null) {
                this.location = new LatLng(jSONObject3.optDouble("lat"), jSONObject3.optDouble("lng"));
                if (SDKInitializer.getCoordType() == CoordType.GCJ02) {
                    this.location = CoordTrans.baiduToGcj(this.location);
                }
            }
            if ((jSONObject2 = jSONObject.optJSONObject("address_component")) != null) {
                this.addressCompents = new AddressCompents();
                this.addressCompents.a(jSONObject2);
            }
            this.formattedAddress = jSONObject.optString("formatted_address");
            JSONArray jSONArray2 = jSONObject.optJSONArray("pois");
            if (jSONArray2 != null) {
                this.pois = new ArrayList<PoiInfo>();
                for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                    JSONObject jSONObject4 = jSONArray2.optJSONObject(i2);
                    if (jSONObject4 == null) continue;
                    object = new PoiInfo();
                    ((PoiInfo)object).parseFromJSON(jSONObject4);
                    this.pois.add((PoiInfo)object);
                }
            }
            if ((jSONArray = jSONObject.optJSONArray("custom_pois")) != null) {
                this.customPois = new ArrayList<CloudPoiInfo>();
                for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                    object = jSONArray.optJSONObject(i3);
                    if (object == null) continue;
                    CloudPoiInfo cloudPoiInfo = new CloudPoiInfo();
                    cloudPoiInfo.b((JSONObject)object);
                    this.customPois.add(cloudPoiInfo);
                }
            }
            this.customLocationDescription = jSONObject.optString("custom_location_description");
            this.recommendedLocationDescription = jSONObject.optString("recommended_location_description");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public class PoiInfo {
        public String name;
        public String uid;
        public String address;
        public String tag;
        public LatLng location;
        public String direction;
        public int distance;

        public void parseFromJSON(JSONObject jSONObject) throws JSONException {
            if (jSONObject != null) {
                this.name = jSONObject.optString("name");
                this.uid = jSONObject.optString("id");
                this.address = jSONObject.optString("address");
                this.tag = jSONObject.optString("tag");
                JSONObject jSONObject2 = jSONObject.optJSONObject("location");
                if (jSONObject2 != null) {
                    this.location = new LatLng(jSONObject2.optDouble("lat"), jSONObject2.optDouble("lng"));
                    if (SDKInitializer.getCoordType() == CoordType.GCJ02) {
                        this.location = CoordTrans.baiduToGcj(this.location);
                    }
                }
                this.direction = jSONObject.optString("direction");
                this.distance = jSONObject.optInt("distance");
            }
        }
    }

    public class AddressCompents {
        public String country;
        public String province;
        public String city;
        public String district;
        public String street;
        public String streetNumber;
        public int adminAreaCode;
        public String countryCode;

        void a(JSONObject jSONObject) throws JSONException {
            if (jSONObject != null) {
                this.country = jSONObject.optString("country");
                this.province = jSONObject.optString("province");
                this.city = jSONObject.optString("city");
                this.district = jSONObject.optString("district");
                this.street = jSONObject.optString("street");
                this.streetNumber = jSONObject.optString("street_number");
                this.adminAreaCode = jSONObject.optInt("admin_area_code");
                this.countryCode = jSONObject.optString("country_code");
            }
        }
    }
}

