/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataServer;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DateTools;
import com.x.server.console.server.Servers;
import java.util.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.store.fs.FileUtils;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.RunScript;
import org.h2.tools.Script;

public class ActionCompactData {
    private static Logger logger = LoggerFactory.getLogger(ActionCompactData.class);
    private Date start;

    private void init() throws Exception {
        this.start = new Date();
    }

    public boolean execute(String password) throws Exception {
        this.init();
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
            logger.print("password not match.", new Object[0]);
            return false;
        }
        DataServer server = Config.currentNode().getData();
        if (null == server) {
            logger.print("not config dataServer.", new Object[0]);
            return false;
        }
        if (!BooleanUtils.isTrue((Boolean)server.getEnable())) {
            logger.print("data server not enable.", new Object[0]);
            return false;
        }
        if (Servers.dataServerIsRunning().booleanValue()) {
            logger.print("data server is running.", new Object[0]);
            return false;
        }
        logger.print("compact data start at {}.", new Object[]{DateTools.format((Date)this.start)});
        String dir = StringUtils.replace((String)Config.base(), (String)"\\", (String)"/") + "/local/repository/data";
        String url = "jdbc:h2:" + dir + "/X";
        String backup = dir + "/backup.sql";
        Script.process((String)url, (String)"sa", (String)Config.token().getPassword(), (String)backup, (String)"", (String)"");
        DeleteDbFiles.execute((String)dir, (String)"X", (boolean)true);
        RunScript.execute((String)url, (String)"sa", (String)Config.token().getPassword(), (String)backup, null, (boolean)false);
        FileUtils.delete((String)backup);
        Date end = new Date();
        System.out.println("compact data completed at " + DateTools.format((Date)end) + ", elapsed:" + (end.getTime() - this.start.getTime()) + "ms.");
        return true;
    }
}

