/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DateTools;
import com.x.base.core.project.tools.JarTools;
import com.x.server.console.action.ActionBase;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;

public class ActionUpdate
extends ActionBase {
    private static Logger logger = LoggerFactory.getLogger(ActionUpdate.class);
    private Date start;
    private static final String LATEST = "latest";

    private void init() throws Exception {
        this.start = new Date();
    }

    public boolean execute(String password, boolean backup, boolean toLatest) {
        try {
            this.init();
            if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
                logger.print("password not mactch.", new Object[0]);
                return false;
            }
            WrapUpdateVersion wrapUpdateVersion = this.get(toLatest);
            if (StringUtils.equals((CharSequence)LATEST, (CharSequence)wrapUpdateVersion.getVersion())) {
                logger.print("already the latest version.", new Object[0]);
                return false;
            }
            if (backup) {
                this.backup();
            }
            File file = this.getPack(wrapUpdateVersion.getUrl());
            this.unzip(file);
            logger.print("update completed in {} seconds, restart server to continue update.", new Object[]{(new Date().getTime() - this.start.getTime()) / 1000L});
            FileUtils.forceDelete((File)file);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void backup() throws Exception {
        File dir = new File(Config.base(), "local/backup");
        FileUtils.forceMkdir((File)dir);
        String tag = DateTools.compact((Date)new Date());
        File dest = new File(dir, tag + ".zip");
        logger.print("backup current version to {}.", new Object[]{dest.getAbsolutePath()});
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(Config.base(), "commons"));
        files.add(new File(Config.base(), "config"));
        files.add(new File(Config.base(), "jvm"));
        files.add(new File(Config.base(), "servers"));
        files.add(new File(Config.base(), "store"));
        files.add(new File(Config.base(), "console.jar"));
        files.add(new File(Config.base(), "index.html"));
        files.add(new File(Config.base(), "version.o2"));
        RegexFileFilter fileFilter = new RegexFileFilter("^(start_|stop_)(aix|windows|linux|macos).(sh|bat)$");
        for (File _f : new File(Config.base()).listFiles((FileFilter)fileFilter)) {
            files.add(_f);
        }
        JarTools.jar(files, (File)dest);
        logger.print("backup current version completed.", new Object[0]);
    }

    private WrapUpdateVersion get(boolean toLatest) throws Exception {
        JsonObject jsonObject;
        String address = "";
        address = toLatest ? Config.collect().url("/o2_collect_assemble/jaxrs/update/latest/version") : Config.collect().url("/o2_collect_assemble/jaxrs/update/next/" + Config.version());
        URL url = new URL(address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setRequestMethod("GET");
        connection.setDoOutput(false);
        connection.setDoInput(true);
        connection.connect();
        String json = "";
        try (InputStream input = connection.getInputStream();){
            json = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        }
        connection.disconnect();
        Gson gson = XGsonBuilder.instance();
        JsonElement jsonElement = (JsonElement)gson.fromJson(json, JsonElement.class);
        if (jsonElement.isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has("data")) {
            return (WrapUpdateVersion)XGsonBuilder.instance().fromJson(jsonObject.get("data"), WrapUpdateVersion.class);
        }
        return null;
    }

    private File getPack(String address) throws Exception {
        logger.print("download update pack form url: {}.", new Object[]{address});
        URL url = new URL(address);
        File file = new File(Config.base(), "local/update.zip");
        if (file.exists() && file.isFile()) {
            FileUtils.forceDelete((File)file);
        }
        FileUtils.copyURLToFile((URL)url, (File)file);
        logger.print("download update pack completed.", new Object[0]);
        return file;
    }

    private void unzip(File file) throws Exception {
        File dir = new File(Config.base(), "local/update");
        FileUtils.forceMkdir((File)dir);
        FileUtils.cleanDirectory((File)dir);
        JarTools.unjar((File)file, (String)"", (File)dir, (boolean)true);
    }

    public static class WrapUpdateVersion {
        private String version;
        private Long size;
        private String url;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }
}

