/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server.center;

import com.x.base.core.project.config.CenterServer;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.x_program_center;
import com.x.server.console.server.JettySeverTools;
import java.io.File;
import org.apache.commons.lang3.BooleanUtils;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.PropertiesConfigurationManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;

public class CenterServerTools
extends JettySeverTools {
    private static Logger logger = LoggerFactory.getLogger(CenterServerTools.class);
    private static int CENTERSERVER_THREAD_POOL_SIZE_MIN = 5;
    private static int CENTERSERVER_THREAD_POOL_SIZE_MAX = 20;

    public static Server start(CenterServer centerServer) throws Exception {
        File commonsDir = new File(Config.base(), "commons");
        File webappsDir = new File(Config.base(), "servers/centerServer/webapps");
        File workDir = new File(Config.base(), "servers/centerServer/work");
        File extDir = new File(Config.base(), "commons/ext");
        File storeDir = new File(Config.base(), "store");
        File jarsDir = new File(Config.base(), "store/jars");
        if (BooleanUtils.isTrue((Boolean)centerServer.getRedeploy())) {
            CenterServerTools.cleanDirectory(webappsDir);
            CenterServerTools.cleanDirectory(workDir);
            CenterServerTools.createDeployDescriptor(x_program_center.class, webappsDir, workDir, storeDir, extDir, jarsDir);
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(CENTERSERVER_THREAD_POOL_SIZE_MIN);
        threadPool.setMaxThreads(CENTERSERVER_THREAD_POOL_SIZE_MAX);
        Server server = new Server((ThreadPool)threadPool);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)server);
        classlist.addAfter(FragmentConfiguration.class.getName(), new String[]{EnvConfiguration.class.getName(), PlusConfiguration.class.getName()});
        classlist.addBefore(JettyWebXmlConfiguration.class.getName(), new String[]{AnnotationConfiguration.class.getName()});
        if (centerServer.getSslEnable().booleanValue()) {
            CenterServerTools.addHttpsConnector(server, centerServer.getPort());
        } else {
            CenterServerTools.addHttpConnector(server, centerServer.getPort());
        }
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DeploymentManager deployer = new DeploymentManager();
        deployer.setContextAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", (Object)"nothing.jar");
        deployer.setContexts(contexts);
        WebAppProvider webAppProvider = new WebAppProvider();
        webAppProvider.setMonitoredDirName(webappsDir.getAbsolutePath());
        webAppProvider.setDefaultsDescriptor(new File(commonsDir, "webdefault_c.xml").getAbsolutePath());
        webAppProvider.setScanInterval(centerServer.getScanInterval().intValue());
        webAppProvider.setExtractWars(true);
        webAppProvider.setConfigurationManager((ConfigurationManager)new PropertiesConfigurationManager());
        deployer.addAppProvider((AppProvider)webAppProvider);
        server.addBean((Object)deployer);
        GzipHandler gzipHandler = new GzipHandler();
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setShowContexts(false);
        defaultHandler.setServeIcon(false);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        gzipHandler.setHandler((Handler)handlers);
        server.setHandler((Handler)gzipHandler);
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        server.start();
        logger.print("center server start completed on port:{}.", new Object[]{centerServer.getPort()});
        return server;
    }
}

