/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import io.flutter.view.ResourceExtractor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResourceUpdater {
    private static final String TAG = "ResourceUpdater";
    private static final int BUFFER_SIZE = 16384;
    private final Context context;
    private DownloadTask downloadTask;
    private final Lock installationLock = new ReentrantLock();

    Lock getInstallationLock() {
        return this.installationLock;
    }

    public File getInstalledPatch() {
        return new File(this.context.getFilesDir().toString() + "/patch.zip");
    }

    File getDownloadedPatch() {
        return new File(this.getInstalledPatch().getPath() + ".install");
    }

    public ResourceUpdater(Context context) {
        this.context = context;
    }

    private String getAPKVersion() {
        try {
            PackageManager packageManager = this.context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.context.getPackageName(), 0);
            return packageInfo == null ? null : Long.toString(ResourceExtractor.getVersionCode(packageInfo));
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private String buildUpdateDownloadURL() {
        URI uri;
        Bundle metaData;
        try {
            metaData = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (metaData == null || metaData.getString("PatchServerURL") == null) {
            return null;
        }
        try {
            uri = new URI(metaData.getString("PatchServerURL") + "/" + this.getAPKVersion() + ".zip");
        }
        catch (URISyntaxException e) {
            Log.w((String)TAG, (String)("Invalid AndroidManifest.xml PatchServerURL: " + e.getMessage()));
            return null;
        }
        return uri.normalize().toString();
    }

    DownloadMode getDownloadMode() {
        Bundle metaData;
        try {
            metaData = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (metaData == null) {
            return DownloadMode.ON_RESTART;
        }
        String patchDownloadMode = metaData.getString("PatchDownloadMode");
        if (patchDownloadMode == null) {
            return DownloadMode.ON_RESTART;
        }
        try {
            return DownloadMode.valueOf(patchDownloadMode);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Invalid PatchDownloadMode " + patchDownloadMode));
            return DownloadMode.ON_RESTART;
        }
    }

    InstallMode getInstallMode() {
        Bundle metaData;
        try {
            metaData = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (metaData == null) {
            return InstallMode.ON_NEXT_RESTART;
        }
        String patchInstallMode = metaData.getString("PatchInstallMode");
        if (patchInstallMode == null) {
            return InstallMode.ON_NEXT_RESTART;
        }
        try {
            return InstallMode.valueOf(patchInstallMode);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Invalid PatchInstallMode " + patchInstallMode));
            return InstallMode.ON_NEXT_RESTART;
        }
    }

    public JSONObject readManifest(File updateFile) {
        if (!updateFile.exists()) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(updateFile);
            ZipEntry entry = zipFile.getEntry("manifest.json");
            if (entry == null) {
                Log.w((String)TAG, (String)("Invalid update file: " + updateFile));
                return null;
            }
            Scanner scanner = new Scanner(zipFile.getInputStream(entry));
            return new JSONObject(scanner.useDelimiter("\\A").next());
        }
        catch (IOException | JSONException e) {
            Log.w((String)TAG, (String)("Invalid update file: " + e));
            return null;
        }
    }

    public boolean validateManifest(JSONObject manifest) {
        String[] checksumFiles;
        if (manifest == null) {
            return false;
        }
        String buildNumber = manifest.optString("buildNumber", null);
        if (buildNumber == null) {
            Log.w((String)TAG, (String)"Invalid update manifest: missing buildNumber");
            return false;
        }
        if (!buildNumber.equals(this.getAPKVersion())) {
            Log.w((String)TAG, (String)("Outdated update file for build " + this.getAPKVersion()));
            return false;
        }
        String baselineChecksum = manifest.optString("baselineChecksum", null);
        if (baselineChecksum == null) {
            Log.w((String)TAG, (String)"Invalid update manifest: missing baselineChecksum");
            return false;
        }
        CRC32 checksum = new CRC32();
        for (String fn : checksumFiles = new String[]{"isolate_snapshot_data", "isolate_snapshot_instr", "flutter_assets/isolate_snapshot_data"}) {
            AssetManager manager = this.context.getResources().getAssets();
            try (InputStream is = manager.open(fn);){
                int count = 0;
                byte[] buffer = new byte[16384];
                while ((count = is.read(buffer, 0, 16384)) != -1) {
                    checksum.update(buffer, 0, count);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!baselineChecksum.equals(String.valueOf(checksum.getValue()))) {
            Log.w((String)TAG, (String)"Mismatched update file for APK");
            return false;
        }
        return true;
    }

    void startUpdateDownloadOnce() {
        if (this.downloadTask != null) {
            return;
        }
        this.downloadTask = new DownloadTask();
        this.downloadTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
    }

    void waitForDownloadCompletion() {
        if (this.downloadTask == null) {
            return;
        }
        try {
            this.downloadTask.get();
            this.downloadTask = null;
        }
        catch (CancellationException e) {
            Log.w((String)TAG, (String)("Download cancelled: " + e.getMessage()));
            return;
        }
        catch (ExecutionException e) {
            Log.w((String)TAG, (String)("Download exception: " + e.getMessage()));
            return;
        }
        catch (InterruptedException e) {
            Log.w((String)TAG, (String)("Download interrupted: " + e.getMessage()));
            return;
        }
    }

    private class DownloadTask
    extends AsyncTask<String, String, Void> {
        private DownloadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doInBackground(String ... unused) {
            try {
                URL unresolvedURL = new URL(ResourceUpdater.this.buildUpdateDownloadURL());
                File localFile = new File(ResourceUpdater.this.getInstalledPatch().getPath() + ".download");
                long startMillis = new Date().getTime();
                Log.i((String)ResourceUpdater.TAG, (String)("Checking for updates at " + unresolvedURL));
                HttpURLConnection connection = (HttpURLConnection)unresolvedURL.openConnection();
                long lastDownloadTime = Math.max(ResourceUpdater.this.getDownloadedPatch().lastModified(), ResourceUpdater.this.getInstalledPatch().lastModified());
                if (lastDownloadTime != 0L) {
                    Log.i((String)ResourceUpdater.TAG, (String)("Active update timestamp " + lastDownloadTime));
                    connection.setIfModifiedSince(lastDownloadTime);
                }
                URL resolvedURL = connection.getURL();
                Log.i((String)ResourceUpdater.TAG, (String)("Resolved update URL " + resolvedURL));
                int responseCode = connection.getResponseCode();
                Log.i((String)ResourceUpdater.TAG, (String)("HTTP response code " + responseCode));
                if (responseCode == 404) {
                    Log.i((String)ResourceUpdater.TAG, (String)"Latest update not found on server");
                    return null;
                }
                if (responseCode == 304) {
                    Log.i((String)ResourceUpdater.TAG, (String)"Already have latest update");
                    return null;
                }
                try (InputStream input = connection.getInputStream();){
                    Log.i((String)ResourceUpdater.TAG, (String)("Downloading update " + unresolvedURL));
                    try (FileOutputStream output = new FileOutputStream(localFile);){
                        int count;
                        byte[] data = new byte[1024];
                        while ((count = input.read(data)) != -1) {
                            ((OutputStream)output).write(data, 0, count);
                        }
                        long totalMillis = new Date().getTime() - startMillis;
                        Log.i((String)ResourceUpdater.TAG, (String)("Update downloaded in " + (double)(totalMillis / 100L) / 10.0 + "s"));
                    }
                }
                ResourceUpdater.this.installationLock.lock();
                try {
                    File updateFile = ResourceUpdater.this.getDownloadedPatch();
                    if (updateFile.exists() && !updateFile.delete()) {
                        Log.w((String)ResourceUpdater.TAG, (String)("Could not delete file " + updateFile));
                        var12_11 = null;
                        return var12_11;
                    }
                    if (!localFile.renameTo(updateFile)) {
                        Log.w((String)ResourceUpdater.TAG, (String)("Could not create file " + updateFile));
                        var12_11 = null;
                        return var12_11;
                    }
                    var12_11 = null;
                    return var12_11;
                }
                finally {
                    ResourceUpdater.this.installationLock.unlock();
                }
            }
            catch (IOException e) {
                Log.w((String)ResourceUpdater.TAG, (String)("Could not download update " + e.getMessage()));
                return null;
            }
        }
    }

    static enum InstallMode {
        ON_NEXT_RESTART,
        IMMEDIATE;

    }

    static enum DownloadMode {
        ON_RESTART,
        ON_RESUME;

    }
}

