/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class HierarchicalLayout<N, E>
extends GraphLayout<N, E> {
    public static final boolean TRACE = false;
    public static final boolean CHECK = false;
    public static final int SWEEP_ITERATIONS = 3;
    public static final int CROSSING_ITERATIONS = 3;
    public static final int DUMMY_WIDTH = 1;
    public static final int X_OFFSET = 20;
    public static final int LAYER_OFFSET = 30;
    private int dummyWidth = 1;
    private int xOffset;
    private int layerOffset;
    private int layerCount;
    private UniversalGraph<N, E> graph;
    private List<LayoutNode> nodes;
    private Collection<N> nodesSubset = null;
    private HashMap<N, LayoutNode> vertexToLayoutNode;
    private Set<E> reversedLinks;
    private List<LayoutNode>[] layers;
    private boolean animate = false;
    private boolean invert = true;
    private Comparator<LayoutNode> crossingNodeComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode layoutNode, LayoutNode layoutNode2) {
            float f = layoutNode.crossingNumber - layoutNode2.crossingNumber;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private final Comparator<LayoutNode> nodePositionComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode layoutNode, LayoutNode layoutNode2) {
            int n = layoutNode.pos - layoutNode2.pos;
            if (n == 0 && (n = layoutNode.toString().compareTo(layoutNode.toString())) == 0) {
                n = System.identityHashCode(layoutNode) - System.identityHashCode(layoutNode2);
            }
            return n;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingDownComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode layoutNode, LayoutNode layoutNode2) {
            if (layoutNode.vertex == null && layoutNode2.vertex == null) {
                int n = layoutNode.toString().compareTo(layoutNode.toString());
                if (n == 0) {
                    n = System.identityHashCode(layoutNode) - System.identityHashCode(layoutNode2);
                }
                return n;
            }
            if (layoutNode.vertex == null) {
                return -1;
            }
            if (layoutNode2.vertex == null) {
                return 1;
            }
            int n = layoutNode.preds.size() - layoutNode2.preds.size();
            if (n == 0 && (n = layoutNode.toString().compareTo(layoutNode.toString())) == 0) {
                n = System.identityHashCode(layoutNode) - System.identityHashCode(layoutNode2);
            }
            return n;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingUpComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode layoutNode, LayoutNode layoutNode2) {
            if (layoutNode.vertex == null && layoutNode2.vertex == null) {
                int n = layoutNode.toString().compareTo(layoutNode.toString());
                if (n == 0) {
                    n = System.identityHashCode(layoutNode) - System.identityHashCode(layoutNode2);
                }
                return n;
            }
            if (layoutNode.vertex == null) {
                return -1;
            }
            if (layoutNode2.vertex == null) {
                return 1;
            }
            int n = layoutNode.succs.size() - layoutNode2.succs.size();
            if (n == 0 && (n = layoutNode.toString().compareTo(layoutNode.toString())) == 0) {
                n = System.identityHashCode(layoutNode) - System.identityHashCode(layoutNode2);
            }
            return n;
        }
    };

    public HierarchicalLayout(GraphScene<N, E> graphScene, boolean bl, boolean bl2, int n, int n2) {
        this.animate = bl;
        this.xOffset = n > 0 ? n : 20;
        this.layerOffset = n2 > 0 ? n2 : 30;
        this.invert = bl2;
    }

    public HierarchicalLayout(GraphScene<N, E> graphScene, boolean bl, boolean bl2) {
        this(graphScene, bl, bl2, 20, 30);
    }

    public HierarchicalLayout(GraphScene<N, E> graphScene, boolean bl) {
        this(graphScene, bl, false);
    }

    public HierarchicalLayout() {
        this(null, false);
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> universalGraph) {
        this.graph = universalGraph;
        this.vertexToLayoutNode = new HashMap();
        this.reversedLinks = new HashSet();
        this.nodes = new ArrayList<LayoutNode>();
        new BuildDatastructure().start();
        new ReverseEdges().start();
        new AssignLayers().start();
        new CreateDummyNodes().start();
        new CrossingReduction().start();
        new AssignXCoordinates().start();
        new AssignYCoordinates().start();
        new WriteResult().start();
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> collection) {
        this.nodesSubset = collection;
        this.performGraphLayout(universalGraph);
    }

    static /* synthetic */ List[] access$1902(HierarchicalLayout hierarchicalLayout, List[] listArray) {
        hierarchicalLayout.layers = listArray;
        return listArray;
    }

    private class WriteResult
    extends AlgorithmPart {
        private int pointCount;

        private WriteResult() {
        }

        @Override
        protected void run() {
            Object object;
            Object object2;
            Object object3;
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            for (Object object4 : HierarchicalLayout.this.graph.getNodes()) {
                Iterator iterator = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(object4);
                assert (!hashMap.containsKey(object4));
                hashMap.put(object4, new Point(((LayoutNode)((Object)iterator)).x + ((LayoutNode)((Object)iterator)).xOffset, ((LayoutNode)((Object)iterator)).y + ((LayoutNode)((Object)iterator)).yOffset));
            }
            for (Object object4 : HierarchicalLayout.this.nodes) {
                for (LayoutEdge object5 : ((LayoutNode)object4).succs) {
                    if (object5.link == null) continue;
                    object3 = object5.link;
                    object2 = new ArrayList();
                    object = new Point(object5.from.x + object5.relativeFrom, object5.from.y + object5.from.height - object5.from.bottomYOffset);
                    ((ArrayList)object2).add((Point)object);
                    LayoutNode layoutNode = object5.to;
                    LayoutNode layoutNode2 = object5.from;
                    LayoutEdge layoutEdge = object5;
                    while (layoutNode.vertex == null && layoutNode.succs.size() != 0) {
                        ((ArrayList)object2).add(new Point(layoutNode.x + layoutNode.width / 2, layoutNode.y));
                        ((ArrayList)object2).add(new Point(layoutNode.x + layoutNode.width / 2, layoutNode.y + layoutNode.height));
                        if (layoutNode.succs.size() == 0) break;
                        assert (layoutNode.succs.size() == 1);
                        layoutEdge = layoutNode.succs.get(0);
                        layoutNode = layoutEdge.to;
                    }
                    object = new Point(layoutNode.x + layoutEdge.relativeTo, layoutNode.y + layoutNode.yOffset);
                    ((ArrayList)object2).add(object);
                    if (HierarchicalLayout.this.reversedLinks.contains(object3)) {
                        Collections.reverse(object2);
                    }
                    hashMap2.put(object5.link, object2);
                    object5.link = null;
                }
            }
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            for (Object k : hashMap.keySet()) {
                object3 = (Point)hashMap.get(k);
                n = Math.min(n, ((Point)object3).x);
                n2 = Math.min(n2, ((Point)object3).y);
            }
            for (Object k : hashMap2.keySet()) {
                object3 = (List)hashMap2.get(k);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Point)object2.next();
                    if (object == null) continue;
                    n = Math.min(n, ((Point)object).x);
                    n2 = Math.min(n2, ((Point)object).y);
                }
            }
            for (Object k : hashMap.keySet()) {
                object3 = (Point)hashMap.get(k);
                ((Point)object3).x -= n;
                ((Point)object3).y -= n2;
                object2 = HierarchicalLayout.this.graph.getScene().findWidget(k);
                if (HierarchicalLayout.this.animate) {
                    HierarchicalLayout.this.graph.getScene().getSceneAnimator().animatePreferredLocation((Widget)object2, (Point)object3);
                    continue;
                }
                ((Widget)object2).setPreferredLocation((Point)object3);
            }
            for (Object k : hashMap2.keySet()) {
                object3 = (List)hashMap2.get(k);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Point)object2.next();
                    if (object == null) continue;
                    ((Point)object).x -= n;
                    ((Point)object).y -= n2;
                }
                if (HierarchicalLayout.this.invert && object3.size() > 3) {
                    int n3 = object3.size();
                    object = new ArrayList(n3);
                    ((ArrayList)object).add(object3.get(0));
                    for (int i = n3 - 2; i > 0; --i) {
                        ((ArrayList)object).add(object3.get(i));
                    }
                    ((ArrayList)object).add(object3.get(n3 - 1));
                    object3 = object;
                }
                if (!((object2 = HierarchicalLayout.this.graph.getScene().findWidget(k)) instanceof ConnectionWidget)) continue;
                object = (ConnectionWidget)object2;
                ((ConnectionWidget)object).setControlPoints((Collection<Point>)object3, true);
            }
            HierarchicalLayout.this.graph.getScene().validate();
            HierarchicalLayout.this.graph.getScene().repaint();
            HierarchicalLayout.this.graph.getScene().revalidate();
        }

        @Override
        protected void printStatistics() {
            System.out.println("Number of nodes: " + HierarchicalLayout.this.nodes.size());
            int n = 0;
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                n += layoutNode.succs.size();
            }
            System.out.println("Number of edges: " + n);
            System.out.println("Number of points: " + this.pointCount);
        }
    }

    private class AssignYCoordinates
    extends AlgorithmPart {
        private AssignYCoordinates() {
        }

        @Override
        protected void run() {
            int n = 0;
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[i]) {
                    n2 = Math.max(n2, layoutNode.height - layoutNode.yOffset - layoutNode.bottomYOffset);
                    n3 = Math.max(n3, layoutNode.yOffset);
                    n4 = Math.max(n4, layoutNode.bottomYOffset);
                }
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[i]) {
                    if (layoutNode.vertex == null) {
                        layoutNode.y = n;
                        layoutNode.height = n2 + n3 + n4;
                        continue;
                    }
                    layoutNode.y = n + n3 + (n2 - (layoutNode.height - layoutNode.yOffset - layoutNode.bottomYOffset)) / 2 - layoutNode.yOffset;
                }
                n += n2 + n3 + n4;
                n += HierarchicalLayout.this.layerOffset;
            }
        }
    }

    private class NodeRow {
        private TreeSet<LayoutNode> treeSet;
        private ArrayList<Integer> space;

        public NodeRow(ArrayList<Integer> arrayList) {
            this.treeSet = new TreeSet(HierarchicalLayout.this.nodePositionComparator);
            this.space = arrayList;
        }

        public int offset(LayoutNode layoutNode, LayoutNode layoutNode2) {
            int n = this.space.get(layoutNode.pos) + layoutNode.width;
            int n2 = this.space.get(layoutNode2.pos);
            return n2 - n;
        }

        public void insert(LayoutNode layoutNode, int n) {
            SortedSet<LayoutNode> sortedSet = this.treeSet.headSet(layoutNode);
            SortedSet<LayoutNode> sortedSet2 = this.treeSet.tailSet(layoutNode);
            LayoutNode layoutNode2 = null;
            int n2 = Integer.MIN_VALUE;
            if (!sortedSet.isEmpty()) {
                layoutNode2 = sortedSet.last();
                n2 = layoutNode2.x + layoutNode2.width + this.offset(layoutNode2, layoutNode);
            }
            LayoutNode layoutNode3 = null;
            int n3 = Integer.MAX_VALUE;
            if (!sortedSet2.isEmpty()) {
                layoutNode3 = sortedSet2.first();
                n3 = layoutNode3.x - this.offset(layoutNode, layoutNode3) - layoutNode.width;
            }
            assert (n2 <= n3);
            if (n >= n2 && n <= n3) {
                layoutNode.x = n;
            } else if (Math.abs((long)n - (long)n2) < Math.abs((long)n - (long)n3)) {
                assert (n2 != Integer.MIN_VALUE);
                layoutNode.x = n2;
            } else {
                assert (n3 != Integer.MAX_VALUE);
                layoutNode.x = n3;
            }
            this.treeSet.add(layoutNode);
        }
    }

    private class AssignXCoordinates
    extends AlgorithmPart {
        private ArrayList<Integer>[] space;
        private ArrayList<LayoutNode>[] downProcessingOrder;
        private ArrayList<LayoutNode>[] upProcessingOrder;

        private AssignXCoordinates() {
        }

        private void initialPositions() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                layoutNode.x = this.space[layoutNode.layer].get(layoutNode.pos);
            }
        }

        @Override
        protected void run() {
            int n;
            this.space = new ArrayList[HierarchicalLayout.this.layers.length];
            this.downProcessingOrder = new ArrayList[HierarchicalLayout.this.layers.length];
            this.upProcessingOrder = new ArrayList[HierarchicalLayout.this.layers.length];
            for (n = 0; n < HierarchicalLayout.this.layers.length; ++n) {
                this.space[n] = new ArrayList();
                this.downProcessingOrder[n] = new ArrayList();
                this.upProcessingOrder[n] = new ArrayList();
                int n2 = 0;
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[n]) {
                    this.space[n].add(n2);
                    n2 += layoutNode.width + HierarchicalLayout.this.xOffset;
                    this.downProcessingOrder[n].add(layoutNode);
                    this.upProcessingOrder[n].add(layoutNode);
                }
                Collections.sort(this.downProcessingOrder[n], HierarchicalLayout.this.nodeProcessingDownComparator);
                Collections.sort(this.upProcessingOrder[n], HierarchicalLayout.this.nodeProcessingUpComparator);
            }
            this.initialPositions();
            for (n = 0; n < 3; ++n) {
                this.sweepDown();
                this.sweepUp();
            }
            this.sweepDown();
            this.sweepUp();
        }

        private int calculateOptimalDown(LayoutNode layoutNode) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (layoutNode.preds.size() == 0) {
                return layoutNode.x;
            }
            for (LayoutEdge layoutEdge : layoutNode.preds) {
                int n = layoutEdge.from.x + layoutEdge.relativeFrom - layoutEdge.relativeTo;
                arrayList.add(n);
            }
            return this.median(arrayList);
        }

        private int calculateOptimalUp(LayoutNode layoutNode) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (layoutNode.succs.size() == 0) {
                return layoutNode.x;
            }
            for (LayoutEdge layoutEdge : layoutNode.succs) {
                int n = layoutEdge.to.x + layoutEdge.relativeTo - layoutEdge.relativeFrom;
                arrayList.add(n);
            }
            return this.median(arrayList);
        }

        private int median(List<Integer> list) {
            Collections.sort(list);
            if (list.size() % 2 == 0) {
                return (list.get(list.size() / 2 - 1) + list.get(list.size() / 2)) / 2;
            }
            return list.get(list.size() / 2);
        }

        private void sweepUp() {
            for (int i = HierarchicalLayout.this.layers.length - 2; i >= 0; --i) {
                NodeRow nodeRow = new NodeRow(this.space[i]);
                for (LayoutNode layoutNode : this.upProcessingOrder[i]) {
                    int n = this.calculateOptimalUp(layoutNode);
                    nodeRow.insert(layoutNode, n);
                }
            }
        }

        private void sweepDown() {
            for (int i = 1; i < HierarchicalLayout.this.layers.length; ++i) {
                NodeRow nodeRow = new NodeRow(this.space[i]);
                for (LayoutNode layoutNode : this.downProcessingOrder[i]) {
                    int n = this.calculateOptimalDown(layoutNode);
                    nodeRow.insert(layoutNode, n);
                }
            }
        }
    }

    private class CrossingReduction
    extends AlgorithmPart {
        private CrossingReduction() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                assert (layoutNode.layer < HierarchicalLayout.this.layerCount);
            }
        }

        @Override
        protected void run() {
            int n;
            HierarchicalLayout.access$1902(HierarchicalLayout.this, new List[HierarchicalLayout.this.layerCount]);
            for (int i = 0; i < HierarchicalLayout.this.layerCount; ++i) {
                ((HierarchicalLayout)HierarchicalLayout.this).layers[i] = new ArrayList();
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object : HierarchicalLayout.this.nodes) {
                if (((LayoutNode)object).layer == 0) {
                    HierarchicalLayout.this.layers[0].add(object);
                    hashSet.add(object);
                    continue;
                }
                if (((LayoutNode)object).preds.size() != 0) continue;
                HierarchicalLayout.this.layers[((LayoutNode)object).layer].add(object);
                hashSet.add(object);
            }
            for (n = 0; n < HierarchicalLayout.this.layers.length - 1; ++n) {
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[n]) {
                    for (LayoutEdge layoutEdge : layoutNode.succs) {
                        if (hashSet.contains(layoutEdge.to)) continue;
                        hashSet.add(layoutEdge.to);
                        HierarchicalLayout.this.layers[n + 1].add(layoutEdge.to);
                    }
                }
            }
            this.updatePositions();
            for (n = 0; n < 3; ++n) {
                this.downSweep();
                this.upSweep();
            }
        }

        private void updatePositions() {
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                int n = 0;
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[i]) {
                    layoutNode.pos = n++;
                }
            }
        }

        private void downSweep() {
            for (int i = 1; i < HierarchicalLayout.this.layerCount; ++i) {
                for (Object object : HierarchicalLayout.this.layers[i]) {
                    float f = 0.0f;
                    for (LayoutEdge layoutEdge : ((LayoutNode)object).preds) {
                        float f2 = layoutEdge.from.pos;
                        if (layoutEdge.from.width != 0 && layoutEdge.relativeFrom != 0) {
                            f2 += (float)layoutEdge.relativeFrom / (float)layoutEdge.from.width;
                        }
                        f += f2;
                    }
                    if (((LayoutNode)object).preds.size() <= 0) continue;
                    ((LayoutNode)object).crossingNumber = f /= (float)((LayoutNode)object).preds.size();
                }
                Collections.sort(HierarchicalLayout.this.layers[i], HierarchicalLayout.this.crossingNodeComparator);
                int n = 0;
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[i]) {
                    layoutNode.pos = n++;
                }
            }
        }

        private void upSweep() {
            for (int i = HierarchicalLayout.this.layerCount - 1; i >= 0; --i) {
                for (Object object : HierarchicalLayout.this.layers[i]) {
                    float f = 0.0f;
                    for (LayoutEdge layoutEdge : ((LayoutNode)object).succs) {
                        float f2 = layoutEdge.to.pos;
                        if (layoutEdge.to.width != 0 && layoutEdge.relativeTo != 0) {
                            f2 += (float)layoutEdge.relativeTo / (float)layoutEdge.to.width;
                        }
                        f += f2;
                    }
                    if (((LayoutNode)object).succs.size() <= 0) continue;
                    ((LayoutNode)object).crossingNumber = f /= (float)((LayoutNode)object).succs.size();
                }
                Collections.sort(HierarchicalLayout.this.layers[i], HierarchicalLayout.this.crossingNodeComparator);
                int n = 0;
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[i]) {
                    layoutNode.pos = n++;
                }
            }
        }

        private int evaluate() {
            return 0;
        }

        @Override
        public void postCheck() {
            HashSet<LayoutNode> hashSet = new HashSet<LayoutNode>();
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                for (LayoutNode layoutNode : HierarchicalLayout.this.layers[i]) {
                    assert (!hashSet.contains(layoutNode));
                    assert (layoutNode.layer == i);
                    hashSet.add(layoutNode);
                }
            }
        }
    }

    private class CreateDummyNodes
    extends AlgorithmPart {
        private int oldNodeCount;

        private CreateDummyNodes() {
        }

        @Override
        protected void preCheck() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                for (LayoutEdge layoutEdge : layoutNode.succs) {
                    assert (layoutEdge.from != null);
                    assert (layoutEdge.from == layoutNode);
                    assert (layoutEdge.from.layer < layoutEdge.to.layer);
                }
                for (LayoutEdge layoutEdge : layoutNode.preds) {
                    assert (layoutEdge.to != null);
                    assert (layoutEdge.to == layoutNode);
                }
            }
        }

        @Override
        protected void run() {
            this.oldNodeCount = HierarchicalLayout.this.nodes.size();
            ArrayList arrayList = new ArrayList(HierarchicalLayout.this.nodes);
            for (LayoutNode layoutNode : arrayList) {
                for (LayoutEdge layoutEdge : layoutNode.succs) {
                    this.processSingleEdge(layoutEdge);
                }
            }
        }

        private void processSingleEdge(LayoutEdge layoutEdge) {
            LayoutNode layoutNode = layoutEdge.from;
            if (layoutEdge.to.layer > layoutNode.layer + 1) {
                LayoutEdge layoutEdge2 = layoutEdge;
                for (int i = layoutNode.layer + 1; i < layoutEdge2.to.layer; ++i) {
                    layoutEdge2 = this.addBetween(layoutEdge2, i);
                }
            }
        }

        private LayoutEdge addBetween(LayoutEdge layoutEdge, int n) {
            LayoutNode layoutNode = new LayoutNode();
            layoutNode.width = HierarchicalLayout.this.dummyWidth;
            layoutNode.height = 0;
            layoutNode.layer = n;
            layoutNode.preds.add(layoutEdge);
            HierarchicalLayout.this.nodes.add(layoutNode);
            LayoutEdge layoutEdge2 = new LayoutEdge();
            layoutNode.succs.add(layoutEdge2);
            layoutEdge2.from = layoutNode;
            layoutEdge2.relativeFrom = layoutNode.width / 2;
            layoutEdge2.to = layoutEdge.to;
            layoutEdge2.relativeTo = layoutEdge.relativeTo;
            layoutEdge.relativeTo = layoutNode.width / 2;
            layoutEdge.to.preds.remove(layoutEdge);
            layoutEdge.to.preds.add(layoutEdge2);
            layoutEdge.to = layoutNode;
            return layoutEdge2;
        }

        @Override
        public void printStatistics() {
            System.out.println("Dummy nodes created: " + (HierarchicalLayout.this.nodes.size() - this.oldNodeCount));
        }

        @Override
        public void postCheck() {
            ArrayList arrayList = new ArrayList(HierarchicalLayout.this.nodes);
            for (Object object : arrayList) {
                for (LayoutEdge layoutEdge : ((LayoutNode)object).succs) {
                    assert (layoutEdge.from.layer == layoutEdge.to.layer - 1);
                }
            }
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                assert (HierarchicalLayout.this.layers[i].size() > 0);
                for (Object object : HierarchicalLayout.this.layers[i]) {
                    assert (((LayoutNode)object).layer == i);
                }
            }
        }
    }

    private class AssignLayers
    extends AlgorithmPart {
        private AssignLayers() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                assert (layoutNode.layer == -1);
            }
        }

        @Override
        protected void run() {
            Object object3;
            Object object2 = new HashSet<LayoutNode>();
            for (Object object3 : HierarchicalLayout.this.nodes) {
                if (((LayoutNode)object3).preds.size() != 0) continue;
                ((HashSet)object2).add(object3);
                ((LayoutNode)object3).layer = 0;
            }
            int n = 1;
            object3 = new HashSet();
            HashSet<LayoutNode> hashSet = new HashSet<LayoutNode>();
            while (!((HashSet)object2).isEmpty()) {
                LayoutNode layoutNode;
                ((HashSet)object3).clear();
                hashSet.clear();
                Object object4 = ((HashSet)object2).iterator();
                while (object4.hasNext()) {
                    layoutNode = object4.next();
                    for (LayoutEdge layoutEdge : layoutNode.succs) {
                        LayoutNode layoutNode2 = layoutEdge.to;
                        if (((HashSet)object3).contains(layoutNode2) || hashSet.contains(layoutNode2)) continue;
                        boolean bl = true;
                        for (LayoutEdge layoutEdge2 : layoutNode2.preds) {
                            LayoutNode layoutNode3 = layoutEdge2.from;
                            if (layoutNode3.layer != -1) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            ((HashSet)object3).add(layoutNode2);
                            continue;
                        }
                        hashSet.add(layoutNode2);
                    }
                }
                object4 = ((HashSet)object3).iterator();
                while (object4.hasNext()) {
                    layoutNode = object4.next();
                    layoutNode.layer = n;
                }
                object4 = object2;
                object2 = object3;
                object3 = object4;
                ++n;
            }
            this.optimize((HashSet<LayoutNode>)object2);
            HierarchicalLayout.this.layerCount = n - 1;
        }

        public void optimize(HashSet<LayoutNode> hashSet) {
            for (LayoutNode layoutNode : hashSet) {
                if (layoutNode.preds.size() != 0 || layoutNode.succs.size() <= 0) continue;
                int n = layoutNode.succs.get((int)0).to.layer;
                for (LayoutEdge layoutEdge : layoutNode.succs) {
                    n = Math.min(n, layoutEdge.to.layer);
                }
                layoutNode.layer = n - 1;
            }
        }

        @Override
        public void printStatistics() {
        }

        @Override
        public void postCheck() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                assert (layoutNode.layer >= 0);
                assert (layoutNode.layer < HierarchicalLayout.this.layerCount);
                for (LayoutEdge layoutEdge : layoutNode.succs) {
                    assert (layoutEdge.from.layer < layoutEdge.to.layer);
                }
            }
        }
    }

    private class ReverseEdges
    extends AlgorithmPart {
        private HashSet<LayoutNode> visited;
        private HashSet<LayoutNode> active;

        private ReverseEdges() {
        }

        @Override
        protected void run() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                ArrayList<LayoutEdge> arrayList = new ArrayList<LayoutEdge>(layoutNode.succs);
                for (LayoutEdge layoutEdge : arrayList) {
                    assert (layoutEdge.from == layoutNode);
                    if (layoutEdge.to != layoutNode) continue;
                    layoutNode.succs.remove(layoutEdge);
                    layoutNode.preds.remove(layoutEdge);
                }
            }
            this.visited = new HashSet();
            this.active = new HashSet();
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                this.DFS(layoutNode);
            }
        }

        private void DFS(LayoutNode layoutNode) {
            if (this.visited.contains(layoutNode)) {
                return;
            }
            Stack<LayoutNode> stack = new Stack<LayoutNode>();
            stack.push(layoutNode);
            while (!stack.empty()) {
                LayoutNode layoutNode2 = (LayoutNode)stack.pop();
                if (this.visited.contains(layoutNode2)) {
                    this.active.remove(layoutNode2);
                    continue;
                }
                stack.push(layoutNode2);
                this.visited.add(layoutNode2);
                this.active.add(layoutNode2);
                ArrayList<LayoutEdge> arrayList = new ArrayList<LayoutEdge>(layoutNode2.succs);
                for (LayoutEdge layoutEdge : arrayList) {
                    if (this.active.contains(layoutEdge.to)) {
                        assert (this.visited.contains(layoutEdge.to));
                        this.reverseEdge(layoutEdge);
                        continue;
                    }
                    if (this.visited.contains(layoutEdge.to)) continue;
                    stack.push(layoutEdge.to);
                }
            }
        }

        private void reverseAllInputs(LayoutNode layoutNode) {
            for (LayoutEdge layoutEdge : layoutNode.preds) {
                assert (!HierarchicalLayout.this.reversedLinks.contains(layoutEdge.link));
                HierarchicalLayout.this.reversedLinks.add(layoutEdge.link);
                layoutNode.succs.add(layoutEdge);
                layoutEdge.from.preds.add(layoutEdge);
                layoutEdge.from.succs.remove(layoutEdge);
                int n = layoutEdge.relativeFrom;
                int n2 = layoutEdge.relativeTo;
                layoutEdge.to = layoutEdge.from;
                layoutEdge.from = layoutNode;
                layoutEdge.relativeFrom = n2;
                layoutEdge.relativeTo = n;
            }
            layoutNode.preds.clear();
        }

        private void reverseEdge(LayoutEdge layoutEdge) {
            assert (!HierarchicalLayout.this.reversedLinks.contains(layoutEdge.link));
            HierarchicalLayout.this.reversedLinks.add(layoutEdge.link);
            LayoutNode layoutNode = layoutEdge.from;
            LayoutNode layoutNode2 = layoutEdge.to;
            int n = layoutEdge.relativeFrom;
            int n2 = layoutEdge.relativeTo;
            layoutEdge.from = layoutNode2;
            layoutEdge.to = layoutNode;
            layoutEdge.relativeFrom = n2;
            layoutEdge.relativeTo = n;
            layoutNode.succs.remove(layoutEdge);
            layoutNode.preds.add(layoutEdge);
            layoutNode2.preds.remove(layoutEdge);
            layoutNode2.succs.add(layoutEdge);
        }

        @Override
        public void postCheck() {
            for (LayoutNode layoutNode : HierarchicalLayout.this.nodes) {
                LinkedList<LayoutNode> linkedList = new LinkedList<LayoutNode>();
                for (LayoutEdge layoutEdge : layoutNode.succs) {
                    LayoutNode layoutNode2 = layoutEdge.to;
                    linkedList.add(layoutNode2);
                    this.visited.add(layoutNode2);
                }
                HashSet hashSet = new HashSet();
                while (!linkedList.isEmpty()) {
                    LayoutNode layoutNode3 = (LayoutNode)linkedList.remove();
                    for (LayoutEdge layoutEdge : layoutNode3.succs) {
                        assert (layoutEdge.to != layoutNode);
                        if (hashSet.contains(layoutEdge.to)) continue;
                        linkedList.add(layoutEdge.to);
                        hashSet.add(layoutEdge.to);
                    }
                }
            }
        }
    }

    private class BuildDatastructure
    extends AlgorithmPart {
        private BuildDatastructure() {
        }

        @Override
        protected void run() {
            Cloneable cloneable;
            Object object;
            Object object2;
            LayoutNode layoutNode;
            Object object32;
            Collection collection = HierarchicalLayout.this.nodesSubset == null ? HierarchicalLayout.this.graph.getNodes() : HierarchicalLayout.this.nodesSubset;
            for (Object object32 : collection) {
                layoutNode = new LayoutNode();
                object2 = HierarchicalLayout.this.graph.getScene().findWidget(object32);
                assert (object2 != null);
                object = ((Widget)object2).getBounds();
                if (object == null) {
                    object = ((Widget)object2).getPreferredBounds();
                }
                cloneable = ((Rectangle)object).getSize();
                layoutNode.width = (int)((Dimension)cloneable).getWidth();
                layoutNode.height = (int)((Dimension)cloneable).getHeight();
                layoutNode.vertex = object32;
                HierarchicalLayout.this.nodes.add(layoutNode);
                HierarchicalLayout.this.vertexToLayoutNode.put(object32, layoutNode);
            }
            Collection collection2 = HierarchicalLayout.this.graph.getEdges();
            object32 = collection2.iterator();
            while (object32.hasNext()) {
                layoutNode = object32.next();
                object2 = new LayoutEdge();
                assert (HierarchicalLayout.this.vertexToLayoutNode.containsKey(HierarchicalLayout.this.graph.getEdgeSource(layoutNode)));
                assert (HierarchicalLayout.this.vertexToLayoutNode.containsKey(HierarchicalLayout.this.graph.getEdgeTarget(layoutNode)));
                if (HierarchicalLayout.this.invert) {
                    ((LayoutEdge)object2).to = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeSource(layoutNode));
                    ((LayoutEdge)object2).from = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeTarget(layoutNode));
                } else {
                    ((LayoutEdge)object2).from = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeSource(layoutNode));
                    ((LayoutEdge)object2).to = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeTarget(layoutNode));
                }
                object = HierarchicalLayout.this.graph.getScene().findWidget(HierarchicalLayout.this.graph.getEdgeSource(layoutNode));
                assert (object != null);
                cloneable = ((Widget)object).getBounds();
                if (cloneable == null) {
                    cloneable = ((Widget)object).getPreferredBounds();
                }
                Dimension dimension = ((Rectangle)cloneable).getSize();
                ((LayoutEdge)object2).relativeFrom = dimension.width / 2;
                object = HierarchicalLayout.this.graph.getScene().findWidget(HierarchicalLayout.this.graph.getEdgeTarget(layoutNode));
                assert (object != null);
                cloneable = ((Widget)object).getBounds();
                if (cloneable == null) {
                    cloneable = ((Widget)object).getPreferredBounds();
                }
                dimension = ((Rectangle)cloneable).getSize();
                ((LayoutEdge)object2).relativeTo = dimension.width / 2;
                ((LayoutEdge)object2).link = layoutNode;
                ((LayoutEdge)object2).from.succs.add((LayoutEdge)object2);
                ((LayoutEdge)object2).to.preds.add((LayoutEdge)object2);
            }
        }

        @Override
        public void postCheck() {
            assert (HierarchicalLayout.this.vertexToLayoutNode.keySet().size() == HierarchicalLayout.this.nodes.size());
            assert (HierarchicalLayout.this.nodes.size() == HierarchicalLayout.this.graph.getNodes().size());
            for (Object n : HierarchicalLayout.this.graph.getNodes()) {
                LayoutNode layoutNode = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(n);
                assert (layoutNode != null);
                for (LayoutEdge layoutEdge : layoutNode.succs) {
                    assert (layoutEdge.from == layoutNode);
                }
                for (LayoutEdge layoutEdge : layoutNode.preds) {
                    assert (layoutEdge.to == layoutNode);
                }
            }
        }
    }

    private abstract class AlgorithmPart {
        private AlgorithmPart() {
        }

        public void start() {
            long l = 0L;
            this.run();
        }

        protected abstract void run();

        protected void printStatistics() {
        }

        protected void postCheck() {
        }

        protected void preCheck() {
        }
    }

    private class LayoutEdge {
        public LayoutNode from;
        public LayoutNode to;
        public int relativeFrom;
        public int relativeTo;
        public E link;

        private LayoutEdge() {
        }
    }

    private class LayoutNode {
        public int x;
        public int y;
        public int width;
        public int height;
        public int layer = -1;
        public int xOffset;
        public int yOffset;
        public int bottomYOffset;
        public N vertex;
        public List<LayoutEdge> preds = new ArrayList<LayoutEdge>();
        public List<LayoutEdge> succs = new ArrayList<LayoutEdge>();
        public int pos = -1;
        public float crossingNumber;

        private LayoutNode() {
        }

        public String toString() {
            return "Node " + this.vertex;
        }
    }
}

