/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import android.content.res.AssetManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartMessenger;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.view.FlutterCallbackInformation;
import java.nio.ByteBuffer;

public class DartExecutor
implements BinaryMessenger {
    private static final String TAG = "DartExecutor";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final DartMessenger messenger;
    private boolean isApplicationRunning = false;

    public DartExecutor(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.messenger = new DartMessenger(flutterJNI);
    }

    public void onAttachedToJNI() {
        this.flutterJNI.setPlatformMessageHandler(this.messenger);
    }

    public void onDetachedFromJNI() {
        this.flutterJNI.setPlatformMessageHandler(null);
    }

    public boolean isExecutingDart() {
        return this.isApplicationRunning;
    }

    public void executeDartEntrypoint(@NonNull DartEntrypoint dartEntrypoint) {
        if (this.isApplicationRunning) {
            Log.w((String)TAG, (String)"Attempted to run a DartExecutor that is already running.");
            return;
        }
        this.flutterJNI.runBundleAndSnapshotFromLibrary(new String[]{dartEntrypoint.pathToPrimaryBundle, dartEntrypoint.pathToFallbackBundle}, dartEntrypoint.dartEntrypointFunctionName, null, dartEntrypoint.androidAssetManager);
        this.isApplicationRunning = true;
    }

    public void executeDartCallback(@NonNull DartCallback dartCallback) {
        if (this.isApplicationRunning) {
            Log.w((String)TAG, (String)"Attempted to run a DartExecutor that is already running.");
            return;
        }
        this.flutterJNI.runBundleAndSnapshotFromLibrary(new String[]{dartCallback.pathToPrimaryBundle, dartCallback.pathToFallbackBundle}, dartCallback.callbackHandle.callbackName, dartCallback.callbackHandle.callbackLibraryPath, dartCallback.androidAssetManager);
        this.isApplicationRunning = true;
    }

    @Override
    public void send(@NonNull String channel, @Nullable ByteBuffer message) {
        this.messenger.send(channel, message, null);
    }

    @Override
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        this.messenger.send(channel, message, callback);
    }

    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        this.messenger.setMessageHandler(channel, handler);
    }

    public static class DartCallback {
        public final AssetManager androidAssetManager;
        public final String pathToPrimaryBundle;
        public final String pathToFallbackBundle;
        public final FlutterCallbackInformation callbackHandle;

        public DartCallback(@NonNull AssetManager androidAssetManager, @NonNull String pathToPrimaryBundle, @NonNull FlutterCallbackInformation callbackHandle) {
            this(androidAssetManager, pathToPrimaryBundle, null, callbackHandle);
        }

        public DartCallback(@NonNull AssetManager androidAssetManager, @NonNull String pathToPrimaryBundle, @Nullable String pathToFallbackBundle, @NonNull FlutterCallbackInformation callbackHandle) {
            this.androidAssetManager = androidAssetManager;
            this.pathToPrimaryBundle = pathToPrimaryBundle;
            this.pathToFallbackBundle = pathToFallbackBundle;
            this.callbackHandle = callbackHandle;
        }
    }

    public static class DartEntrypoint {
        @NonNull
        public final AssetManager androidAssetManager;
        @NonNull
        public final String pathToPrimaryBundle;
        @Nullable
        public final String pathToFallbackBundle;
        @NonNull
        public final String dartEntrypointFunctionName;

        public DartEntrypoint(@NonNull AssetManager androidAssetManager, @NonNull String pathToBundle, @NonNull String dartEntrypointFunctionName) {
            this(androidAssetManager, pathToBundle, null, dartEntrypointFunctionName);
        }

        public DartEntrypoint(@NonNull AssetManager androidAssetManager, @NonNull String pathToPrimaryBundle, @Nullable String pathToFallbackBundle, @NonNull String dartEntrypointFunctionName) {
            this.androidAssetManager = androidAssetManager;
            this.pathToPrimaryBundle = pathToPrimaryBundle;
            this.pathToFallbackBundle = pathToFallbackBundle;
            this.dartEntrypointFunctionName = dartEntrypointFunctionName;
        }
    }
}

