/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderComparator;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Soundex;
import org.junit.Assert;
import org.junit.Test;

public class StringEncoderComparatorTest {
    @Test
    public void testComparatorWithSoundex() throws Exception {
        StringEncoderComparator sCompare = new StringEncoderComparator((StringEncoder)new Soundex());
        Assert.assertTrue((String)"O'Brien and O'Brian didn't come out with the same Soundex, something must be wrong here", (0 == sCompare.compare((Object)"O'Brien", (Object)"O'Brian") ? 1 : 0) != 0);
    }

    @Test
    public void testComparatorWithDoubleMetaphone() throws Exception {
        StringEncoderComparator sCompare = new StringEncoderComparator((StringEncoder)new DoubleMetaphone());
        String[] testArray = new String[]{"Jordan", "Sosa", "Prior", "Pryor"};
        List<String> testList = Arrays.asList(testArray);
        String[] controlArray = new String[]{"Jordan", "Prior", "Pryor", "Sosa"};
        Collections.sort(testList, sCompare);
        String[] resultArray = testList.toArray(new String[0]);
        for (int i = 0; i < resultArray.length; ++i) {
            Assert.assertEquals((String)("Result Array not Equal to Control Array at index: " + i), (Object)controlArray[i], (Object)resultArray[i]);
        }
    }

    @Test
    public void testComparatorWithDoubleMetaphoneAndInvalidInput() throws Exception {
        StringEncoderComparator sCompare = new StringEncoderComparator((StringEncoder)new DoubleMetaphone());
        int compare = sCompare.compare((Object)new Double(3.0), (Object)3L);
        Assert.assertEquals((String)"Trying to compare objects that make no sense to the underlying encoder should return a zero compare code", (long)0L, (long)compare);
    }
}

