/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Image;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDGlyphSetWidget;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class VMDPinWidget
extends Widget {
    private VMDColorScheme scheme;
    private LabelWidget nameWidget;
    private VMDGlyphSetWidget glyphsWidget;
    private VMDNodeAnchor anchor;

    public VMDPinWidget(Scene scene) {
        this(scene, VMDFactory.getOriginalScheme());
    }

    public VMDPinWidget(Scene scene, VMDColorScheme vMDColorScheme) {
        super(scene);
        assert (vMDColorScheme != null);
        this.scheme = vMDColorScheme;
        this.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.CENTER, 8));
        this.nameWidget = new LabelWidget(scene);
        this.addChild(this.nameWidget);
        this.glyphsWidget = new VMDGlyphSetWidget(scene);
        this.addChild(this.glyphsWidget);
        vMDColorScheme.installUI(this);
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    @Override
    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        this.scheme.updateUI(this, objectState, objectState2);
    }

    public Widget getPinNameWidget() {
        return this.nameWidget;
    }

    public void setPinName(String string) {
        this.nameWidget.setLabel(string);
    }

    public String getPinName() {
        return this.nameWidget.getLabel();
    }

    public void setGlyphs(List<Image> list) {
        this.glyphsWidget.setGlyphs(list);
    }

    public void setProperties(String string, List<Image> list) {
        this.setPinName(string);
        this.glyphsWidget.setGlyphs(list);
    }

    public Anchor createAnchor() {
        if (this.anchor == null) {
            this.anchor = new VMDNodeAnchor(this, false);
        }
        return this.anchor;
    }
}

