/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.Rule;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RuleTest {
    private Rule.Phoneme[][] makePhonemes() {
        String[][] words = new String[][]{{"rinD", "rinDlt", "rina", "rinalt", "rino", "rinolt", "rinu", "rinult"}, {"dortlaj", "dortlej", "ortlaj", "ortlej", "ortlej-dortlaj"}};
        Rule.Phoneme[][] phonemes = new Rule.Phoneme[words.length][];
        for (int i = 0; i < words.length; ++i) {
            String[] words_i = words[i];
            phonemes[i] = new Rule.Phoneme[words_i.length];
            Rule.Phoneme[] phonemes_i = phonemes[i];
            for (int j = 0; j < words_i.length; ++j) {
                phonemes_i[j] = new Rule.Phoneme((CharSequence)words_i[j], Languages.NO_LANGUAGES);
            }
        }
        return phonemes;
    }

    @Test
    public void testPhonemeComparedToLaterIsNegative() {
        for (Rule.Phoneme[] phs : this.makePhonemes()) {
            for (int i = 0; i < phs.length; ++i) {
                for (int j = i + 1; j < phs.length; ++j) {
                    int c = Rule.Phoneme.COMPARATOR.compare(phs[i], phs[j]);
                    Assert.assertThat((String)("Comparing " + phs[i].getPhonemeText() + " to " + phs[j].getPhonemeText() + " should be negative"), (Object)c, (Matcher)new NegativeIntegerBaseMatcher());
                }
            }
        }
    }

    @Test
    public void testPhonemeComparedToSelfIsZero() {
        Rule.Phoneme[][] arr$ = this.makePhonemes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Rule.Phoneme[] phs;
            for (Rule.Phoneme ph : phs = arr$[i$]) {
                Assert.assertEquals((String)("Phoneme compared to itself should be zero: " + ph.getPhonemeText()), (long)0L, (long)Rule.Phoneme.COMPARATOR.compare(ph, ph));
            }
        }
    }

    @Test
    public void testSubSequenceWorks() {
        Rule.Phoneme a = new Rule.Phoneme((CharSequence)"a", null);
        Rule.Phoneme b = new Rule.Phoneme((CharSequence)"b", null);
        Rule.Phoneme cd = new Rule.Phoneme((CharSequence)"cd", null);
        Rule.Phoneme ef = new Rule.Phoneme((CharSequence)"ef", null);
        Rule.Phoneme ghi = new Rule.Phoneme((CharSequence)"ghi", null);
        Rule.Phoneme jkl = new Rule.Phoneme((CharSequence)"jkl", null);
        Assert.assertEquals((long)97L, (long)a.getPhonemeText().charAt(0));
        Assert.assertEquals((long)98L, (long)b.getPhonemeText().charAt(0));
        Assert.assertEquals((long)99L, (long)cd.getPhonemeText().charAt(0));
        Assert.assertEquals((long)100L, (long)cd.getPhonemeText().charAt(1));
        Assert.assertEquals((long)101L, (long)ef.getPhonemeText().charAt(0));
        Assert.assertEquals((long)102L, (long)ef.getPhonemeText().charAt(1));
        Assert.assertEquals((long)103L, (long)ghi.getPhonemeText().charAt(0));
        Assert.assertEquals((long)104L, (long)ghi.getPhonemeText().charAt(1));
        Assert.assertEquals((long)105L, (long)ghi.getPhonemeText().charAt(2));
        Assert.assertEquals((long)106L, (long)jkl.getPhonemeText().charAt(0));
        Assert.assertEquals((long)107L, (long)jkl.getPhonemeText().charAt(1));
        Assert.assertEquals((long)108L, (long)jkl.getPhonemeText().charAt(2));
        Rule.Phoneme a_b = a.append(b.getPhonemeText());
        Assert.assertEquals((long)97L, (long)a_b.getPhonemeText().charAt(0));
        Assert.assertEquals((long)98L, (long)a_b.getPhonemeText().charAt(1));
        Assert.assertEquals((Object)"ab", (Object)a_b.getPhonemeText().subSequence(0, 2).toString());
        Assert.assertEquals((Object)"a", (Object)a_b.getPhonemeText().subSequence(0, 1).toString());
        Assert.assertEquals((Object)"b", (Object)a_b.getPhonemeText().subSequence(1, 2).toString());
        Rule.Phoneme cd_ef = cd.append(ef.getPhonemeText());
        Assert.assertEquals((long)99L, (long)cd_ef.getPhonemeText().charAt(0));
        Assert.assertEquals((long)100L, (long)cd_ef.getPhonemeText().charAt(1));
        Assert.assertEquals((long)101L, (long)cd_ef.getPhonemeText().charAt(2));
        Assert.assertEquals((long)102L, (long)cd_ef.getPhonemeText().charAt(3));
        Assert.assertEquals((Object)"c", (Object)cd_ef.getPhonemeText().subSequence(0, 1).toString());
        Assert.assertEquals((Object)"d", (Object)cd_ef.getPhonemeText().subSequence(1, 2).toString());
        Assert.assertEquals((Object)"e", (Object)cd_ef.getPhonemeText().subSequence(2, 3).toString());
        Assert.assertEquals((Object)"f", (Object)cd_ef.getPhonemeText().subSequence(3, 4).toString());
        Assert.assertEquals((Object)"cd", (Object)cd_ef.getPhonemeText().subSequence(0, 2).toString());
        Assert.assertEquals((Object)"de", (Object)cd_ef.getPhonemeText().subSequence(1, 3).toString());
        Assert.assertEquals((Object)"ef", (Object)cd_ef.getPhonemeText().subSequence(2, 4).toString());
        Assert.assertEquals((Object)"cde", (Object)cd_ef.getPhonemeText().subSequence(0, 3).toString());
        Assert.assertEquals((Object)"def", (Object)cd_ef.getPhonemeText().subSequence(1, 4).toString());
        Assert.assertEquals((Object)"cdef", (Object)cd_ef.getPhonemeText().subSequence(0, 4).toString());
        Rule.Phoneme a_b_cd = a.append(b.getPhonemeText()).append(cd.getPhonemeText());
        Assert.assertEquals((long)97L, (long)a_b_cd.getPhonemeText().charAt(0));
        Assert.assertEquals((long)98L, (long)a_b_cd.getPhonemeText().charAt(1));
        Assert.assertEquals((long)99L, (long)a_b_cd.getPhonemeText().charAt(2));
        Assert.assertEquals((long)100L, (long)a_b_cd.getPhonemeText().charAt(3));
        Assert.assertEquals((Object)"a", (Object)a_b_cd.getPhonemeText().subSequence(0, 1).toString());
        Assert.assertEquals((Object)"b", (Object)a_b_cd.getPhonemeText().subSequence(1, 2).toString());
        Assert.assertEquals((Object)"c", (Object)a_b_cd.getPhonemeText().subSequence(2, 3).toString());
        Assert.assertEquals((Object)"d", (Object)a_b_cd.getPhonemeText().subSequence(3, 4).toString());
        Assert.assertEquals((Object)"ab", (Object)a_b_cd.getPhonemeText().subSequence(0, 2).toString());
        Assert.assertEquals((Object)"bc", (Object)a_b_cd.getPhonemeText().subSequence(1, 3).toString());
        Assert.assertEquals((Object)"cd", (Object)a_b_cd.getPhonemeText().subSequence(2, 4).toString());
        Assert.assertEquals((Object)"abc", (Object)a_b_cd.getPhonemeText().subSequence(0, 3).toString());
        Assert.assertEquals((Object)"bcd", (Object)a_b_cd.getPhonemeText().subSequence(1, 4).toString());
        Assert.assertEquals((Object)"abcd", (Object)a_b_cd.getPhonemeText().subSequence(0, 4).toString());
    }

    private static class NegativeIntegerBaseMatcher
    extends BaseMatcher<Integer> {
        private NegativeIntegerBaseMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("value should be negative");
        }

        public boolean matches(Object item) {
            return (Integer)item < 0;
        }
    }
}

