/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.BDNotifyListener;
import com.baidu.location.Jni;
import com.baidu.location.LocationClientOption;
import com.baidu.location.a.b;
import com.baidu.location.a.i;
import com.baidu.location.c;
import com.baidu.location.f;
import java.util.ArrayList;

public final class LocationClient
implements b.b {
    private static final String mTAG = "baidu_location_Client";
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final int MSG_SET_OPT = 3;
    private static final int MSG_REQ_LOC = 4;
    private static final int MSG_REG_LISTENER = 5;
    private static final int MSG_UNREG_LISTENER = 6;
    private static final int MSG_REQ_POI = 7;
    private static final int MSG_REG_NOTIFY_LISTENER = 8;
    private static final int MSG_RIGSTER_NOTIFY = 9;
    private static final int MSG_REMOVE_NOTIFY = 10;
    private static final int MSG_REQ_NOTIFY_LOC = 11;
    private static final int MSG_REQ_OFFLINE_LOC = 12;
    private static final int MIN_REQUEST_SPAN = 1000;
    private long mLastRequestTime = 0L;
    private String mPackName = null;
    private LocationClientOption mOption = new LocationClientOption();
    private boolean mIsStarted = false;
    private Context mContext = null;
    private Messenger mServer = null;
    private HandlerThread mThread;
    private a mHandler;
    private final Messenger mMessenger;
    private ArrayList<BDLocationListener> mLocationListeners = null;
    private BDLocation mLastLocation = null;
    private boolean isWaitingForLocation = false;
    private boolean isWaitingLocTag = false;
    private boolean isScheduled = false;
    private b mScheduledRequest = null;
    private boolean mGpsStatus = false;
    private final Object mLock = new Object();
    private long lastReceiveGpsTime = 0L;
    private long lastReceiveLocationTime = 0L;
    private com.baidu.location.d.a mNotifyCache = null;
    private BDLocationListener NotifyLocationListenner = null;
    private String serviceName = null;
    private String mKey;
    private boolean inDoorState = false;
    private boolean isStop = true;
    private Boolean mConfig_map = false;
    private Boolean mConfig_preimport = false;
    private Boolean firstConnected = true;
    private boolean mDebugByDev;
    private com.baidu.location.a.b mloc = null;
    private boolean clientFirst = false;
    private boolean serverFirst = false;
    public static final int CONNECT_HOT_SPOT_TRUE = 1;
    public static final int CONNECT_HOT_SPOT_FALSE = 0;
    public static final int CONNECT_HOT_SPOT_UNKNOWN = -1;
    private ServiceConnection mConnection = new com.baidu.location.b(this);

    public LocationClient(Context context) {
        this.mContext = context;
        this.mOption = new LocationClientOption();
        this.mThread = new HandlerThread("LocationClient");
        this.mThread.start();
        this.mHandler = new a(this.mThread.getLooper());
        this.mMessenger = new Messenger((Handler)this.mHandler);
    }

    public LocationClient(Context context, LocationClientOption locationClientOption) {
        this.mContext = context;
        this.mOption = locationClientOption;
        this.mThread = new HandlerThread("LocationClient");
        this.mThread.start();
        this.mHandler = new a(this.mThread.getLooper());
        this.mMessenger = new Messenger((Handler)this.mHandler);
    }

    public LocationClientOption getLocOption() {
        return this.mOption;
    }

    public void setLocOption(LocationClientOption locationClientOption) {
        if (locationClientOption == null) {
            locationClientOption = new LocationClientOption();
        }
        if (locationClientOption.getAutoNotifyMaxInterval() > 0) {
            locationClientOption.setScanSpan(0);
            locationClientOption.setLocationNotify(true);
        }
        Message message = this.mHandler.obtainMessage(3);
        message.obj = locationClientOption;
        message.sendToTarget();
    }

    public boolean updateLocation(Location location) {
        if (this.mServer == null || this.mMessenger == null || location == null) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)57);
            message.obj = location;
            this.mServer.send(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void requestNotifyLocation() {
        Message message = this.mHandler.obtainMessage(11);
        message.sendToTarget();
    }

    public int requestOfflineLocation() {
        if (this.mServer == null || this.mMessenger == null) {
            return 1;
        }
        if (this.mLocationListeners == null || this.mLocationListeners.size() < 1) {
            return 2;
        }
        Message message = this.mHandler.obtainMessage(12);
        message.sendToTarget();
        return 0;
    }

    private void onRequestOffLineLocation() {
        Message message = Message.obtain(null, (int)28);
        try {
            message.replyTo = this.mMessenger;
            this.mServer.send(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int requestLocation() {
        if (this.mServer == null || this.mMessenger == null) {
            return 1;
        }
        if (this.mLocationListeners == null || this.mLocationListeners.size() < 1) {
            return 2;
        }
        if (System.currentTimeMillis() - this.mLastRequestTime < 1000L) {
            return 6;
        }
        this.isWaitingLocTag = true;
        Message message = this.mHandler.obtainMessage(4);
        message.arg1 = 0;
        message.sendToTarget();
        return 0;
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    public BDLocation getLastKnownLocation() {
        return this.mLastLocation;
    }

    public String getVersion() {
        return "7.1.1";
    }

    public void start() {
        this.isStop = false;
        Message message = this.mHandler.obtainMessage(1);
        message.sendToTarget();
    }

    private void onStart() {
        if (this.mIsStarted) {
            return;
        }
        if (this.firstConnected.booleanValue()) {
            new c(this).start();
            this.firstConnected = false;
        }
        this.mPackName = this.mContext.getPackageName();
        this.serviceName = this.mPackName + "_bdls_v2.9";
        Intent intent = new Intent(this.mContext, f.class);
        try {
            intent.putExtra("debug_dev", this.mDebugByDev);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mOption == null) {
            this.mOption = new LocationClientOption();
        }
        intent.putExtra("cache_exception", this.mOption.isIgnoreCacheException);
        intent.putExtra("kill_process", this.mOption.isIgnoreKillProcess);
        try {
            this.mContext.bindService(intent, this.mConnection, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mIsStarted = false;
        }
    }

    public void stop() {
        this.isStop = true;
        Message message = this.mHandler.obtainMessage(2);
        message.sendToTarget();
        this.mloc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStop() {
        if (!this.mIsStarted || this.mServer == null) {
            return;
        }
        Message message = Message.obtain(null, (int)12);
        message.replyTo = this.mMessenger;
        try {
            this.mServer.send(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.mContext.unbindService(this.mConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.isScheduled) {
                    this.mHandler.removeCallbacks(this.mScheduledRequest);
                    this.isScheduled = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (this.mNotifyCache != null) {
            this.mNotifyCache.a();
        }
        this.mServer = null;
        this.isWaitingLocTag = false;
        this.inDoorState = false;
        this.mIsStarted = false;
        this.clientFirst = false;
        this.serverFirst = false;
    }

    public void registerNotify(BDNotifyListener bDNotifyListener) {
        Message message = this.mHandler.obtainMessage(9);
        message.obj = bDNotifyListener;
        message.sendToTarget();
    }

    private void onRegisterNotify(Message message) {
        if (message == null || message.obj == null) {
            return;
        }
        BDNotifyListener bDNotifyListener = (BDNotifyListener)message.obj;
        if (this.mNotifyCache == null) {
            this.mNotifyCache = new com.baidu.location.d.a(this.mContext, this);
        }
        this.mNotifyCache.a(bDNotifyListener);
    }

    public void removeNotifyEvent(BDNotifyListener bDNotifyListener) {
        Message message = this.mHandler.obtainMessage(10);
        message.obj = bDNotifyListener;
        message.sendToTarget();
    }

    private void onRemoveNotifyEvent(Message message) {
        if (message == null || message.obj == null) {
            return;
        }
        BDNotifyListener bDNotifyListener = (BDNotifyListener)message.obj;
        if (this.mNotifyCache != null) {
            this.mNotifyCache.c(bDNotifyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetOption(Message message) {
        this.isWaitingLocTag = false;
        if (message == null || message.obj == null) {
            return;
        }
        LocationClientOption locationClientOption = (LocationClientOption)message.obj;
        if (!this.mOption.optionEquals(locationClientOption)) {
            Object object;
            if (this.mOption.scanSpan != locationClientOption.scanSpan) {
                try {
                    object = this.mLock;
                    synchronized (object) {
                        if (this.isScheduled) {
                            this.mHandler.removeCallbacks(this.mScheduledRequest);
                            this.isScheduled = false;
                        }
                        if (locationClientOption.scanSpan >= 1000 && !this.isScheduled) {
                            if (this.mScheduledRequest == null) {
                                this.mScheduledRequest = new b(null);
                            }
                            this.mHandler.postDelayed(this.mScheduledRequest, locationClientOption.scanSpan);
                            this.isScheduled = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mOption = new LocationClientOption(locationClientOption);
            if (this.mServer == null) {
                return;
            }
            try {
                object = Message.obtain(null, (int)15);
                ((Message)object).replyTo = this.mMessenger;
                object.setData(this.getOptionBundle());
                this.mServer.send((Message)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Bundle getOptionBundle() {
        if (this.mOption == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString("packName", this.mPackName);
        bundle.putString("prodName", this.mOption.prodName);
        bundle.putString("coorType", this.mOption.coorType);
        bundle.putString("addrType", this.mOption.addrType);
        bundle.putBoolean("openGPS", this.mOption.openGps);
        bundle.putBoolean("location_change_notify", this.mOption.location_change_notify);
        bundle.putInt("scanSpan", this.mOption.scanSpan);
        bundle.putBoolean("enableSimulateGps", this.mOption.enableSimulateGps);
        bundle.putInt("timeOut", this.mOption.timeOut);
        bundle.putInt("priority", this.mOption.priority);
        bundle.putBoolean("map", this.mConfig_map.booleanValue());
        bundle.putBoolean("import", this.mConfig_preimport.booleanValue());
        bundle.putBoolean("needDirect", this.mOption.mIsNeedDeviceDirect);
        bundle.putBoolean("isneedaptag", this.mOption.isNeedAptag);
        bundle.putBoolean("isneedpoiregion", this.mOption.isNeedPoiRegion);
        bundle.putBoolean("isneedregular", this.mOption.isNeedRegular);
        bundle.putBoolean("isneedaptagd", this.mOption.isNeedAptagd);
        bundle.putBoolean("isneedaltitude", this.mOption.isNeedAltitude);
        bundle.putInt("autoNotifyMaxInterval", this.mOption.getAutoNotifyMaxInterval());
        bundle.putInt("autoNotifyMinTimeInterval", this.mOption.getAutoNotifyMinTimeInterval());
        bundle.putInt("autoNotifyMinDistance", this.mOption.getAutoNotifyMinDistance());
        bundle.putFloat("autoNotifyLocSensitivity", this.mOption.getAutoNotifyLocSensitivity());
        return bundle;
    }

    public void registerNotifyLocationListener(BDLocationListener bDLocationListener) {
        Message message = this.mHandler.obtainMessage(8);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    private void onRegisterNotifyLocationListener(Message message) {
        BDLocationListener bDLocationListener;
        if (message == null || message.obj == null) {
            return;
        }
        this.NotifyLocationListenner = bDLocationListener = (BDLocationListener)message.obj;
    }

    public void registerLocationListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener == null) {
            throw new IllegalStateException("please set a non-null listener");
        }
        Message message = this.mHandler.obtainMessage(5);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    private void onRegisterListener(Message message) {
        if (message == null || message.obj == null) {
            return;
        }
        BDLocationListener bDLocationListener = (BDLocationListener)message.obj;
        if (this.mLocationListeners == null) {
            this.mLocationListeners = new ArrayList();
        }
        if (!this.mLocationListeners.contains(bDLocationListener)) {
            this.mLocationListeners.add(bDLocationListener);
        }
    }

    public void unRegisterLocationListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener == null) {
            throw new IllegalStateException("please set a non-null listener");
        }
        Message message = this.mHandler.obtainMessage(6);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    public boolean startIndoorMode() {
        boolean bl = this.sendServerMessage(110);
        if (bl) {
            this.inDoorState = true;
        }
        return bl;
    }

    public boolean stopIndoorMode() {
        boolean bl = this.sendServerMessage(111);
        if (bl) {
            this.inDoorState = false;
        }
        return bl;
    }

    public boolean requestHotSpotState() {
        if (this.mServer == null || !this.mIsStarted) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)406);
            this.mServer.send(message);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean sendServerMessage(int n2) {
        if (this.mServer == null || !this.mIsStarted) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)n2);
            this.mServer.send(message);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void onUnRegisterListener(Message message) {
        if (message == null || message.obj == null) {
            return;
        }
        BDLocationListener bDLocationListener = (BDLocationListener)message.obj;
        if (this.mLocationListeners != null && this.mLocationListeners.contains(bDLocationListener)) {
            this.mLocationListeners.remove(bDLocationListener);
        }
    }

    private void onRequestNotifyLocation() {
        if (this.mServer == null) {
            return;
        }
        Message message = Message.obtain(null, (int)22);
        try {
            message.replyTo = this.mMessenger;
            this.mServer.send(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequestLocation() {
        Object object;
        if (this.mServer == null) {
            return;
        }
        if (!(System.currentTimeMillis() - this.lastReceiveGpsTime <= 3000L && this.mOption.location_change_notify && !this.isWaitingLocTag || this.inDoorState && System.currentTimeMillis() - this.lastReceiveLocationTime <= 20000L && !this.isWaitingLocTag)) {
            object = Message.obtain(null, (int)22);
            if (this.isWaitingLocTag) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("isWaitingLocTag", this.isWaitingLocTag);
                this.isWaitingLocTag = false;
                object.setData(bundle);
            }
            try {
                object.replyTo = this.mMessenger;
                this.mServer.send(object);
                this.mLastRequestTime = System.currentTimeMillis();
                this.isWaitingForLocation = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mOption != null && this.mOption.scanSpan >= 1000 && !this.isScheduled) {
                if (this.mScheduledRequest == null) {
                    this.mScheduledRequest = new b(null);
                }
                this.mHandler.postDelayed(this.mScheduledRequest, this.mOption.scanSpan);
                this.isScheduled = true;
            }
        }
    }

    private void onNewLocation(Message message, int n2) {
        if (!this.mIsStarted) {
            return;
        }
        try {
            Bundle bundle = message.getData();
            bundle.setClassLoader(BDLocation.class.getClassLoader());
            this.mLastLocation = (BDLocation)bundle.getParcelable("locStr");
            if (this.mLastLocation.getLocType() == 61) {
                this.lastReceiveGpsTime = System.currentTimeMillis();
            }
            this.callListeners(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onNewNotifyLocation(Message message) {
        try {
            Bundle bundle = message.getData();
            bundle.setClassLoader(BDLocation.class.getClassLoader());
            BDLocation bDLocation = (BDLocation)bundle.getParcelable("locStr");
            if (this.NotifyLocationListenner != null) {
                if (this.mOption != null && this.mOption.isDisableCache() && bDLocation.getLocType() == 65) {
                    return;
                }
                this.NotifyLocationListenner.onReceiveLocation(bDLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callListeners(int n2) {
        if (this.mLastLocation.getCoorType() == null) {
            this.mLastLocation.setCoorType(this.mOption.coorType);
        }
        if (this.isWaitingForLocation || this.mOption.location_change_notify && this.mLastLocation.getLocType() == 61 || this.mLastLocation.getLocType() == 66 || this.mLastLocation.getLocType() == 67 || this.inDoorState || this.mLastLocation.getLocType() == 161) {
            if (this.mLocationListeners != null) {
                for (BDLocationListener bDLocationListener : this.mLocationListeners) {
                    bDLocationListener.onReceiveLocation(this.mLastLocation);
                }
            }
            if (this.mLastLocation.getLocType() == 66 || this.mLastLocation.getLocType() == 67) {
                return;
            }
            this.isWaitingForLocation = false;
            this.lastReceiveLocationTime = System.currentTimeMillis();
        }
    }

    public String getAccessKey() {
        try {
            this.mKey = i.b(this.mContext);
            if (TextUtils.isEmpty((CharSequence)this.mKey)) {
                throw new IllegalStateException("please setting key from Manifest.xml");
            }
            return String.format("KEY=%s", this.mKey);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BDLocation getBDLocationInCoorType(BDLocation bDLocation, String string) {
        BDLocation bDLocation2 = new BDLocation(bDLocation);
        double[] dArray = Jni.coorEncrypt(bDLocation.getLongitude(), bDLocation.getLatitude(), string);
        bDLocation2.setLatitude(dArray[1]);
        bDLocation2.setLongitude(dArray[0]);
        return bDLocation2;
    }

    private void sendFirstLoc(BDLocation bDLocation) {
        if (this.isStop) {
            return;
        }
        this.mLastLocation = bDLocation;
        if (!this.serverFirst && bDLocation.getLocType() == 161) {
            this.clientFirst = true;
        }
        if (this.mLocationListeners != null) {
            for (BDLocationListener bDLocationListener : this.mLocationListeners) {
                bDLocationListener.onReceiveLocation(bDLocation);
            }
        }
    }

    @Override
    public void onReceiveLocation(BDLocation bDLocation) {
        if (this.serverFirst && !this.clientFirst) {
            return;
        }
        if (bDLocation == null) {
            return;
        }
        Message message = this.mHandler.obtainMessage(701);
        message.obj = bDLocation;
        message.sendToTarget();
    }

    static /* synthetic */ Messenger access$002(LocationClient locationClient, Messenger messenger) {
        locationClient.mServer = messenger;
        return locationClient.mServer;
    }

    static /* synthetic */ boolean access$102(LocationClient locationClient, boolean bl) {
        locationClient.mIsStarted = bl;
        return locationClient.mIsStarted;
    }

    static /* synthetic */ boolean access$200(LocationClient locationClient) {
        return locationClient.isStop;
    }

    static /* synthetic */ Bundle access$500(LocationClient locationClient) {
        return locationClient.getOptionBundle();
    }

    static /* synthetic */ Boolean access$700(LocationClient locationClient) {
        return locationClient.firstConnected;
    }

    static /* synthetic */ Boolean access$702(LocationClient locationClient, Boolean bl) {
        locationClient.firstConnected = bl;
        return locationClient.firstConnected;
    }

    static /* synthetic */ com.baidu.location.a.b access$800(LocationClient locationClient) {
        return locationClient.mloc;
    }

    static /* synthetic */ com.baidu.location.a.b access$802(LocationClient locationClient, com.baidu.location.a.b b2) {
        locationClient.mloc = b2;
        return locationClient.mloc;
    }

    static /* synthetic */ Context access$900(LocationClient locationClient) {
        return locationClient.mContext;
    }

    private class a
    extends Handler {
        a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 3: {
                    LocationClient.this.onSetOption(message);
                    break;
                }
                case 8: {
                    LocationClient.this.onRegisterNotifyLocationListener(message);
                    break;
                }
                case 5: {
                    LocationClient.this.onRegisterListener(message);
                    break;
                }
                case 6: {
                    LocationClient.this.onUnRegisterListener(message);
                    break;
                }
                case 9: {
                    LocationClient.this.onRegisterNotify(message);
                    break;
                }
                case 10: {
                    LocationClient.this.onRemoveNotifyEvent(message);
                    break;
                }
                case 1: {
                    LocationClient.this.onStart();
                    break;
                }
                case 2: {
                    LocationClient.this.onStop();
                    break;
                }
                case 11: {
                    LocationClient.this.onRequestNotifyLocation();
                    break;
                }
                case 4: {
                    LocationClient.this.onRequestLocation();
                    break;
                }
                case 12: {
                    LocationClient.this.onRequestOffLineLocation();
                    break;
                }
                case 7: {
                    break;
                }
                case 54: {
                    if (!((LocationClient)LocationClient.this).mOption.location_change_notify) break;
                    LocationClient.this.mGpsStatus = true;
                    break;
                }
                case 55: {
                    if (!((LocationClient)LocationClient.this).mOption.location_change_notify) break;
                    LocationClient.this.mGpsStatus = false;
                    break;
                }
                case 21: {
                    Bundle bundle = message.getData();
                    bundle.setClassLoader(BDLocation.class.getClassLoader());
                    BDLocation bDLocation = (BDLocation)bundle.getParcelable("locStr");
                    if (!LocationClient.this.serverFirst && LocationClient.this.clientFirst && bDLocation.getLocType() == 66) break;
                    if (!LocationClient.this.serverFirst && LocationClient.this.clientFirst) {
                        LocationClient.this.serverFirst = true;
                        break;
                    }
                    if (!LocationClient.this.serverFirst) {
                        LocationClient.this.serverFirst = true;
                    }
                    LocationClient.this.onNewLocation(message, 21);
                    break;
                }
                case 26: {
                    LocationClient.this.onNewLocation(message, 26);
                    break;
                }
                case 27: {
                    LocationClient.this.onNewNotifyLocation(message);
                    break;
                }
                case 406: {
                    try {
                        Bundle bundle = message.getData();
                        byte[] byArray = bundle.getByteArray("mac");
                        String string = null;
                        if (byArray != null) {
                            string = new String(byArray, "UTF-8");
                        }
                        int n2 = bundle.getInt("hotspot", -1);
                        if (LocationClient.this.mLocationListeners == null) break;
                        for (BDLocationListener bDLocationListener : LocationClient.this.mLocationListeners) {
                            bDLocationListener.onConnectHotSpotMessage(string, n2);
                        }
                        break;
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case 701: {
                    LocationClient.this.sendFirstLoc((BDLocation)message.obj);
                    break;
                }
                default: {
                    super.handleMessage(message);
                }
            }
        }
    }

    private class b
    implements Runnable {
        private b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LocationClient.this.mLock;
            synchronized (object) {
                LocationClient.this.isScheduled = false;
                if (LocationClient.this.mServer == null || LocationClient.this.mMessenger == null) {
                    return;
                }
                if (LocationClient.this.mLocationListeners == null || LocationClient.this.mLocationListeners.size() < 1) {
                    return;
                }
                if (LocationClient.this.isWaitingLocTag) {
                    if (LocationClient.this.mScheduledRequest == null) {
                        LocationClient.this.mScheduledRequest = new b();
                    }
                    LocationClient.this.mHandler.postDelayed(LocationClient.this.mScheduledRequest, ((LocationClient)LocationClient.this).mOption.scanSpan);
                    return;
                }
                Message message = LocationClient.this.mHandler.obtainMessage(4);
                message.sendToTarget();
            }
        }

        /* synthetic */ b(com.baidu.location.b b2) {
            this();
        }
    }
}

