/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.netbeans.api.visual.widget.Scene;

public final class SatelliteComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
Scene.SceneListener,
ComponentListener {
    private Scene scene;

    public SatelliteComponent(Scene scene) {
        this.scene = scene;
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(128, 128));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.scene.addSceneListener(this);
        JComponent jComponent = this.scene.getView();
        if (jComponent == null) {
            jComponent = this.scene.createView();
        }
        jComponent.addComponentListener(this);
        this.repaint();
    }

    @Override
    public void removeNotify() {
        this.scene.getView().removeComponentListener(this);
        this.scene.removeSceneListener(this);
        super.removeNotify();
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle;
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paint(graphics);
        Rectangle rectangle2 = this.scene.getBounds();
        Dimension dimension = this.getSize();
        double d = rectangle2.width > 0 ? (double)dimension.width / (double)rectangle2.width : 0.0;
        double d2 = rectangle2.width > 0 ? (double)dimension.height / (double)rectangle2.height : 0.0;
        double d3 = Math.min(d, d2);
        int n = (int)(d3 * (double)rectangle2.width);
        int n2 = (int)(d3 * (double)rectangle2.height);
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n3, n4);
        graphics2D.scale(d3, d3);
        this.scene.paint(graphics2D);
        graphics2D.setTransform(affineTransform);
        JComponent jComponent = this.scene.getView();
        double d4 = this.scene.getZoomFactor();
        Rectangle rectangle3 = rectangle = jComponent != null ? jComponent.getVisibleRect() : null;
        if (rectangle != null) {
            Rectangle rectangle4 = new Rectangle((int)((double)rectangle.x * d3 / d4), (int)((double)rectangle.y * d3 / d4), (int)((double)rectangle.width * d3 / d4), (int)((double)rectangle.height * d3 / d4));
            rectangle4.translate(n3, n4);
            graphics2D.setColor(new Color(200, 200, 200, 128));
            graphics2D.fill(rectangle4);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(rectangle4.x, rectangle4.y, rectangle4.width - 1, rectangle4.height - 1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.moveVisibleRect(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.moveVisibleRect(mouseEvent.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveVisibleRect(mouseEvent.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void moveVisibleRect(Point point) {
        JComponent jComponent = this.scene.getView();
        if (jComponent == null) {
            return;
        }
        double d = this.scene.getZoomFactor();
        Rectangle rectangle = this.scene.getBounds();
        Dimension dimension = this.getSize();
        double d2 = rectangle.width > 0 ? (double)dimension.width / (double)rectangle.width : 0.0;
        double d3 = rectangle.width > 0 ? (double)dimension.height / (double)rectangle.height : 0.0;
        double d4 = Math.min(d2, d3);
        int n = (int)(d4 * (double)rectangle.width);
        int n2 = (int)(d4 * (double)rectangle.height);
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        int n5 = (int)((double)(point.x - n3) / d4 * d);
        int n6 = (int)((double)(point.y - n4) / d4 * d);
        Rectangle rectangle2 = jComponent.getVisibleRect();
        rectangle2.x = n5 - rectangle2.width / 2;
        rectangle2.y = n6 - rectangle2.height / 2;
        jComponent.scrollRectToVisible(rectangle2);
    }

    @Override
    public void sceneRepaint() {
        this.repaint();
    }

    @Override
    public void sceneValidating() {
    }

    @Override
    public void sceneValidated() {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

