/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.RefinedSoundex;
import org.junit.Assert;
import org.junit.Test;

public class RefinedSoundexTest
extends StringEncoderAbstractTest<RefinedSoundex> {
    @Override
    protected RefinedSoundex createStringEncoder() {
        return new RefinedSoundex();
    }

    @Test
    public void testDifference() throws EncoderException {
        Assert.assertEquals((long)0L, (long)((RefinedSoundex)this.getStringEncoder()).difference(null, null));
        Assert.assertEquals((long)0L, (long)((RefinedSoundex)this.getStringEncoder()).difference("", ""));
        Assert.assertEquals((long)0L, (long)((RefinedSoundex)this.getStringEncoder()).difference(" ", " "));
        Assert.assertEquals((long)6L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assert.assertEquals((long)3L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Ann", "Andrew"));
        Assert.assertEquals((long)1L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Margaret", "Andrew"));
        Assert.assertEquals((long)1L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Janet", "Margaret"));
        Assert.assertEquals((long)5L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Green", "Greene"));
        Assert.assertEquals((long)1L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Blotchet-Halls", "Greene"));
        Assert.assertEquals((long)6L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assert.assertEquals((long)8L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Smithers", "Smythers"));
        Assert.assertEquals((long)5L, (long)((RefinedSoundex)this.getStringEncoder()).difference("Anothers", "Brothers"));
    }

    @Test
    public void testEncode() {
        Assert.assertEquals((Object)"T6036084", (Object)((RefinedSoundex)this.getStringEncoder()).encode("testing"));
        Assert.assertEquals((Object)"T6036084", (Object)((RefinedSoundex)this.getStringEncoder()).encode("TESTING"));
        Assert.assertEquals((Object)"T60", (Object)((RefinedSoundex)this.getStringEncoder()).encode("The"));
        Assert.assertEquals((Object)"Q503", (Object)((RefinedSoundex)this.getStringEncoder()).encode("quick"));
        Assert.assertEquals((Object)"B1908", (Object)((RefinedSoundex)this.getStringEncoder()).encode("brown"));
        Assert.assertEquals((Object)"F205", (Object)((RefinedSoundex)this.getStringEncoder()).encode("fox"));
        Assert.assertEquals((Object)"J408106", (Object)((RefinedSoundex)this.getStringEncoder()).encode("jumped"));
        Assert.assertEquals((Object)"O0209", (Object)((RefinedSoundex)this.getStringEncoder()).encode("over"));
        Assert.assertEquals((Object)"T60", (Object)((RefinedSoundex)this.getStringEncoder()).encode("the"));
        Assert.assertEquals((Object)"L7050", (Object)((RefinedSoundex)this.getStringEncoder()).encode("lazy"));
        Assert.assertEquals((Object)"D6043", (Object)((RefinedSoundex)this.getStringEncoder()).encode("dogs"));
        Assert.assertEquals((Object)"D6043", (Object)RefinedSoundex.US_ENGLISH.encode("dogs"));
    }

    @Test
    public void testGetMappingCodeNonLetter() {
        char code = ((RefinedSoundex)this.getStringEncoder()).getMappingCode('#');
        Assert.assertEquals((String)"Code does not equals zero", (long)0L, (long)code);
    }

    @Test
    public void testNewInstance() {
        Assert.assertEquals((Object)"D6043", (Object)new RefinedSoundex().soundex("dogs"));
    }

    @Test
    public void testNewInstance2() {
        Assert.assertEquals((Object)"D6043", (Object)new RefinedSoundex("01360240043788015936020505".toCharArray()).soundex("dogs"));
    }

    @Test
    public void testNewInstance3() {
        Assert.assertEquals((Object)"D6043", (Object)new RefinedSoundex("01360240043788015936020505").soundex("dogs"));
    }
}

