/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.util.Arrays;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base32TestData;
import org.apache.commons.codec.binary.BaseNCodec;
import org.junit.Assert;
import org.junit.Test;

public class Base32Test {
    private static final String[][] BASE32_TEST_CASES = new String[][]{{"", ""}, {"f", "MY======"}, {"fo", "MZXQ===="}, {"foo", "MZXW6==="}, {"foob", "MZXW6YQ="}, {"fooba", "MZXW6YTB"}, {"foobar", "MZXW6YTBOI======"}};
    private static final String[][] BASE32HEX_TEST_CASES = new String[][]{{"", ""}, {"f", "CO======"}, {"fo", "CPNG===="}, {"foo", "CPNMU==="}, {"foob", "CPNMUOG="}, {"fooba", "CPNMUOJ1"}, {"foobar", "CPNMUOJ1E8======"}};
    private static final String[][] BASE32_TEST_CASES_CHUNKED = new String[][]{{"", ""}, {"f", "MY======\r\n"}, {"fo", "MZXQ====\r\n"}, {"foo", "MZXW6===\r\n"}, {"foob", "MZXW6YQ=\r\n"}, {"fooba", "MZXW6YTB\r\n"}, {"foobar", "MZXW6YTBOI======\r\n"}};

    @Test
    public void testBase32Samples() throws Exception {
        Base32 codec = new Base32();
        for (String[] element : BASE32_TEST_CASES) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(Charsets.UTF_8)));
        }
    }

    @Test
    public void testBase32HexSamples() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(Charsets.UTF_8)));
        }
    }

    @Test
    public void testBase32Chunked() throws Exception {
        Base32 codec = new Base32(20);
        for (String[] element : BASE32_TEST_CASES_CHUNKED) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(Charsets.UTF_8)));
        }
    }

    @Test
    public void testSingleCharEncoding() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32();
            BaseNCodec.Context context = new BaseNCodec.Context();
            byte[] unencoded = new byte[i];
            byte[] allInOne = codec.encode(unencoded);
            codec = new Base32();
            for (int j = 0; j < unencoded.length; ++j) {
                codec.encode(unencoded, j, 1, context);
            }
            codec.encode(unencoded, 0, -1, context);
            byte[] singly = new byte[allInOne.length];
            codec.readResults(singly, 0, 100, context);
            if (Arrays.equals(allInOne, singly)) continue;
            Assert.fail();
        }
    }

    @Test
    public void testRandomBytes() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32();
            byte[][] b = Base32TestData.randomData((BaseNCodec)codec, i);
            Assert.assertEquals((String)("" + i + " " + codec.lineLength), (long)b[1].length, (long)codec.getEncodedLength(b[0]));
        }
    }

    @Test
    public void testRandomBytesChunked() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32(10);
            byte[][] b = Base32TestData.randomData((BaseNCodec)codec, i);
            Assert.assertEquals((String)("" + i + " " + codec.lineLength), (long)b[1].length, (long)codec.getEncodedLength(b[0]));
        }
    }

    @Test
    public void testRandomBytesHex() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32(true);
            byte[][] b = Base32TestData.randomData((BaseNCodec)codec, i);
            Assert.assertEquals((String)("" + i + " " + codec.lineLength), (long)b[1].length, (long)codec.getEncodedLength(b[0]));
        }
    }
}

