/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server;

import com.x.base.core.project.config.ApplicationServer;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataServer;
import com.x.base.core.project.config.StorageServer;
import com.x.base.core.project.config.WebServer;
import com.x.server.console.server.application.ApplicationServerTools;
import com.x.server.console.server.center.CenterServerTools;
import com.x.server.console.server.data.DataServerTools;
import com.x.server.console.server.data.DataTcpWebServer;
import com.x.server.console.server.storage.StorageServerTools;
import com.x.server.console.server.web.WebServerTools;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.ftpserver.FtpServer;
import org.eclipse.jetty.server.Server;

public class Servers {
    public static Server centerServer;
    public static Server webServer;
    public static Server applicationServer;
    public static FtpServer storageServer;
    public static DataTcpWebServer dataServer;

    public static Boolean webServerIsRunning() {
        if (null == webServer) {
            return false;
        }
        return webServer.isRunning();
    }

    public static Boolean applicationServerIsRunning() {
        if (null == applicationServer) {
            return false;
        }
        return applicationServer.isRunning();
    }

    public static Boolean centerServerIsRunning() {
        if (null == centerServer) {
            return false;
        }
        return centerServer.isRunning();
    }

    public static Boolean storageServerIsRunning() {
        if (null == storageServer) {
            return false;
        }
        return !storageServer.isStopped();
    }

    public static Boolean dataServerIsRunning() {
        if (null == dataServer) {
            return false;
        }
        return dataServer.isRunning();
    }

    public static void startWebServer() throws Exception {
        if (Servers.webServerIsRunning().booleanValue()) {
            throw new Exception("web server is running.");
        }
        WebServer server = Config.currentNode().getWeb();
        if (null == server) {
            throw new Exception("not config webServer.");
        }
        if (!BooleanUtils.isTrue((Boolean)server.getEnable())) {
            throw new Exception("webServer not enable.");
        }
        webServer = WebServerTools.start(server);
    }

    public static void stopWebServer() throws Exception {
        if (!Servers.webServerIsRunning().booleanValue()) {
            throw new Exception("web server is not running.");
        }
        webServer.stop();
    }

    public static void startApplicationServer() throws Exception {
        if (Servers.applicationServerIsRunning().booleanValue()) {
            throw new Exception("application server is running.");
        }
        ApplicationServer server = Config.currentNode().getApplication();
        if (null == server) {
            throw new Exception("not config applicationServer.");
        }
        if (!BooleanUtils.isTrue((Boolean)server.getEnable())) {
            throw new Exception("applicationServer not enable.");
        }
        applicationServer = ApplicationServerTools.start(server);
    }

    public static void stopApplicationServer() throws Exception {
        if (!Servers.applicationServerIsRunning().booleanValue()) {
            throw new Exception("application server is not running.");
        }
        applicationServer.stop();
    }

    public static void startCenterServer() throws Exception {
        if (Servers.centerServerIsRunning().booleanValue()) {
            throw new Exception("center server is running.");
        }
        if (BooleanUtils.isTrue((Boolean)Config.currentNode().getIsPrimaryCenter())) {
            centerServer = CenterServerTools.start(Config.centerServer());
        }
    }

    public static void stopCenterServer() throws Exception {
        if (!Servers.centerServerIsRunning().booleanValue()) {
            throw new Exception("center server is not running.");
        }
        centerServer.stop();
    }

    public static void startStorageServer() throws Exception {
        if (Servers.storageServerIsRunning().booleanValue()) {
            throw new Exception("storage server is running.");
        }
        StorageServer server = Config.currentNode().getStorage();
        if (null == server) {
            throw new Exception("not config storagaeServer.");
        }
        if (!BooleanUtils.isTrue((Boolean)server.getEnable())) {
            throw new Exception("storagaeServer not enable.");
        }
        storageServer = StorageServerTools.start(server);
    }

    public static void stopStorageServer() throws Exception {
        if (!Servers.storageServerIsRunning().booleanValue()) {
            throw new Exception("storage server is not running.");
        }
        storageServer.stop();
    }

    public static void startDataServer() throws Exception {
        if (Servers.dataServerIsRunning().booleanValue()) {
            throw new Exception("data server is running.");
        }
        DataServer server = Config.currentNode().getData();
        if (null == server) {
            throw new Exception("not config dataServer.");
        }
        if (!BooleanUtils.isTrue((Boolean)server.getEnable())) {
            throw new Exception("dataServer not enable.");
        }
        dataServer = DataServerTools.start(server);
    }

    public static void stopDataServer() throws Exception {
        if (!Servers.dataServerIsRunning().booleanValue()) {
            throw new Exception("data server is not running.");
        }
        dataServer.stop();
    }
}

