/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server.application;

import com.x.base.core.project.AssembleA;
import com.x.base.core.project.ServiceA;
import com.x.base.core.project.config.ApplicationServer;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.ListTools;
import com.x.server.console.server.JettySeverTools;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.PropertiesConfigurationManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;

public class ApplicationServerTools
extends JettySeverTools {
    private static String project_class_prefix = "com.x.base.core.project.";
    private static Logger logger = LoggerFactory.getLogger(ApplicationServerTools.class);
    private static int APPLICATIONSERVER_THREAD_POOL_SIZE_MIN = 10;
    private static int APPLICATIONSERVER_THREAD_POOL_SIZE_MAX = 50;

    public static Server start(ApplicationServer applicationServer) throws Exception {
        File commonsDir = new File(Config.base(), "commons");
        File webappsDir = new File(Config.base(), "servers/applicationServer/webapps");
        File workDir = new File(Config.base(), "servers/applicationServer/work");
        File extDir = new File(Config.base(), "commons/ext");
        File storeDir = new File(Config.base(), "store");
        File jarsDir = new File(Config.base(), "store/jars");
        if (BooleanUtils.isTrue((Boolean)applicationServer.getRedeploy())) {
            ApplicationServerTools.cleanDirectory(workDir);
            ApplicationServerTools.cleanDirectory(webappsDir);
            List<Class<?>> classes = ApplicationServerTools.calculateProjectToDepoly();
            for (Class<?> clz : classes) {
                File war = new File(storeDir, clz.getSimpleName() + ".war");
                if (!war.exists()) continue;
                FileUtils.forceMkdir((File)new File(workDir, clz.getSimpleName()));
                ApplicationServerTools.createDeployDescriptor(clz, webappsDir, workDir, storeDir, extDir, jarsDir);
            }
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(APPLICATIONSERVER_THREAD_POOL_SIZE_MIN);
        threadPool.setMaxThreads(APPLICATIONSERVER_THREAD_POOL_SIZE_MAX);
        Server server = new Server((ThreadPool)threadPool);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)server);
        classlist.addAfter(FragmentConfiguration.class.getName(), new String[]{EnvConfiguration.class.getName(), PlusConfiguration.class.getName()});
        classlist.addBefore(JettyWebXmlConfiguration.class.getName(), new String[]{AnnotationConfiguration.class.getName()});
        if (applicationServer.getSslEnable().booleanValue()) {
            ApplicationServerTools.addHttpsConnector(server, applicationServer.getPort());
        } else {
            ApplicationServerTools.addHttpConnector(server, applicationServer.getPort());
        }
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DeploymentManager deployer = new DeploymentManager();
        deployer.setContextAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", (Object)"nothing.jar");
        deployer.setContexts(contexts);
        WebAppProvider webAppProvider = new WebAppProvider();
        webAppProvider.setMonitoredDirName(webappsDir.getAbsolutePath());
        webAppProvider.setDefaultsDescriptor(new File(commonsDir, "webdefault_a.xml").getAbsolutePath());
        webAppProvider.setScanInterval(applicationServer.getScanInterval().intValue());
        webAppProvider.setExtractWars(true);
        webAppProvider.setConfigurationManager((ConfigurationManager)new PropertiesConfigurationManager());
        deployer.addAppProvider((AppProvider)webAppProvider);
        server.addBean((Object)deployer);
        GzipHandler gzipHandler = new GzipHandler();
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setShowContexts(false);
        defaultHandler.setServeIcon(false);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        gzipHandler.setHandler((Handler)handlers);
        server.setHandler((Handler)gzipHandler);
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        server.start();
        logger.print("application server start completed on port:{}.", new Object[]{applicationServer.getPort()});
        return server;
    }

    private static List<Class<?>> calculateProjectToDepoly() throws Exception {
        ScanResult scanResult = new FastClasspathScanner(new String[]{"com.x"}).scan();
        List list = new ArrayList();
        list.addAll(scanResult.getNamesOfSubclassesOf(AssembleA.class));
        list.addAll(scanResult.getNamesOfSubclassesOf(ServiceA.class));
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        if (ListTools.isNotEmpty((List[])new List[]{Config.currentNode().getApplication().getIncludes()})) {
            for (String str : Config.currentNode().getApplication().getIncludes()) {
                if (!StringUtils.startsWith((CharSequence)str, (CharSequence)project_class_prefix)) {
                    str = project_class_prefix + str;
                }
                includes.add(str);
            }
        }
        if (ListTools.isNotEmpty((List[])new List[]{Config.currentNode().getApplication().getExcludes()})) {
            for (String str : Config.currentNode().getApplication().getExcludes()) {
                if (!StringUtils.startsWith((CharSequence)str, (CharSequence)project_class_prefix)) {
                    str = project_class_prefix + str;
                }
                excludes.add(str);
            }
        }
        list = ListTools.includesExcludesWildcard(list, includes, excludes);
        ArrayList clzs = new ArrayList();
        for (String o : list) {
            clzs.add(Class.forName(o));
        }
        return clzs;
    }
}

