/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server.storage;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;

public class StorageUserManager
implements UserManager {
    private List<? extends User> users = new ArrayList<User>();

    public StorageUserManager(List<? extends User> users) {
        this.users = users;
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            User user;
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String name = upauth.getUsername();
            String password = upauth.getPassword();
            if (name == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            try {
                user = this.getUserByName(name);
            }
            catch (FtpException e) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (null == user) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (StringUtils.equals((CharSequence)user.getPassword(), (CharSequence)password)) {
                return user;
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        if (authentication instanceof AnonymousAuthentication) {
            throw new AuthenticationFailedException("Authentication failed");
        }
        throw new IllegalArgumentException("Authentication not supported by this user manager");
    }

    public void delete(String arg0) throws FtpException {
    }

    public boolean doesExist(String arg) throws FtpException {
        User user = this.getUserByName(arg);
        return null != user;
    }

    public String getAdminName() {
        return "xadmin";
    }

    public String[] getAllUserNames() throws FtpException {
        String[] names = new String[this.users.size()];
        for (int i = 0; i < this.users.size(); ++i) {
            names[i] = this.users.get(i).getName();
        }
        return names;
    }

    public User getUserByName(String arg) throws FtpException {
        for (User user : this.users) {
            if (!StringUtils.equals((CharSequence)user.getName(), (CharSequence)arg)) continue;
            return user;
        }
        return null;
    }

    public boolean isAdmin(String arg) throws FtpException {
        return StringUtils.equals((CharSequence)"xadmin", (CharSequence)arg);
    }

    public void save(User arg0) throws FtpException {
    }
}

