/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.binary.BaseNCodec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseNCodecTest {
    BaseNCodec codec;

    @Before
    public void setUp() {
        this.codec = new BaseNCodec(0, 0, 0, 0){

            protected boolean isInAlphabet(byte b) {
                return b == 79 || b == 75;
            }

            void encode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
            }

            void decode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
            }
        };
    }

    @Test
    public void testBaseNCodec() {
        Assert.assertNotNull((Object)this.codec);
    }

    @Test
    public void testIsWhiteSpace() {
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)32));
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)10));
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)13));
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)9));
    }

    @Test
    public void testIsInAlphabetByte() {
        Assert.assertFalse((boolean)this.codec.isInAlphabet((byte)0));
        Assert.assertFalse((boolean)this.codec.isInAlphabet((byte)97));
        Assert.assertTrue((boolean)this.codec.isInAlphabet((byte)79));
        Assert.assertTrue((boolean)this.codec.isInAlphabet((byte)75));
    }

    @Test
    public void testIsInAlphabetByteArrayBoolean() {
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[0], false));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79}, false));
        Assert.assertFalse((boolean)this.codec.isInAlphabet(new byte[]{79, 32}, false));
        Assert.assertFalse((boolean)this.codec.isInAlphabet(new byte[]{32}, false));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[0], true));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79}, true));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79, 32}, true));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{32}, true));
    }

    @Test
    public void testIsInAlphabetString() {
        Assert.assertTrue((boolean)this.codec.isInAlphabet("OK"));
        Assert.assertTrue((boolean)this.codec.isInAlphabet("O=K= \t\n\r"));
    }

    @Test
    public void testContainsAlphabetOrPad() {
        Assert.assertFalse((boolean)this.codec.containsAlphabetOrPad(null));
        Assert.assertFalse((boolean)this.codec.containsAlphabetOrPad(new byte[0]));
        Assert.assertTrue((boolean)this.codec.containsAlphabetOrPad("OK".getBytes()));
        Assert.assertTrue((boolean)this.codec.containsAlphabetOrPad("OK ".getBytes()));
        Assert.assertFalse((boolean)this.codec.containsAlphabetOrPad("ok ".getBytes()));
        byte[] byArray = new byte[1];
        this.codec.getClass();
        byArray[0] = 61;
        Assert.assertTrue((boolean)this.codec.containsAlphabetOrPad(byArray));
    }
}

