/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.http.EffectivePerson;
import com.x.base.core.project.tools.JarTools;
import com.x.server.console.action.ActionBase;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ActionConfig
extends ActionBase {
    public boolean execute() throws Exception {
        if (!Config.currentNode().getIsPrimaryCenter().booleanValue()) {
            byte[] bytes = this.getZip();
            this.unzip(bytes);
            System.out.println("synchronize config success, should to restart server.");
            return true;
        }
        System.out.println("config command only synchronize config from primary center.");
        return false;
    }

    private byte[] getZip() throws Exception {
        String center = Config.nodes().primaryCenterNode();
        String address = "http://" + center + ":" + Config.centerServer().getPort() + "/x_program_center/jaxrs/config";
        URL url = new URL(address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        EffectivePerson effectivePerson = EffectivePerson.cipher((String)Config.token().getCipher());
        connection.setRequestProperty("x-token", effectivePerson.getToken());
        connection.setRequestMethod("GET");
        connection.setDoOutput(false);
        connection.setDoInput(true);
        connection.connect();
        String json = null;
        try (InputStream input = connection.getInputStream();){
            json = IOUtils.toString((InputStream)input);
        }
        JsonElement jsonElement = (JsonElement)XGsonBuilder.instance().fromJson(json, JsonElement.class);
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("type")) {
                if (StringUtils.equals((CharSequence)"success", (CharSequence)jsonObject.get("type").getAsString())) {
                    String value = jsonObject.get("data").getAsString();
                    byte[] bytes = Base64.decodeBase64((String)value);
                    return bytes;
                }
                throw new Exception("return type not success.");
            }
            throw new Exception("can not read return type.");
        }
        throw new Exception("return object is not jsonObject.");
    }

    private void unzip(byte[] bytes) throws Exception {
        File dir = new File(Config.base(), "config");
        FileUtils.forceMkdir((File)dir);
        JarTools.unjar((byte[])bytes, (String)"", (File)dir, (boolean)true);
    }
}

