/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.Gson;
import com.x.base.core.entity.JpaObject;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataMapping;
import com.x.base.core.project.config.DataMappings;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DateTools;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.base.core.project.tools.ListTools;
import com.x.server.console.action.DumpRestoreDataCatalog;
import com.x.server.console.action.PersistenceXmlHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class ActionDumpData {
    private static Logger logger = LoggerFactory.getLogger(ActionDumpData.class);
    private Date start;
    private File dir;
    private DumpRestoreDataCatalog catalog;
    private Gson pureGsonDateFormated;

    private void init() throws Exception {
        this.start = new Date();
        this.dir = new File(Config.base(), "local/dump/dumpData_" + DateTools.compact((Date)this.start));
        this.catalog = new DumpRestoreDataCatalog();
        this.pureGsonDateFormated = XGsonBuilder.instance();
        FileUtils.forceMkdir((File)this.dir);
        FileUtils.cleanDirectory((File)this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String password) throws Exception {
        this.init();
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
            logger.print("password not match.", new Object[0]);
            return false;
        }
        List<Class<?>> classes = PersistenceXmlHelper.listClassWithIncludesExcludes(PersistenceXmlHelper.listDataClassName(), Config.dumpRestoreData().getIncludes(), Config.dumpRestoreData().getExcludes());
        logger.print("dump data find {} data to dump, start at {}.", new Object[]{classes.size(), DateTools.format((Date)this.start)});
        DataMappings mappings = Config.dataMappings();
        for (int i = 0; i < classes.size(); ++i) {
            Class<?> cls = classes.get(i);
            List sources = (List)mappings.get((Object)cls.getName());
            if (ListTools.isEmpty((List[])new List[]{sources})) {
                throw new Exception("can not get datamapping of class:" + cls.getName() + ".");
            }
            OpenJPAEntityManagerFactory emf = OpenJPAPersistence.createEntityManagerFactory((String)cls.getName(), (String)this.createPersistenceXml(cls, sources).getName());
            EntityManager em = emf.createEntityManager();
            try {
                logger.print("dump data({}/{}): {}, count: {}.", new Object[]{i + 1, classes.size(), cls.getName(), this.estimateCount(em, cls)});
                this.dump(cls, em);
            }
            finally {
                em.close();
                emf.close();
            }
            System.gc();
        }
        FileUtils.write((File)new File(this.dir, "catalog.json"), (CharSequence)this.pureGsonDateFormated.toJson((Object)this.catalog), (Charset)DefaultCharset.charset);
        logger.print("dump data completed, directory: {}, count: {}, elapsed: {} minutes.", new Object[]{this.dir.getAbsolutePath(), this.count(), (new Date().getTime() - this.start.getTime()) / 1000L / 60L});
        return true;
    }

    private <T extends JpaObject> long estimateCount(EntityManager em, Class<T> cls) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(cls);
        cq.select((Selection)cb.count((Expression)root));
        return (Long)em.createQuery(cq).getSingleResult();
    }

    private Integer count() {
        return this.catalog.values().stream().mapToInt(Integer::intValue).sum();
    }

    private <T> File createPersistenceXml(Class<T> cls, List<DataMapping> sources) throws Exception {
        File xml = new File(this.dir, cls.getName() + "_dump.xml");
        PersistenceXmlHelper.createPersistenceXml(cls, sources, xml);
        File tempFile = File.createTempFile(DateTools.compact((Date)this.start), ".xml", new File(Config.base(), "local/temp/classes"));
        FileUtils.copyFile((File)xml, (File)tempFile);
        return tempFile;
    }

    private <T> void dump(Class<T> cls, EntityManager em) throws Exception {
        File directory = new File(this.dir, cls.getName());
        FileUtils.forceMkdir((File)directory);
        FileUtils.cleanDirectory((File)directory);
        int count = 0;
        int size = Config.dumpRestoreData().getBatchSize();
        String id = "";
        List<T> list = null;
        do {
            list = this.list(em, cls, id, size);
            if (ListTools.isNotEmpty((List[])new List[]{list})) {
                id = BeanUtils.getProperty(list.get(list.size() - 1), (String)"id");
                File file = new File(directory, (count += list.size()) + ".json");
                FileUtils.write((File)file, (CharSequence)this.pureGsonDateFormated.toJson(list), (Charset)DefaultCharset.charset);
            }
            em.clear();
        } while (ListTools.isNotEmpty((List[])new List[]{list}));
        this.catalog.put(cls.getName(), count);
    }

    private <T> List<T> list(EntityManager em, Class<T> cls, String id, Integer size) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(cls);
        Root root = cq.from(cls);
        Predicate p = cb.conjunction();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            p = cb.greaterThan((Expression)root.get("id"), (Comparable)((Object)id));
        }
        cq.select((Selection)root).where((Expression)p).orderBy(new Order[]{cb.asc((Expression)root.get("id"))});
        return em.createQuery(cq).setMaxResults(size.intValue()).getResultList();
    }
}

