/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server.data;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataServer;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.server.console.server.data.DataTcpWebServer;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.h2.tools.Server;

public class DataServerTools {
    private static Logger logger = LoggerFactory.getLogger(DataServerTools.class);

    public static DataTcpWebServer start(DataServer dataServer) throws Exception {
        File dataBaseDir = new File(Config.base(), "local/repository/data");
        FileUtils.forceMkdir((File)dataBaseDir);
        Server tcpServer = null;
        Server webServer = null;
        String password = Config.token().getPassword();
        String[] tcps = new String[]{"-tcp", "-tcpAllowOthers", "-tcpPort", dataServer.getTcpPort().toString(), "-baseDir", dataBaseDir.getAbsolutePath(), "-tcpPassword", password};
        tcpServer = Server.createTcpServer((String[])tcps).start();
        Integer webPort = dataServer.getWebPort();
        if (null != webPort && webPort > 0) {
            String[] webs = new String[]{"-web", "-webAllowOthers", "-webPort", webPort.toString()};
            webServer = Server.createWebServer((String[])webs).start();
        }
        logger.print("data server start on port:{}, web console on port:{}.", new Object[]{dataServer.getTcpPort(), dataServer.getWebPort()});
        return new DataTcpWebServer(tcpServer, webServer);
    }
}

