/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DateTools;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CleanLogTask
implements Job {
    private static Logger logger = LoggerFactory.getLogger(CleanLogTask.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            File[] files;
            Date now = new Date();
            File dir = new File(Config.base(), "logs");
            RegexFileFilter fileFilter = new RegexFileFilter("^20[1-9][0-9]_[0-1][0-9]_[0-3][0-9].out.log(.*)$");
            for (File f : files = dir.listFiles((FileFilter)fileFilter)) {
                String name = FilenameUtils.getBaseName((String)f.getName());
                String value = StringUtils.substringBefore((String)name, (String)".");
                Date date = DateTools.parse((String)value, (String)"yyyy_MM_dd");
                if (now.getTime() - date.getTime() <= (long)(86400000 * Config.currentNode().logSize())) continue;
                logger.print("\u5220\u9664\u65e7\u7684\u65e5\u5fd7\u6587\u4ef6:{}.", new Object[]{f.getAbsolutePath()});
                FileUtils.forceDelete((File)f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

