/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.server.console.action.ActionDumpData;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DumpDataTask
implements Job {
    private static Logger logger = LoggerFactory.getLogger(DumpDataTask.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            logger.print("schedule dump data task running.", new Object[0]);
            ActionDumpData action = new ActionDumpData();
            action.execute(Config.token().getPassword());
            if (Config.currentNode().dumpData().size() > 0) {
                File dir = new File(Config.base(), "local/dump");
                List<Object> list = new ArrayList<File>();
                if (dir.exists() && dir.isDirectory()) {
                    for (File f : FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)FalseFileFilter.FALSE, (IOFileFilter)new RegexFileFilter("^dumpData_[1,2][0,9][0-9][0-9][0,1][0-9][0-3][0-9][0-5][0-9][0-5][0-9][0-5][0-9]$"))) {
                        if (dir == f) continue;
                        list.add(f);
                    }
                    if ((list = list.stream().sorted(Comparator.comparing(File::getName).reversed()).collect(Collectors.toList())).size() > Config.currentNode().dumpData().size()) {
                        for (int i = Config.currentNode().dumpData().size().intValue(); i < list.size(); ++i) {
                            File file = (File)list.get(i);
                            logger.print("dumpDataTask delete:{}.", new Object[]{file.getAbsolutePath()});
                            FileUtils.forceDelete((File)file);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

