/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console;

import com.x.base.core.project.config.ApplicationServer;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataServer;
import com.x.base.core.project.config.StorageServer;
import com.x.base.core.project.config.WebServer;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.server.console.CommandFactory;
import com.x.server.console.NodeAgent;
import com.x.server.console.SchedulerBuilder;
import com.x.server.console.SystemOutErrorSideCopyBuilder;
import com.x.server.console.action.ActionCompactData;
import com.x.server.console.action.ActionConfig;
import com.x.server.console.action.ActionCreateEncryptKey;
import com.x.server.console.action.ActionDumpData;
import com.x.server.console.action.ActionDumpStorage;
import com.x.server.console.action.ActionEraseContentBbs;
import com.x.server.console.action.ActionEraseContentCms;
import com.x.server.console.action.ActionEraseContentLog;
import com.x.server.console.action.ActionEraseContentProcessPlatform;
import com.x.server.console.action.ActionEraseContentReport;
import com.x.server.console.action.ActionRestoreData;
import com.x.server.console.action.ActionRestoreStorage;
import com.x.server.console.action.ActionSetPassword;
import com.x.server.console.action.ActionShowCpu;
import com.x.server.console.action.ActionShowMemory;
import com.x.server.console.action.ActionShowOs;
import com.x.server.console.action.ActionShowThread;
import com.x.server.console.action.ActionUpdate;
import com.x.server.console.action.ActionVersion;
import com.x.server.console.log.LogTools;
import com.x.server.console.server.Servers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.quartz.Scheduler;

public class Main {
    private static final String MANIFEST_FILENAME = "manifest.cfg";
    private static final String GITIGNORE_FILENAME = ".gitignore";

    public static void main(String[] args) throws Exception {
        String base = Main.getBasePath();
        Main.scanWar(base);
        Main.loadJars(base);
        Main.cleanTempDir();
        Main.createTempClassesDirectory();
        SystemOutErrorSideCopyBuilder.start();
        if (null == Config.currentNode()) {
            throw new Exception("\u65e0\u6cd5\u627e\u5230\u5f53\u524d\u8282\u70b9,\u8bf7\u68c0\u67e5config/node_{name}.json\u4e0elocal/node.cfg\u6587\u4ef6\u5185\u5bb9\u4e2d\u7684\u540d\u79f0\u662f\u5426\u4e00\u81f4.");
        }
        LogTools.setSlf4jSimple();
        CommandFactory.printStartHelp();
        try (PipedInputStream pipedInput = new PipedInputStream();
             final PipedOutputStream pipedOutput = new PipedOutputStream(pipedInput);){
            new Thread(){

                @Override
                public void run() {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(Config.base() + "/command.swap", "rw");
                        Throwable throwable = null;
                        try {
                            try {
                                FileChannel fc = raf.getChannel();
                                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, 0L, 256L);
                                byte[] fillBytes = new byte[256];
                                byte[] readBytes = new byte[256];
                                Arrays.fill(fillBytes, (byte)0);
                                mbb.put(fillBytes);
                                FileLock flock = null;
                                String cmd = "";
                                while (true) {
                                    flock = fc.lock();
                                    mbb.position(0);
                                    mbb.get(readBytes, 0, 256);
                                    mbb.position(0);
                                    mbb.put(fillBytes);
                                    flock.release();
                                    if (!Arrays.equals(readBytes, fillBytes)) {
                                        cmd = StringUtils.trim((String)new String(readBytes, DefaultCharset.charset));
                                        System.out.println("read command:" + cmd);
                                        pipedOutput.write((cmd + "\n").getBytes(DefaultCharset.name));
                                    }
                                    Thread.sleep(4000L);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (raf != null) {
                                if (throwable != null) {
                                    try {
                                        raf.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    raf.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                        String cmd = "";
                        while (null != cmd) {
                            cmd = reader.readLine();
                            if (null != cmd) {
                                cmd = cmd + "\n";
                                pipedOutput.write(cmd.getBytes(DefaultCharset.name));
                                pipedOutput.flush();
                            }
                            Thread.sleep(1000L);
                        }
                        System.out.println("console input closed!");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            if (BooleanUtils.isTrue((Boolean)Config.currentNode().nodeAgentEnable())) {
                NodeAgent nodeAgent = new NodeAgent();
                nodeAgent.start();
            }
            SchedulerBuilder schedulerBuilder = new SchedulerBuilder();
            Scheduler scheduler = schedulerBuilder.start();
            Matcher matcher = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(pipedInput));){
                String cmd = "";
                block87: while (true) {
                    try {
                        cmd = reader.readLine();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)cmd)) continue;
                    matcher = CommandFactory.test_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.test();
                        continue;
                    }
                    matcher = CommandFactory.show_os_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.showOs(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    matcher = CommandFactory.show_cpu_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.showCpu(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    matcher = CommandFactory.show_memory_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.showMemory(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    matcher = CommandFactory.show_thread_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.showThread(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    matcher = CommandFactory.start_pattern.matcher(cmd);
                    if (matcher.find()) {
                        switch (matcher.group(1)) {
                            case "application": {
                                Main.startApplicationServer();
                                continue block87;
                            }
                            case "center": {
                                Main.startCenterServer();
                                continue block87;
                            }
                            case "web": {
                                Main.startWebServer();
                                continue block87;
                            }
                            case "storage": {
                                Main.startStorageServer();
                                continue block87;
                            }
                            case "data": {
                                Main.startDataServer();
                                continue block87;
                            }
                        }
                        Main.startAll();
                        continue;
                    }
                    matcher = CommandFactory.stop_pattern.matcher(cmd);
                    if (matcher.find()) {
                        switch (matcher.group(1)) {
                            case "application": {
                                Main.stopApplicationServer();
                                continue block87;
                            }
                            case "center": {
                                Main.stopCenterServer();
                                continue block87;
                            }
                            case "web": {
                                Main.stopWebServer();
                                continue block87;
                            }
                            case "storage": {
                                Main.stopStorageServer();
                                continue block87;
                            }
                            case "data": {
                                Main.stopDataServer();
                                continue block87;
                            }
                        }
                        Main.stopAll();
                        continue;
                    }
                    matcher = CommandFactory.dump_pattern.matcher(cmd);
                    if (matcher.find()) {
                        switch (matcher.group(1)) {
                            case "data": {
                                Main.dumpData(matcher.group(2));
                                break;
                            }
                            case "storage": {
                                Main.dumpStorage(matcher.group(2));
                                break;
                            }
                        }
                        continue;
                    }
                    matcher = CommandFactory.restore_pattern.matcher(cmd);
                    if (matcher.find()) {
                        switch (matcher.group(1)) {
                            case "data": {
                                Main.resotreData(matcher.group(2), matcher.group(3));
                                break;
                            }
                            case "storage": {
                                Main.resotreStorage(matcher.group(2), matcher.group(3));
                                break;
                            }
                        }
                        continue;
                    }
                    matcher = CommandFactory.help_pattern.matcher(cmd);
                    if (matcher.find()) {
                        CommandFactory.printHelp();
                        continue;
                    }
                    matcher = CommandFactory.version_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.version();
                        continue;
                    }
                    matcher = CommandFactory.update_pattern.matcher(cmd);
                    if (matcher.find()) {
                        if (!Main.update(matcher.group(1))) continue;
                        Main.stopAll();
                        System.exit(0);
                    }
                    if ((matcher = CommandFactory.fastUpdate_pattern.matcher(cmd)).find()) {
                        if (!Main.fastUpdate(matcher.group(1))) continue;
                        Main.stopAll();
                        System.exit(0);
                    }
                    if ((matcher = CommandFactory.setPassword_pattern.matcher(cmd)).find()) {
                        Main.setPassword(matcher.group(1), matcher.group(2));
                        if (!Main.config()) continue;
                        break;
                    }
                    matcher = CommandFactory.erase_content_pattern.matcher(cmd);
                    if (matcher.find()) {
                        switch (matcher.group(1)) {
                            case "pp": {
                                Main.eraseContentProcessPlatform(matcher.group(2));
                                break;
                            }
                            case "cms": {
                                Main.eraseContentCms(matcher.group(2));
                                break;
                            }
                            case "log": {
                                Main.eraseContentLog(matcher.group(2));
                                break;
                            }
                            case "report": {
                                Main.eraseContentReport(matcher.group(2));
                                break;
                            }
                            case "bbs": {
                                Main.eraseContentBbs(matcher.group(2));
                                break;
                            }
                        }
                        continue;
                    }
                    matcher = CommandFactory.compact_data_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.compactData(matcher.group(1));
                        continue;
                    }
                    matcher = CommandFactory.create_encrypt_key_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.createEncryptKey(matcher.group(1));
                        continue;
                    }
                    matcher = CommandFactory.exit_pattern.matcher(cmd);
                    if (matcher.find()) {
                        Main.exit();
                    }
                    System.out.println("unknown command:" + cmd);
                }
            }
            scheduler.shutdown();
        }
        SystemOutErrorSideCopyBuilder.stop();
    }

    private static boolean test() {
        try {
            DeploymentManager deployer = (DeploymentManager)Servers.applicationServer.getBean(DeploymentManager.class);
            for (App app : deployer.getApps()) {
                System.out.println(app.getContextPath());
                if (!StringUtils.equals((CharSequence)"/x_query_assemble_designer", (CharSequence)app.getContextPath())) continue;
                app.getContextHandler().stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean showOs(String interval, String repeat) {
        try {
            return new ActionShowOs().execute(Integer.parseInt(interval, 10), Integer.parseInt(repeat, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static boolean showCpu(String interval, String repeat) {
        try {
            return new ActionShowCpu().execute(Integer.parseInt(interval, 10), Integer.parseInt(repeat, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static boolean showMemory(String interval, String repeat) {
        try {
            return new ActionShowMemory().execute(Integer.parseInt(interval, 10), Integer.parseInt(repeat, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static boolean showThread(String interval, String repeat) {
        try {
            return new ActionShowThread().execute(Integer.parseInt(interval, 10), Integer.parseInt(repeat, 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static boolean createEncryptKey(String password) {
        try {
            return new ActionCreateEncryptKey().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static boolean fastUpdate(String password) {
        try {
            return new ActionUpdate().execute(password, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static boolean update(String password) {
        try {
            return new ActionUpdate().execute(password, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static void version() {
        try {
            new ActionVersion().execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean config() {
        try {
            return new ActionConfig().execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static void startDataServer() {
        try {
            if (Servers.dataServerIsRunning().booleanValue()) {
                System.out.println("data server is running.");
            } else {
                Servers.startDataServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopDataServer() {
        try {
            if (!Servers.dataServerIsRunning().booleanValue()) {
                System.out.println("data server is not running.");
            } else {
                Servers.stopDataServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startStorageServer() {
        try {
            if (Servers.storageServerIsRunning().booleanValue()) {
                System.out.println("storage server is running.");
            } else {
                Servers.startStorageServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopStorageServer() {
        try {
            if (!Servers.storageServerIsRunning().booleanValue()) {
                System.out.println("storage server is not running.");
            } else {
                Servers.stopStorageServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startApplicationServer() {
        try {
            if (Servers.applicationServerIsRunning().booleanValue()) {
                System.out.println("application server is running.");
            } else {
                Servers.startApplicationServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopApplicationServer() {
        try {
            if (!Servers.applicationServerIsRunning().booleanValue()) {
                System.out.println("application server is not running.");
            } else {
                Servers.stopApplicationServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startCenterServer() {
        try {
            if (Servers.centerServerIsRunning().booleanValue()) {
                System.out.println("center server is running.");
            } else {
                Servers.startCenterServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopCenterServer() {
        try {
            if (!Servers.centerServerIsRunning().booleanValue()) {
                System.out.println("center server is not running.");
            } else {
                Servers.stopCenterServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startWebServer() {
        try {
            if (Servers.webServerIsRunning().booleanValue()) {
                System.out.println("web server is running.");
            } else {
                Servers.startWebServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopWebServer() {
        try {
            if (!Servers.webServerIsRunning().booleanValue()) {
                System.out.println("web server is not running.");
            } else {
                Servers.stopWebServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startAll() {
        try {
            WebServer webServer;
            ApplicationServer applicationServer;
            StorageServer storageServer;
            DataServer dataServer = Config.currentNode().getData();
            if (null != dataServer && BooleanUtils.isTrue((Boolean)dataServer.getEnable())) {
                Main.startDataServer();
            }
            if (null != (storageServer = Config.currentNode().getStorage()) && BooleanUtils.isTrue((Boolean)storageServer.getEnable())) {
                Main.startStorageServer();
            }
            if (Config.currentNode().getIsPrimaryCenter().booleanValue()) {
                Main.startCenterServer();
            }
            if (null != (applicationServer = Config.currentNode().getApplication()) && BooleanUtils.isTrue((Boolean)applicationServer.getEnable())) {
                Main.startApplicationServer();
            }
            if (null != (webServer = Config.currentNode().getWeb()) && BooleanUtils.isTrue((Boolean)webServer.getEnable())) {
                Main.startWebServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void exit() {
        Main.stopAll();
        System.exit(0);
    }

    private static void stopAll() {
        try {
            DataServer dataServer;
            StorageServer storageServer;
            ApplicationServer applicationServer;
            WebServer webServer = Config.currentNode().getWeb();
            if (null != webServer && BooleanUtils.isTrue((Boolean)webServer.getEnable())) {
                Main.stopWebServer();
            }
            if (null != (applicationServer = Config.currentNode().getApplication()) && BooleanUtils.isTrue((Boolean)applicationServer.getEnable())) {
                Main.stopApplicationServer();
            }
            if (Config.currentNode().getIsPrimaryCenter().booleanValue()) {
                Main.stopCenterServer();
            }
            if (null != (storageServer = Config.currentNode().getStorage()) && BooleanUtils.isTrue((Boolean)storageServer.getEnable())) {
                Main.stopStorageServer();
            }
            if (null != (dataServer = Config.currentNode().getData()) && BooleanUtils.isTrue((Boolean)dataServer.getEnable())) {
                Main.stopDataServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dumpData(String password) {
        try {
            new ActionDumpData().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dumpStorage(String password) {
        try {
            new ActionDumpStorage().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void resotreData(String dateString, String password) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = format.parse(dateString);
            File file = new File(Config.base(), "local/dump/dumpData_" + format.format(date));
            if (file.exists() && file.isDirectory()) {
                new ActionRestoreData().execute(date, password);
            } else {
                System.out.println("directory " + file.getAbsolutePath() + " not existed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void resotreStorage(String dateString, String password) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = format.parse(dateString);
            File file = new File(Config.base(), "local/dump/dumpStorage_" + format.format(date));
            if (file.exists() && file.isDirectory()) {
                ActionRestoreStorage restoreStorage = new ActionRestoreStorage();
                restoreStorage.execute(date, password);
            } else {
                System.out.println("directory " + file.getAbsolutePath() + " not existed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createTempClassesDirectory() throws Exception {
        File tempDir = new File(Config.base(), "local/temp/classes");
        FileUtils.forceMkdir((File)tempDir);
        FileUtils.cleanDirectory((File)tempDir);
    }

    private static void scanWar(String base) throws Exception {
        File dir = new File(base, "store");
        File manifest = new File(dir, MANIFEST_FILENAME);
        if (!manifest.exists() || manifest.isDirectory()) {
            throw new Exception("can not find manifest.cfg in store.");
        }
        List<String> manifestNames = Main.readManifest(manifest);
        for (File o : dir.listFiles()) {
            if (o.isDirectory() && o.getName().equals("jars") || o.getName().equals(MANIFEST_FILENAME) || o.getName().equals(GITIGNORE_FILENAME) || manifestNames.contains(o.getName())) continue;
            System.out.println("\u626b\u63cf store \u8fc7\u7a0b\u4e2d\u5220\u9664\u65e0\u6548\u7684\u6587\u4ef6:" + o.getName());
            o.delete();
        }
    }

    private static void loadJars(String base) throws Exception {
        File jarsDir;
        File jarsDirManifest;
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        File extDir = new File(base, "commons/ext");
        File extDirManifest = new File(extDir, MANIFEST_FILENAME);
        if (!extDirManifest.exists()) {
            throw new Exception("can not find manifest.cfg in commons/ext.");
        }
        List<String> extDirManifestNames = Main.readManifest(extDirManifest);
        if (extDirManifestNames.isEmpty()) {
            throw new Exception("commons/ext manifest is empty.");
        }
        for (File file : extDir.listFiles()) {
            if (file.getName().equals(MANIFEST_FILENAME) || file.getName().equals(GITIGNORE_FILENAME)) continue;
            if (!extDirManifestNames.remove(file.getName())) {
                System.out.println("\u8f7d\u5165 commons/ext \u8fc7\u7a0b\u4e2d\u5220\u9664\u65e0\u6548\u7684\u6587\u4ef6:" + file.getName());
                file.delete();
                continue;
            }
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
        }
        if (!extDirManifestNames.isEmpty()) {
            for (String str : extDirManifestNames) {
                System.out.println("\u8f7d\u5165 commons/ext \u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u627e\u5230\u6587\u4ef6:" + str);
            }
        }
        if (!(jarsDirManifest = new File(jarsDir = new File(base, "store/jars"), MANIFEST_FILENAME)).exists()) {
            throw new Exception("can not find manifest.cfg in store/jars.");
        }
        List<String> jarsDirManifestNames = Main.readManifest(jarsDirManifest);
        for (File file : jarsDir.listFiles()) {
            if (file.getName().equals(MANIFEST_FILENAME) || file.getName().equals(GITIGNORE_FILENAME)) continue;
            if (!jarsDirManifestNames.remove(file.getName())) {
                System.out.println("\u8f7d\u5165 store/jars \u8fc7\u7a0b\u4e2d\u5220\u9664\u65e0\u6548\u7684\u6587\u4ef6:" + file.getName());
                file.delete();
                continue;
            }
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
        }
        if (!jarsDirManifestNames.isEmpty()) {
            for (String str : jarsDirManifestNames) {
                System.out.println("\u8f7d\u5165 store/jars \u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u627e\u5230\u6587\u4ef6:" + str);
            }
        }
        File tempDir = new File(base, "local/temp/classes");
        method.invoke((Object)urlClassLoader, tempDir.toURI().toURL());
    }

    private static String getBasePath() throws Exception {
        String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File file = new File(path);
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (null != file) {
            File versionFile = new File(file, "version.o2");
            if (versionFile.exists()) {
                return file.getAbsolutePath();
            }
            file = file.getParentFile();
        }
        throw new Exception("can not define o2server base directory.");
    }

    private static void cleanTempDir() throws Exception {
        File file = new File(Config.base(), "local/temp");
        FileUtils.forceMkdir((File)file);
        FileUtils.cleanDirectory((File)file);
    }

    private static List<String> readManifest(File file) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    private static boolean setPassword(String oldPassword, String newPassword) throws Exception {
        try {
            return new ActionSetPassword().execute(oldPassword, newPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean compactData(String password) throws Exception {
        try {
            return new ActionCompactData().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean eraseContentProcessPlatform(String password) throws Exception {
        try {
            return new ActionEraseContentProcessPlatform().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean eraseContentCms(String password) throws Exception {
        try {
            return new ActionEraseContentCms().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean eraseContentBbs(String password) throws Exception {
        try {
            return new ActionEraseContentBbs().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean eraseContentLog(String password) throws Exception {
        try {
            return new ActionEraseContentLog().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean eraseContentReport(String password) throws Exception {
        try {
            return new ActionEraseContentReport().execute(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

